/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.NestedProcessor;
import org.mule.api.annotations.InvalidateConnectionOn;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.api.annotations.oauth.OAuthAccessToken;
import org.mule.api.annotations.oauth.OAuthAccessTokenSecret;
import org.mule.api.annotations.param.InboundHeaders;
import org.mule.api.annotations.param.InvocationHeaders;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.annotations.param.Payload;
import org.mule.api.callback.HttpCallback;
import org.mule.api.callback.SourceCallback;
import org.mule.api.oauth.NotAuthorizedException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.Block;
import org.mule.devkit.model.code.Cast;
import org.mule.devkit.model.code.CatchBlock;
import org.mule.devkit.model.code.Conditional;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.ForEach;
import org.mule.devkit.model.code.ForLoop;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TryStatement;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.mule.transformer.TransformerTemplate;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;

public class MessageProcessorGenerator
extends AbstractMessageGenerator {
    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return true;
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) {
        for (ExecutableElement executableElement : typeElement.getMethodsAnnotatedWith(Processor.class)) {
            this.generateMessageProcessor(typeElement, executableElement);
        }
    }

    private void generateMessageProcessor(DevKitTypeElement typeElement, ExecutableElement executableElement) {
        boolean intercepting = executableElement.getAnnotation(Processor.class).intercepting();
        DefinedClass messageProcessorClass = intercepting ? this.getInterceptingMessageProcessorClass(executableElement) : this.getMessageProcessorClass(executableElement);
        this.generateMessageProcessorClassDoc(executableElement, messageProcessorClass);
        Map<String, AbstractMessageGenerator.FieldVariableElement> fields = this.generateProcessorFieldForEachParameter(messageProcessorClass, executableElement);
        ExecutableElement connectMethod = this.connectMethodForClass(typeElement);
        Map<String, AbstractMessageGenerator.FieldVariableElement> connectFields = null;
        if (connectMethod != null) {
            connectFields = this.generateProcessorFieldForEachParameter(messageProcessorClass, connectMethod);
        }
        FieldVariable logger = this.generateLoggerField(messageProcessorClass);
        FieldVariable object = this.generateFieldForModuleObject(messageProcessorClass, typeElement);
        FieldVariable muleContext = this.generateFieldForMuleContext(messageProcessorClass);
        FieldVariable expressionManager = this.generateFieldForExpressionManager(messageProcessorClass);
        FieldVariable patternInfo = this.generateFieldForPatternInfo(messageProcessorClass);
        FieldVariable flowConstruct = this.generateFieldForFlowConstruct(messageProcessorClass);
        FieldVariable retryCount = this.generateRetryCountField(messageProcessorClass);
        FieldVariable retryMax = this.generateRetryMaxField(messageProcessorClass);
        FieldVariable messageProcessorListener = null;
        if (intercepting) {
            messageProcessorListener = this.generateFieldForMessageProcessorListener(messageProcessorClass);
        }
        this.generateInitialiseMethod(messageProcessorClass, fields, typeElement, muleContext, expressionManager, patternInfo, object, retryCount);
        this.generateStartMethod(messageProcessorClass, fields);
        this.generateStopMethod(messageProcessorClass, fields);
        this.generateDiposeMethod(messageProcessorClass, fields);
        this.generateSetMuleContextMethod(messageProcessorClass, muleContext, fields);
        this.generateSetFlowConstructMethod(messageProcessorClass, flowConstruct, fields);
        if (intercepting) {
            this.generateSetListenerMethod(messageProcessorClass, messageProcessorListener);
            this.generateSourceCallbackProcessMethod(messageProcessorClass, messageProcessorListener, muleContext, flowConstruct);
            this.generateSourceCallbackProcessWithPropertiesMethod(messageProcessorClass, messageProcessorListener, muleContext, flowConstruct);
            this.generateSourceCallbackProcessMethodWithNoPayload(messageProcessorClass, messageProcessorListener, muleContext, flowConstruct);
        }
        this.generateSetModuleObjectMethod(messageProcessorClass, object);
        this.generateSetter(messageProcessorClass, retryMax);
        for (String fieldName : fields.keySet()) {
            this.generateSetter(messageProcessorClass, fields.get(fieldName).getField());
        }
        if (connectFields != null) {
            for (String fieldName : connectFields.keySet()) {
                this.generateSetter(messageProcessorClass, connectFields.get(fieldName).getField());
            }
        }
        this.generateComputeClassHierarchyMethod(messageProcessorClass);
        this.generateIsListClassMethod(messageProcessorClass);
        this.generateIsMapClassMethod(messageProcessorClass);
        this.generateIsListMethod(messageProcessorClass);
        this.generateIsMapMethod(messageProcessorClass);
        this.generateIsAssignableFrom(messageProcessorClass);
        this.generateEvaluateMethod(messageProcessorClass, patternInfo, expressionManager);
        this.generateEvaluateAndTransformMethod(messageProcessorClass, muleContext);
        if (typeElement.isPoolable()) {
            DefinedClass poolObjectClass = this.context.getClassForRole(this.context.getNameUtils().generatePoolObjectRoleKey(typeElement));
            this.generateProcessMethod(executableElement, messageProcessorClass, fields, connectFields, messageProcessorListener, muleContext, object, poolObjectClass, logger, retryCount, retryMax);
        } else {
            this.generateProcessMethod(executableElement, messageProcessorClass, fields, connectFields, messageProcessorListener, muleContext, object, logger, retryCount, retryMax);
        }
    }

    private void generateEvaluateAndTransformMethod(DefinedClass messageProcessorClass, FieldVariable muleContext) {
        Method evaluateAndTransform = messageProcessorClass.method(4, (org.mule.devkit.model.code.Type)this.ref(Object.class), "evaluateAndTransform");
        evaluateAndTransform._throws(this.ref(TransformerException.class));
        Variable muleMessage = evaluateAndTransform.param((org.mule.devkit.model.code.Type)this.ref(MuleMessage.class), "muleMessage");
        Variable expectedType = evaluateAndTransform.param((org.mule.devkit.model.code.Type)this.ref(Type.class), "expectedType");
        Variable source = evaluateAndTransform.param((org.mule.devkit.model.code.Type)this.ref(Object.class), "source");
        evaluateAndTransform.body()._if(Op.eq((Expression)source, (Expression)ExpressionFactory._null()))._then()._return((Expression)source);
        Variable target = evaluateAndTransform.body().decl((org.mule.devkit.model.code.Type)this.ref(Object.class), "target", ExpressionFactory._null());
        Conditional isList = evaluateAndTransform.body()._if((Expression)ExpressionFactory.invoke((String)"isList").arg((Expression)source.invoke("getClass")));
        Conditional isExpectedList = isList._then()._if((Expression)ExpressionFactory.invoke((String)"isList").arg((Expression)expectedType));
        Variable newList = isExpectedList._then().decl((org.mule.devkit.model.code.Type)this.ref(List.class), "newList", (Expression)ExpressionFactory._new((TypeReference)this.ref(ArrayList.class)));
        Variable listParameterizedType = isExpectedList._then().decl((org.mule.devkit.model.code.Type)this.ref(Type.class), "valueType", (Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class), (Expression)expectedType).invoke("getActualTypeArguments").component(ExpressionFactory.lit((int)0)));
        Variable listIterator = isExpectedList._then().decl((org.mule.devkit.model.code.Type)this.ref(ListIterator.class), "iterator", (Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(List.class), (Expression)source).invoke("listIterator"));
        Block whileHasNext = isExpectedList._then()._while((Expression)listIterator.invoke("hasNext")).body();
        Variable subTarget = whileHasNext.decl((org.mule.devkit.model.code.Type)this.ref(Object.class), "subTarget", (Expression)listIterator.invoke("next"));
        whileHasNext.add((Statement)newList.invoke("add").arg((Expression)ExpressionFactory.invoke((String)"evaluateAndTransform").arg((Expression)muleMessage).arg((Expression)listParameterizedType).arg((Expression)subTarget)));
        isExpectedList._then().assign((AssignmentTarget)target, (Expression)newList);
        isExpectedList._else().assign((AssignmentTarget)target, (Expression)source);
        Conditional isMap = isList._elseif((Expression)ExpressionFactory.invoke((String)"isMap").arg((Expression)source.invoke("getClass")));
        Conditional isExpectedMap = isMap._then()._if((Expression)ExpressionFactory.invoke((String)"isMap").arg((Expression)expectedType));
        Block isExpectedMapBlock = isExpectedMap._then();
        Variable keyType = isExpectedMapBlock.decl((org.mule.devkit.model.code.Type)this.ref(Type.class), "keyType", this.ref(Object.class).dotclass());
        Variable valueType = isExpectedMapBlock.decl((org.mule.devkit.model.code.Type)this.ref(Type.class), "valueType", this.ref(Object.class).dotclass());
        Block isGenericMap = isExpectedMapBlock._if(Op._instanceof((Expression)expectedType, (org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class)))._then();
        isGenericMap.assign((AssignmentTarget)keyType, (Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class), (Expression)expectedType).invoke("getActualTypeArguments").component(ExpressionFactory.lit((int)0)));
        isGenericMap.assign((AssignmentTarget)valueType, (Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class), (Expression)expectedType).invoke("getActualTypeArguments").component(ExpressionFactory.lit((int)1)));
        Variable map = isExpectedMapBlock.decl((org.mule.devkit.model.code.Type)this.ref(Map.class), "map", (Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Map.class), (Expression)source));
        Variable newMap = isExpectedMapBlock.decl((org.mule.devkit.model.code.Type)this.ref(Map.class), "newMap", (Expression)ExpressionFactory._new((TypeReference)this.ref(HashMap.class)));
        ForEach forEach = isExpectedMapBlock.forEach((org.mule.devkit.model.code.Type)this.ref(Object.class), "entryObj", (Expression)map.invoke("entrySet"));
        Block forEachBlock = forEach.body().block();
        Variable entry = forEachBlock.decl((org.mule.devkit.model.code.Type)this.ref(Map.Entry.class), "entry", (Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Map.Entry.class), (Expression)forEach.var()));
        Variable newKey = forEachBlock.decl((org.mule.devkit.model.code.Type)this.ref(Object.class), "newKey", (Expression)ExpressionFactory.invoke((String)"evaluateAndTransform").arg((Expression)muleMessage).arg((Expression)keyType).arg((Expression)entry.invoke("getKey")));
        Variable newValue = forEachBlock.decl((org.mule.devkit.model.code.Type)this.ref(Object.class), "newValue", (Expression)ExpressionFactory.invoke((String)"evaluateAndTransform").arg((Expression)muleMessage).arg((Expression)valueType).arg((Expression)entry.invoke("getValue")));
        forEachBlock.invoke((Expression)newMap, "put").arg((Expression)newKey).arg((Expression)newValue);
        isExpectedMapBlock.assign((AssignmentTarget)target, (Expression)newMap);
        isExpectedMap._else().assign((AssignmentTarget)target, (Expression)source);
        Block otherwise = isMap._else();
        otherwise.assign((AssignmentTarget)target, (Expression)ExpressionFactory.invoke((String)"evaluate").arg((Expression)muleMessage).arg((Expression)source));
        Conditional shouldTransform = evaluateAndTransform.body()._if(Op.cand((Expression)Op.ne((Expression)target, (Expression)ExpressionFactory._null()), (Expression)Op.not((Expression)ExpressionFactory.invoke((String)"isAssignableFrom").arg((Expression)expectedType).arg((Expression)target.invoke("getClass")))));
        Variable sourceDataType = shouldTransform._then().decl((org.mule.devkit.model.code.Type)this.ref(DataType.class), "sourceDataType", (Expression)this.ref(DataTypeFactory.class).staticInvoke("create").arg((Expression)target.invoke("getClass")));
        Variable targetDataType = shouldTransform._then().decl((org.mule.devkit.model.code.Type)this.ref(DataType.class), "targetDataType", (Expression)this.ref(DataTypeFactory.class).staticInvoke("create").arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Class.class), (Expression)expectedType)));
        Variable transformer = shouldTransform._then().decl((org.mule.devkit.model.code.Type)this.ref(Transformer.class), "t", (Expression)muleContext.invoke("getRegistry").invoke("lookupTransformer").arg((Expression)sourceDataType).arg((Expression)targetDataType));
        shouldTransform._then()._return((Expression)transformer.invoke("transform").arg((Expression)target));
        shouldTransform._else()._return((Expression)target);
    }

    private void generateIsAssignableFrom(DefinedClass messageProcessorClass) {
        Method isAssignableFrom = messageProcessorClass.method(4, (org.mule.devkit.model.code.Type)this.context.getCodeModel().BOOLEAN, "isAssignableFrom");
        Variable expectedType = isAssignableFrom.param((org.mule.devkit.model.code.Type)this.ref(Type.class), "expectedType");
        Variable clazz = isAssignableFrom.param((org.mule.devkit.model.code.Type)this.ref(Class.class), "clazz");
        Block isClass = isAssignableFrom.body()._if(Op._instanceof((Expression)expectedType, (org.mule.devkit.model.code.Type)this.ref(Class.class)))._then();
        isClass._return((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Class.class), (Expression)expectedType).invoke("isAssignableFrom").arg((Expression)clazz));
        Block isParameterizedType = isAssignableFrom.body()._if(Op._instanceof((Expression)expectedType, (org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class)))._then();
        isParameterizedType._return((Expression)ExpressionFactory.invoke((String)"isAssignableFrom").arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class), (Expression)expectedType).invoke("getRawType")).arg((Expression)clazz));
        Block isWildcardType = isAssignableFrom.body()._if(Op._instanceof((Expression)expectedType, (org.mule.devkit.model.code.Type)this.ref(WildcardType.class)))._then();
        Variable upperBounds = isWildcardType.decl((org.mule.devkit.model.code.Type)this.ref(Type.class).array(), "upperBounds", (Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(WildcardType.class), (Expression)expectedType).invoke("getUpperBounds"));
        Block ifHasUpperBounds = isWildcardType._if(Op.ne((Expression)upperBounds.ref("length"), (Expression)ExpressionFactory.lit((int)0)))._then();
        ifHasUpperBounds._return((Expression)ExpressionFactory.invoke((String)"isAssignableFrom").arg((Expression)upperBounds.component(ExpressionFactory.lit((int)0))).arg((Expression)clazz));
        isAssignableFrom.body()._return(ExpressionFactory.FALSE);
    }

    private void generateEvaluateMethod(DefinedClass messageProcessorClass, FieldVariable patternInfo, FieldVariable expressionManager) {
        Method evaluate = messageProcessorClass.method(4, (org.mule.devkit.model.code.Type)this.ref(Object.class), "evaluate");
        Variable muleMessage = evaluate.param((org.mule.devkit.model.code.Type)this.ref(MuleMessage.class), "muleMessage");
        Variable source = evaluate.param((org.mule.devkit.model.code.Type)this.ref(Object.class), "source");
        Block ifString = evaluate.body()._if(Op._instanceof((Expression)source, (org.mule.devkit.model.code.Type)this.ref(String.class)))._then();
        Variable stringSource = ifString.decl((org.mule.devkit.model.code.Type)this.ref(String.class), "stringSource", (Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(String.class), (Expression)source));
        Conditional isPattern = ifString._if(Op.cand((Expression)stringSource.invoke("startsWith").arg((Expression)patternInfo.invoke("getPrefix")), (Expression)stringSource.invoke("endsWith").arg((Expression)patternInfo.invoke("getSuffix"))));
        isPattern._then()._return((Expression)expressionManager.invoke("evaluate").arg((Expression)stringSource).arg((Expression)muleMessage));
        isPattern._else()._return((Expression)expressionManager.invoke("parse").arg((Expression)stringSource).arg((Expression)muleMessage));
        evaluate.body()._return((Expression)source);
    }

    private void generateIsListMethod(DefinedClass messageProcessorClass) {
        Method isList = messageProcessorClass.method(4, (org.mule.devkit.model.code.Type)this.context.getCodeModel().BOOLEAN, "isList");
        Variable type = isList.param((org.mule.devkit.model.code.Type)this.ref(Type.class), "type");
        Conditional isClass = isList.body()._if(Op.cand((Expression)Op._instanceof((Expression)type, (org.mule.devkit.model.code.Type)this.ref(Class.class)), (Expression)ExpressionFactory.invoke((String)"isListClass").arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Class.class), (Expression)type))));
        isClass._then()._return(ExpressionFactory.TRUE);
        Conditional isParameterizedType = isList.body()._if(Op._instanceof((Expression)type, (org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class)));
        isParameterizedType._then()._return((Expression)ExpressionFactory.invoke((String)"isList").arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class), (Expression)type).invoke("getRawType")));
        Conditional isWildcardType = isList.body()._if(Op._instanceof((Expression)type, (org.mule.devkit.model.code.Type)this.ref(WildcardType.class)));
        Variable upperBounds = isWildcardType._then().decl((org.mule.devkit.model.code.Type)this.ref(Type.class).array(), "upperBounds", (Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(WildcardType.class), (Expression)type).invoke("getUpperBounds"));
        isWildcardType._then()._return(Op.cand((Expression)Op.ne((Expression)upperBounds.ref("length"), (Expression)ExpressionFactory.lit((int)0)), (Expression)ExpressionFactory.invoke((String)"isList").arg((Expression)upperBounds.component(ExpressionFactory.lit((int)0)))));
        isList.body()._return(ExpressionFactory.FALSE);
    }

    private void generateIsMapMethod(DefinedClass messageProcessorClass) {
        Method isMap = messageProcessorClass.method(4, (org.mule.devkit.model.code.Type)this.context.getCodeModel().BOOLEAN, "isMap");
        Variable type = isMap.param((org.mule.devkit.model.code.Type)this.ref(Type.class), "type");
        Conditional isClass = isMap.body()._if(Op.cand((Expression)Op._instanceof((Expression)type, (org.mule.devkit.model.code.Type)this.ref(Class.class)), (Expression)ExpressionFactory.invoke((String)"isMapClass").arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Class.class), (Expression)type))));
        isClass._then()._return(ExpressionFactory.TRUE);
        Conditional isParameterizedType = isMap.body()._if(Op._instanceof((Expression)type, (org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class)));
        isParameterizedType._then()._return((Expression)ExpressionFactory.invoke((String)"isMap").arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class), (Expression)type).invoke("getRawType")));
        Conditional isWildcardType = isMap.body()._if(Op._instanceof((Expression)type, (org.mule.devkit.model.code.Type)this.ref(WildcardType.class)));
        Variable upperBounds = isWildcardType._then().decl((org.mule.devkit.model.code.Type)this.ref(Type.class).array(), "upperBounds", (Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(WildcardType.class), (Expression)type).invoke("getUpperBounds"));
        isWildcardType._then()._return(Op.cand((Expression)Op.ne((Expression)upperBounds.ref("length"), (Expression)ExpressionFactory.lit((int)0)), (Expression)ExpressionFactory.invoke((String)"isMap").arg((Expression)upperBounds.component(ExpressionFactory.lit((int)0)))));
        isMap.body()._return(ExpressionFactory.FALSE);
    }

    private void generateIsListClassMethod(DefinedClass messageProcessorClass) {
        Method isListClass = messageProcessorClass.method(4, (org.mule.devkit.model.code.Type)this.context.getCodeModel().BOOLEAN, "isListClass");
        isListClass.javadoc().add((Object)"Checks whether the specified class parameter is an instance of ");
        isListClass.javadoc().add((Object)this.ref(List.class));
        isListClass.javadoc().addParam("clazz <code>Class</code> to check.");
        isListClass.javadoc().addReturn("<code>true</code> is <code>clazz</code> is instance of a collection class, <code>false</code> otherwise.");
        Variable clazz = isListClass.param((org.mule.devkit.model.code.Type)this.ref(Class.class), "clazz");
        Variable classes = isListClass.body().decl((org.mule.devkit.model.code.Type)this.ref(List.class).narrow(this.ref(Class.class)), "classes", (Expression)ExpressionFactory._new((TypeReference)this.ref(ArrayList.class).narrow(this.ref(Class.class))));
        isListClass.body().invoke("computeClassHierarchy").arg((Expression)clazz).arg((Expression)classes);
        isListClass.body()._return((Expression)classes.invoke("contains").arg(this.ref(List.class).dotclass()));
    }

    private void generateIsMapClassMethod(DefinedClass messageProcessorClass) {
        Method isMapClass = messageProcessorClass.method(4, (org.mule.devkit.model.code.Type)this.context.getCodeModel().BOOLEAN, "isMapClass");
        isMapClass.javadoc().add((Object)"Checks whether the specified class parameter is an instance of ");
        isMapClass.javadoc().add((Object)this.ref(Map.class));
        isMapClass.javadoc().addParam("clazz <code>Class</code> to check.");
        isMapClass.javadoc().addReturn("<code>true</code> is <code>clazz</code> is instance of a collection class, <code>false</code> otherwise.");
        Variable clazz = isMapClass.param((org.mule.devkit.model.code.Type)this.ref(Class.class), "clazz");
        Variable classes = isMapClass.body().decl((org.mule.devkit.model.code.Type)this.ref(List.class).narrow(this.ref(Class.class)), "classes", (Expression)ExpressionFactory._new((TypeReference)this.ref(ArrayList.class).narrow(this.ref(Class.class))));
        isMapClass.body().invoke("computeClassHierarchy").arg((Expression)clazz).arg((Expression)classes);
        isMapClass.body()._return((Expression)classes.invoke("contains").arg(this.ref(Map.class).dotclass()));
    }

    private void generateComputeClassHierarchyMethod(DefinedClass messageProcessorClass) {
        Method computeClassHierarchy = messageProcessorClass.method(4, (org.mule.devkit.model.code.Type)this.context.getCodeModel().VOID, "computeClassHierarchy");
        computeClassHierarchy.javadoc().add((Object)"Get all superclasses and interfaces recursively.");
        computeClassHierarchy.javadoc().addParam("clazz   The class to start the search with.");
        computeClassHierarchy.javadoc().addParam("classes List of classes to which to add all found super classes and interfaces.");
        Variable clazz = computeClassHierarchy.param(Class.class, "clazz");
        Variable classes = computeClassHierarchy.param(List.class, "classes");
        ForLoop iterateClasses = computeClassHierarchy.body()._for();
        Variable current = iterateClasses.init((org.mule.devkit.model.code.Type)this.ref(Class.class), "current", (Expression)clazz);
        iterateClasses.test(Op.ne((Expression)current, (Expression)ExpressionFactory._null()));
        iterateClasses.update(current.assign((Expression)current.invoke("getSuperclass")));
        Block ifContains = iterateClasses.body()._if((Expression)classes.invoke("contains").arg((Expression)current))._then();
        ifContains._return();
        iterateClasses.body().add((Statement)classes.invoke("add").arg((Expression)current));
        ForEach iterateInterfaces = iterateClasses.body().forEach((org.mule.devkit.model.code.Type)this.ref(Class.class), "currentInterface", (Expression)current.invoke("getInterfaces"));
        iterateInterfaces.body().invoke("computeClassHierarchy").arg((Expression)iterateInterfaces.var()).arg((Expression)classes);
    }

    private void generateMessageProcessorClassDoc(ExecutableElement executableElement, DefinedClass messageProcessorClass) {
        messageProcessorClass.javadoc().add((Object)(messageProcessorClass.name() + " invokes the "));
        messageProcessorClass.javadoc().add((Object)("{@link " + ((TypeElement)executableElement.getEnclosingElement()).getQualifiedName().toString() + "#"));
        messageProcessorClass.javadoc().add((Object)(executableElement.getSimpleName().toString() + "("));
        boolean first = true;
        for (VariableElement variableElement : executableElement.getParameters()) {
            if (!first) {
                messageProcessorClass.javadoc().add((Object)", ");
            }
            messageProcessorClass.javadoc().add((Object)((Object)variableElement.asType()).toString().replaceAll("<[a-zA-Z\\-\\.\\<\\>\\s\\,]*>", ""));
            first = false;
        }
        messageProcessorClass.javadoc().add((Object)")} method in ");
        messageProcessorClass.javadoc().add((Object)this.ref(executableElement.getEnclosingElement().asType()));
        messageProcessorClass.javadoc().add((Object)". For each argument there is a field in this processor to match it. ");
        messageProcessorClass.javadoc().add((Object)" Before invoking the actual method the processor will evaluate and transform");
        messageProcessorClass.javadoc().add((Object)" where possible to the expected argument type.");
    }

    private void generateProcessMethod(ExecutableElement executableElement, DefinedClass messageProcessorClass, Map<String, AbstractMessageGenerator.FieldVariableElement> fields, Map<String, AbstractMessageGenerator.FieldVariableElement> connectionFields, FieldVariable messageProcessorListener, FieldVariable muleContext, FieldVariable object, FieldVariable logger, FieldVariable retryCount, FieldVariable retryMax) {
        this.generateProcessMethod(executableElement, messageProcessorClass, fields, connectionFields, messageProcessorListener, muleContext, object, null, logger, retryCount, retryMax);
    }

    private void generateProcessMethod(ExecutableElement executableElement, DefinedClass messageProcessorClass, Map<String, AbstractMessageGenerator.FieldVariableElement> fields, Map<String, AbstractMessageGenerator.FieldVariableElement> connectionFields, FieldVariable messageProcessorListener, FieldVariable muleContext, FieldVariable object, DefinedClass poolObjectClass, FieldVariable logger, FieldVariable retryCount, FieldVariable retryMax) {
        String methodName = executableElement.getSimpleName().toString();
        TypeReference muleEvent = this.ref(MuleEvent.class);
        Method process = messageProcessorClass.method(1, (org.mule.devkit.model.code.Type)muleEvent, "process");
        process.javadoc().add((Object)"Invokes the MessageProcessor.");
        process.javadoc().addParam("event MuleEvent to be processed");
        process.javadoc().addThrows(this.ref(MuleException.class));
        process._throws(MuleException.class);
        Variable event = process.param((org.mule.devkit.model.code.Type)muleEvent, "event");
        Variable muleMessage = process.body().decl((org.mule.devkit.model.code.Type)this.ref(MuleMessage.class), "muleMessage", (Expression)event.invoke("getMessage"));
        DefinedClass moduleObjectClass = this.context.getClassForRole(this.context.getNameUtils().generateModuleObjectRoleKey((TypeElement)executableElement.getEnclosingElement()));
        Variable moduleObject = process.body().decl((org.mule.devkit.model.code.Type)moduleObjectClass, "castedModuleObject", ExpressionFactory._null());
        this.findConfig(process.body(), muleContext, object, methodName, event, moduleObjectClass, moduleObject);
        Variable poolObject = this.declarePoolObjectIfClassNotNull(poolObjectClass, process);
        this.addOAuthFieldIfNeeded(executableElement, process, event, moduleObject);
        Map<String, Expression> connectionParameters = this.declareConnectionParametersVariables(executableElement, connectionFields, process);
        Variable connection = this.addConnectionVariableIfNeeded(executableElement, process);
        ExecutableElement connectMethod = this.connectForMethod(executableElement);
        ExecutableElement connectionIdentifierMethod = this.connectionIdentifierForMethod(executableElement);
        TryStatement callProcessor = process.body()._try();
        if (connectMethod != null) {
            for (VariableElement variableElement : connectMethod.getParameters()) {
                String fieldName = variableElement.getSimpleName().toString();
                Conditional ifNotNull = callProcessor.body()._if(Op.ne((Expression)connectionFields.get(fieldName).getField(), (Expression)ExpressionFactory._null()));
                TypeReference typeReference = this.ref(connectionFields.get(fieldName).getVariableElement().asType()).boxify();
                Variable variable = (Variable)connectionParameters.get(fieldName);
                Invocation getGenericType = messageProcessorClass.dotclass().invoke("getDeclaredField").arg(ExpressionFactory.lit((String)connectionFields.get(fieldName).getFieldType().name())).invoke("getGenericType");
                Invocation evaluateAndTransform = ExpressionFactory.invoke((String)"evaluateAndTransform").arg((Expression)muleMessage).arg((Expression)getGenericType);
                evaluateAndTransform.arg((Expression)connectionFields.get(fieldName).getField());
                Cast cast = ExpressionFactory.cast((org.mule.devkit.model.code.Type)typeReference, (Expression)evaluateAndTransform);
                ifNotNull._then().assign((AssignmentTarget)variable, (Expression)cast);
                Invocation invocation = ExpressionFactory.invoke((String)"evaluateAndTransform").arg((Expression)muleMessage).arg((Expression)getGenericType);
                invocation.arg((Expression)moduleObject.invoke("get" + StringUtils.capitalize((String)fieldName)));
                Cast castLocal = ExpressionFactory.cast((org.mule.devkit.model.code.Type)typeReference, (Expression)invocation);
                Conditional ifConfigAlsoNull = ifNotNull._else()._if(Op.eq((Expression)moduleObject.invoke("get" + StringUtils.capitalize((String)fieldName)), (Expression)ExpressionFactory._null()));
                TypeReference coreMessages = this.ref(CoreMessages.class);
                Invocation invocation2 = coreMessages.staticInvoke("failedToCreate");
                if (methodName != null) {
                    invocation2.arg(ExpressionFactory.lit((String)methodName));
                }
                Invocation messageException = ExpressionFactory._new((TypeReference)this.ref(MessagingException.class));
                messageException.arg((Expression)invocation2);
                if (event != null) {
                    messageException.arg((Expression)event);
                }
                messageException.arg((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("You must provide a " + fieldName + " at the config or the message processor level."));
                ifConfigAlsoNull._then()._throw((Expression)messageException);
                ifNotNull._else().assign((AssignmentTarget)variable, (Expression)castLocal);
            }
        }
        ArrayList<Expression> parameters = new ArrayList<Expression>();
        Variable variable = null;
        Variable outboundHeadersMap = null;
        for (VariableElement variableElement : executableElement.getParameters()) {
            String string = variableElement.getSimpleName().toString();
            if (((Object)variableElement.asType()).toString().startsWith(HttpCallback.class.getName())) {
                parameters.add((Expression)fields.get(string).getFieldType());
                continue;
            }
            if (((Object)variableElement.asType()).toString().startsWith(SourceCallback.class.getName())) {
                parameters.add(ExpressionFactory._this());
                continue;
            }
            if (variableElement.getAnnotation(OAuthAccessToken.class) != null) {
                this.declareOAuthAccessTokenParameter(callProcessor, moduleObject, parameters);
                continue;
            }
            if (variableElement.getAnnotation(OAuthAccessTokenSecret.class) != null) {
                this.declareOAuthAccessTokenSecretParameter(callProcessor, moduleObject, parameters);
                continue;
            }
            if (this.context.getTypeMirrorUtils().isNestedProcessor(variableElement.asType())) {
                this.declareNestedProcessorParameter(fields, muleContext, event, callProcessor, parameters, variableElement, string);
                continue;
            }
            outboundHeadersMap = this.declareStandardParameter(messageProcessorClass, fields, muleMessage, callProcessor, parameters, outboundHeadersMap, variableElement, string);
        }
        if (connectMethod != null) {
            DefinedClass connectionKey = this.context.getClassForRole(this.context.getNameUtils().generateConnectionParametersRoleKey((TypeElement)executableElement.getEnclosingElement()));
            Conditional conditional = callProcessor.body()._if((Expression)logger.invoke("isDebugEnabled"));
            Variable variable2 = conditional._then().decl((org.mule.devkit.model.code.Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
            conditional._then().add((Statement)variable2.invoke("append").arg("Attempting to acquire a connection using "));
            for (String field : connectionParameters.keySet()) {
                conditional._then().add((Statement)variable2.invoke("append").arg(ExpressionFactory.lit((String)("[" + field + " = "))));
                conditional._then().add((Statement)variable2.invoke("append").arg(connectionParameters.get(field)));
                conditional._then().add((Statement)variable2.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
            }
            conditional._then().add((Statement)logger.invoke("debug").arg((Expression)variable2.invoke("toString")));
            Invocation newKey = ExpressionFactory._new((TypeReference)connectionKey);
            Invocation createConnection = moduleObject.invoke("acquireConnection");
            for (VariableElement variableElement : connectMethod.getParameters()) {
                String fieldName = variableElement.getSimpleName().toString();
                newKey.arg(connectionParameters.get(fieldName));
            }
            createConnection.arg((Expression)newKey);
            callProcessor.body().assign((AssignmentTarget)connection, (Expression)createConnection);
            Conditional ifConnectionIsNull = callProcessor.body()._if(Op.eq((Expression)connection, (Expression)ExpressionFactory._null()));
            TypeReference typeReference = this.ref(CoreMessages.class);
            Invocation failedToInvoke = typeReference.staticInvoke("failedToCreate");
            if (methodName != null) {
                failedToInvoke.arg(ExpressionFactory.lit((String)methodName));
            }
            Invocation messageException = ExpressionFactory._new((TypeReference)this.ref(MessagingException.class));
            messageException.arg((Expression)failedToInvoke);
            if (event != null) {
                messageException.arg((Expression)event);
            }
            messageException.arg((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Cannot create connection"));
            ifConnectionIsNull._then()._throw((Expression)messageException);
            Conditional conditional2 = ifConnectionIsNull._else()._if((Expression)logger.invoke("isDebugEnabled"));
            Variable variable3 = conditional2._then().decl((org.mule.devkit.model.code.Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
            conditional2._then().add((Statement)variable3.invoke("append").arg("Connection has been acquired with "));
            conditional2._then().add((Statement)variable3.invoke("append").arg(ExpressionFactory.lit((String)"[id = ")));
            conditional2._then().add((Statement)variable3.invoke("append").arg((Expression)connection.invoke(connectionIdentifierMethod.getSimpleName().toString())));
            conditional2._then().add((Statement)variable3.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
            conditional2._then().add((Statement)logger.invoke("debug").arg((Expression)variable3.invoke("toString")));
        }
        org.mule.devkit.model.code.Type returnType = this.ref(executableElement.getReturnType());
        callProcessor.body().add((Statement)retryCount.invoke("getAndIncrement"));
        if (connectMethod != null) {
            this.generateMethodCall(callProcessor.body(), connection, methodName, parameters, event, returnType, poolObject, variable, messageProcessorListener);
        } else {
            this.generateMethodCall(callProcessor.body(), moduleObject, methodName, parameters, event, returnType, poolObject, variable, messageProcessorListener);
        }
        callProcessor.body().add((Statement)retryCount.invoke("set").arg(ExpressionFactory.lit((int)0)));
        for (VariableElement variableElement : executableElement.getParameters()) {
            OutboundHeaders outboundHeaders = variableElement.getAnnotation(OutboundHeaders.class);
            if (outboundHeaders == null) continue;
            Conditional ifNotEmpty = callProcessor.body()._if(Op.cand((Expression)Op.ne((Expression)outboundHeadersMap, (Expression)ExpressionFactory._null()), (Expression)Op.not((Expression)outboundHeadersMap.invoke("isEmpty"))));
            ifNotEmpty._then().add((Statement)event.invoke("getMessage").invoke("addProperties").arg((Expression)outboundHeadersMap).arg((Expression)this.ref(PropertyScope.class).staticRef("OUTBOUND")));
        }
        callProcessor.body()._return((Expression)event);
        InvalidateConnectionOn invalidateConnectionOn = executableElement.getAnnotation(InvalidateConnectionOn.class);
        if (connectMethod != null && invalidateConnectionOn != null) {
            String string = InvalidateConnectionOn.class.getName();
            DeclaredType exception = null;
            List<? extends AnnotationMirror> annotationMirrors = executableElement.getAnnotationMirrors();
            block5: for (AnnotationMirror annotationMirror : annotationMirrors) {
                if (!string.equals(annotationMirror.getAnnotationType().toString())) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    if (!"exception".equals(entry.getKey().getSimpleName().toString())) continue;
                    exception = (DeclaredType)entry.getValue().getValue();
                    continue block5;
                }
            }
            CatchBlock catchBlock = callProcessor._catch(this.ref(exception).boxify());
            Conditional conditional = catchBlock.body()._if((Expression)logger.invoke("isDebugEnabled"));
            Variable messageStringBuilder = conditional._then().decl((org.mule.devkit.model.code.Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
            conditional._then().add((Statement)messageStringBuilder.invoke("append").arg("An exception ("));
            conditional._then().add((Statement)messageStringBuilder.invoke("append").arg(this.ref(exception).boxify().fullName()));
            conditional._then().add((Statement)messageStringBuilder.invoke("append").arg(") has been thrown while executing "));
            conditional._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)methodName)));
            conditional._then().add((Statement)messageStringBuilder.invoke("append").arg(". Destroying the connection with [id = "));
            conditional._then().add((Statement)messageStringBuilder.invoke("append").arg((Expression)connection.invoke(connectionIdentifierMethod.getSimpleName().toString())));
            conditional._then().add((Statement)messageStringBuilder.invoke("append").arg("]."));
            conditional._then().add((Statement)logger.invoke("debug").arg((Expression)messageStringBuilder.invoke("toString")));
            TryStatement innerTry = catchBlock.body()._try();
            DefinedClass connectionKey = this.context.getClassForRole(this.context.getNameUtils().generateConnectionParametersRoleKey((TypeElement)executableElement.getEnclosingElement()));
            Invocation invocation = ExpressionFactory._new((TypeReference)connectionKey);
            for (VariableElement variableElement : connectMethod.getParameters()) {
                String fieldName = variableElement.getSimpleName().toString();
                invocation.arg(connectionParameters.get(fieldName));
            }
            Invocation destroySession = moduleObject.invoke("destroyConnection");
            destroySession.arg((Expression)invocation);
            destroySession.arg((Expression)connection);
            innerTry.body().add((Statement)destroySession);
            innerTry.body().assign((AssignmentTarget)connection, ExpressionFactory._null());
            CatchBlock catchBlock2 = innerTry._catch(this.ref(Exception.class));
            Variable destroyException = catchBlock2.param("e");
            catchBlock2.body().add((Statement)logger.invoke("error").arg((Expression)destroyException.invoke("getMessage")).arg((Expression)destroyException));
            Conditional ifRetryMaxNotReached = catchBlock.body()._if(Op.lte((Expression)retryCount.invoke("get"), (Expression)retryMax));
            Conditional conditional3 = ifRetryMaxNotReached._then()._if((Expression)logger.invoke("isDebugEnabled"));
            messageStringBuilder = conditional3._then().decl((org.mule.devkit.model.code.Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
            conditional3._then().add((Statement)messageStringBuilder.invoke("append").arg("Forcing a retry [time="));
            conditional3._then().add((Statement)messageStringBuilder.invoke("append").arg((Expression)retryCount));
            conditional3._then().add((Statement)messageStringBuilder.invoke("append").arg(" out of  "));
            conditional3._then().add((Statement)messageStringBuilder.invoke("append").arg((Expression)retryMax));
            conditional3._then().add((Statement)messageStringBuilder.invoke("append").arg("]."));
            conditional3._then().add((Statement)logger.invoke("debug").arg((Expression)messageStringBuilder.invoke("toString")));
            ifRetryMaxNotReached._then()._return((Expression)ExpressionFactory.invoke((String)"process").arg((Expression)event));
            Variable invalidConnection = catchBlock.param("invalidConnection");
            TypeReference coreMessages = this.ref(CoreMessages.class);
            Invocation failedToInvoke = coreMessages.staticInvoke("failedToInvoke");
            if (methodName != null) {
                failedToInvoke.arg(ExpressionFactory.lit((String)methodName));
            }
            Invocation messageException = ExpressionFactory._new((TypeReference)this.ref(MessagingException.class));
            messageException.arg((Expression)failedToInvoke);
            if (event != null) {
                messageException.arg((Expression)event);
            }
            messageException.arg((Expression)invalidConnection);
            catchBlock.body()._throw((Expression)messageException);
        }
        this.generateThrow("failedToInvoke", MessagingException.class, callProcessor._catch(this.ref(Exception.class)), (Expression)event, methodName);
        if (poolObjectClass != null) {
            Block block = callProcessor._finally();
            Block poolObjectNotNull = block._if(Op.ne((Expression)poolObject, (Expression)ExpressionFactory._null()))._then();
            poolObjectNotNull.add((Statement)moduleObject.invoke("getLifecyleEnabledObjectPool").invoke("returnObject").arg((Expression)poolObject));
        }
        if (connectMethod != null) {
            Block block = callProcessor._finally();
            TryStatement tryToReleaseConnection = block._try();
            Conditional ifConnectionNotNull = tryToReleaseConnection.body()._if(Op.ne((Expression)connection, (Expression)ExpressionFactory._null()));
            Conditional ifDebugEnabled = ifConnectionNotNull._then()._if((Expression)logger.invoke("isDebugEnabled"));
            Variable variable4 = ifDebugEnabled._then().decl((org.mule.devkit.model.code.Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
            ifDebugEnabled._then().add((Statement)variable4.invoke("append").arg("Releasing the connection back into the pool [id="));
            ifDebugEnabled._then().add((Statement)variable4.invoke("append").arg((Expression)connection.invoke(connectionIdentifierMethod.getSimpleName().toString())));
            ifDebugEnabled._then().add((Statement)variable4.invoke("append").arg("]."));
            ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((Expression)variable4.invoke("toString")));
            DefinedClass connectionKey = this.context.getClassForRole(this.context.getNameUtils().generateConnectionParametersRoleKey((TypeElement)executableElement.getEnclosingElement()));
            Invocation newKey = ExpressionFactory._new((TypeReference)connectionKey);
            for (VariableElement variableElement : connectMethod.getParameters()) {
                String fieldName = variableElement.getSimpleName().toString();
                newKey.arg(connectionParameters.get(fieldName));
            }
            Invocation returnConnection = moduleObject.invoke("releaseConnection");
            returnConnection.arg((Expression)newKey);
            returnConnection.arg((Expression)connection);
            ifConnectionNotNull._then().add((Statement)returnConnection);
            this.generateThrow("failedToInvoke", MessagingException.class, tryToReleaseConnection._catch(this.ref(Exception.class)), (Expression)event, methodName);
        }
    }

    private Variable declareStandardParameter(DefinedClass messageProcessorClass, Map<String, AbstractMessageGenerator.FieldVariableElement> fields, Variable muleMessage, TryStatement callProcessor, List<Expression> parameters, Variable outboundHeadersMap, VariableElement variable, String fieldName) {
        InboundHeaders inboundHeaders = variable.getAnnotation(InboundHeaders.class);
        OutboundHeaders outboundHeaders = variable.getAnnotation(OutboundHeaders.class);
        InvocationHeaders invocationHeaders = variable.getAnnotation(InvocationHeaders.class);
        Payload payload = variable.getAnnotation(Payload.class);
        if (outboundHeaders == null) {
            TypeReference type = this.ref(fields.get(fieldName).getVariableElement().asType()).boxify();
            String name = "transformed" + StringUtils.capitalize((String)fieldName);
            Invocation getGenericType = messageProcessorClass.dotclass().invoke("getDeclaredField").arg(ExpressionFactory.lit((String)fields.get(fieldName).getFieldType().name())).invoke("getGenericType");
            Invocation evaluateAndTransform = ExpressionFactory.invoke((String)"evaluateAndTransform").arg((Expression)muleMessage).arg((Expression)getGenericType);
            if (inboundHeaders != null) {
                if (this.context.getTypeMirrorUtils().isArrayOrList(fields.get(fieldName).getVariableElement().asType())) {
                    evaluateAndTransform.arg("#[headers-list:INBOUND:" + inboundHeaders.value() + "]");
                } else if (this.context.getTypeMirrorUtils().isMap(fields.get(fieldName).getVariableElement().asType())) {
                    evaluateAndTransform.arg("#[headers:INBOUND:" + inboundHeaders.value() + "]");
                } else {
                    evaluateAndTransform.arg("#[header:INBOUND:" + inboundHeaders.value() + "]");
                }
            } else if (invocationHeaders != null) {
                if (this.context.getTypeMirrorUtils().isArrayOrList(fields.get(fieldName).getVariableElement().asType())) {
                    evaluateAndTransform.arg("#[headers-list:INVOCATION:" + invocationHeaders.value() + "]");
                } else if (this.context.getTypeMirrorUtils().isMap(fields.get(fieldName).getVariableElement().asType())) {
                    evaluateAndTransform.arg("#[headers:INVOCATION:" + invocationHeaders.value() + "]");
                } else {
                    evaluateAndTransform.arg("#[header:INVOCATION:" + invocationHeaders.value() + "]");
                }
            } else if (payload != null) {
                evaluateAndTransform.arg("#[payload]");
            } else {
                evaluateAndTransform.arg((Expression)fields.get(fieldName).getField());
            }
            Cast cast = ExpressionFactory.cast((org.mule.devkit.model.code.Type)type, (Expression)evaluateAndTransform);
            Variable transformed = callProcessor.body().decl((org.mule.devkit.model.code.Type)type, name, (Expression)cast);
            parameters.add((Expression)transformed);
        } else {
            TypeReference type = this.ref(HashMap.class).narrow(new TypeReference[]{this.ref(String.class), this.ref(Object.class)});
            String name = "transformed" + StringUtils.capitalize((String)fieldName);
            outboundHeadersMap = callProcessor.body().decl((org.mule.devkit.model.code.Type)type, name, (Expression)ExpressionFactory._new((org.mule.devkit.model.code.Type)type));
            parameters.add((Expression)outboundHeadersMap);
        }
        return outboundHeadersMap;
    }

    private void declareNestedProcessorParameter(Map<String, AbstractMessageGenerator.FieldVariableElement> fields, FieldVariable muleContext, Variable event, TryStatement callProcessor, List<Expression> parameters, VariableElement variable, String fieldName) {
        DefinedClass callbackClass = this.context.getClassForRole("NestedProcessorChain");
        DefinedClass stringCallbackClass = this.context.getClassForRole("NestedProcessorString");
        boolean isList = this.context.getTypeMirrorUtils().isArrayOrList(variable.asType());
        if (!isList) {
            Variable transformed = callProcessor.body().decl((org.mule.devkit.model.code.Type)this.ref(NestedProcessor.class), "transformed" + StringUtils.capitalize((String)fieldName), ExpressionFactory._null());
            Conditional ifMessageProcessor = callProcessor.body()._if(Op.cand((Expression)Op.ne((Expression)fields.get(fieldName).getField(), (Expression)ExpressionFactory._null()), (Expression)Op._instanceof((Expression)fields.get(fieldName).getField(), (org.mule.devkit.model.code.Type)this.ref(MessageProcessor.class))));
            ifMessageProcessor._then().assign((AssignmentTarget)transformed, (Expression)ExpressionFactory._new((TypeReference)callbackClass).arg((Expression)event).arg((Expression)muleContext).arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(MessageProcessor.class), (Expression)fields.get(fieldName).getField())));
            Conditional ifString = ifMessageProcessor._elseif(Op.cand((Expression)Op.ne((Expression)fields.get(fieldName).getField(), (Expression)ExpressionFactory._null()), (Expression)Op._instanceof((Expression)fields.get(fieldName).getField(), (org.mule.devkit.model.code.Type)this.ref(String.class))));
            ifString._then().assign((AssignmentTarget)transformed, (Expression)ExpressionFactory._new((TypeReference)stringCallbackClass).arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(String.class), (Expression)fields.get(fieldName).getField())));
            parameters.add((Expression)transformed);
        } else {
            Variable transformed = callProcessor.body().decl((org.mule.devkit.model.code.Type)this.ref(List.class).narrow(NestedProcessor.class), "transformed" + StringUtils.capitalize((String)fieldName), (Expression)ExpressionFactory._new((TypeReference)this.ref(ArrayList.class).narrow(NestedProcessor.class)));
            Conditional ifMessageProcessor = callProcessor.body()._if(Op.cand((Expression)Op.ne((Expression)fields.get(fieldName).getField(), (Expression)ExpressionFactory._null()), (Expression)Op._instanceof((Expression)fields.get(fieldName).getField(), (org.mule.devkit.model.code.Type)this.ref(List.class))));
            ForEach forEachProcessor = ifMessageProcessor._then().forEach((org.mule.devkit.model.code.Type)this.ref(MessageProcessor.class), "messageProcessor", (Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(List.class).narrow(MessageProcessor.class), (Expression)fields.get(fieldName).getField()));
            forEachProcessor.body().add((Statement)transformed.invoke("add").arg((Expression)ExpressionFactory._new((TypeReference)callbackClass).arg((Expression)event).arg((Expression)muleContext).arg((Expression)forEachProcessor.var())));
            Conditional ifString = ifMessageProcessor._elseif(Op.cand((Expression)Op.ne((Expression)fields.get(fieldName).getField(), (Expression)ExpressionFactory._null()), (Expression)Op._instanceof((Expression)fields.get(fieldName).getField(), (org.mule.devkit.model.code.Type)this.ref(String.class))));
            ifString._then().add((Statement)transformed.invoke("add").arg((Expression)ExpressionFactory._new((TypeReference)stringCallbackClass).arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(String.class), (Expression)fields.get(fieldName).getField()))));
            parameters.add((Expression)transformed);
        }
    }

    private void declareOAuthAccessTokenSecretParameter(TryStatement callProcessor, Variable moduleObject, List<Expression> parameters) {
        Invocation getAccessToken = moduleObject.invoke("get" + StringUtils.capitalize((String)"accessTokenSecret"));
        Variable accessTokenSecret = callProcessor.body().decl((org.mule.devkit.model.code.Type)this.ref(String.class), "accessTokenSecret", (Expression)getAccessToken);
        parameters.add((Expression)accessTokenSecret);
    }

    private void declareOAuthAccessTokenParameter(TryStatement callProcessor, Variable moduleObject, List<Expression> parameters) {
        Invocation getAccessToken = moduleObject.invoke("get" + StringUtils.capitalize((String)"accessToken"));
        Variable accessToken = callProcessor.body().decl((org.mule.devkit.model.code.Type)this.ref(String.class), "accessToken", (Expression)getAccessToken);
        parameters.add((Expression)accessToken);
    }

    private Map<String, Expression> declareConnectionParametersVariables(ExecutableElement executableElement, Map<String, AbstractMessageGenerator.FieldVariableElement> connectionFields, Method process) {
        HashMap<String, Expression> connectionParameters = new HashMap<String, Expression>();
        ExecutableElement connectMethod = this.connectForMethod(executableElement);
        if (connectMethod != null) {
            for (VariableElement variableElement : connectMethod.getParameters()) {
                String fieldName = variableElement.getSimpleName().toString();
                TypeReference type = this.ref(connectionFields.get(fieldName).getVariableElement().asType()).boxify();
                String name = "transformed" + StringUtils.capitalize((String)fieldName);
                Variable transformed = process.body().decl((org.mule.devkit.model.code.Type)type, name, ExpressionFactory._null());
                connectionParameters.put(fieldName, (Expression)transformed);
            }
        }
        return connectionParameters;
    }

    private Variable addConnectionVariableIfNeeded(ExecutableElement executableElement, Method process) {
        ExecutableElement connectMethod = this.connectForMethod(executableElement);
        if (this.connectForMethod(executableElement) != null) {
            DefinedClass connectionClass = this.context.getClassForRole(this.context.getNameUtils().generateConnectorObjectRoleKey((TypeElement)connectMethod.getEnclosingElement()));
            return process.body().decl((org.mule.devkit.model.code.Type)connectionClass, "connection", ExpressionFactory._null());
        }
        return null;
    }

    private void addOAuthFieldIfNeeded(ExecutableElement executableElement, Method process, Variable event, Variable moduleObject) {
        if (executableElement.getEnclosingElement().getAnnotation(OAuth.class) != null || executableElement.getEnclosingElement().getAnnotation(OAuth2.class) != null) {
            for (VariableElement variableElement : executableElement.getParameters()) {
                if (variableElement.getAnnotation(OAuthAccessToken.class) == null && variableElement.getAnnotation(OAuthAccessTokenSecret.class) == null) continue;
                this.addOAuth(process, event, moduleObject, executableElement);
                break;
            }
        }
    }

    private Variable declarePoolObjectIfClassNotNull(DefinedClass poolObjectClass, Method process) {
        if (poolObjectClass != null) {
            return process.body().decl((org.mule.devkit.model.code.Type)poolObjectClass, "poolObject", ExpressionFactory._null());
        }
        return null;
    }

    private void addOAuth(Method process, Variable event, Variable object, ExecutableElement executableElement) {
        Invocation accessToken = object.invoke("get" + StringUtils.capitalize((String)"accessToken"));
        Block ifAccessTokenIsNull = process.body()._if(this.isNull(accessToken))._then();
        Invocation failedToInvoke = this.ref(CoreMessages.class).staticInvoke("failedToInvoke").arg(executableElement.getSimpleName().toString());
        Invocation newNotAuthorizedException = ExpressionFactory._new((TypeReference)this.ref(NotAuthorizedException.class));
        newNotAuthorizedException.arg("This connector has not yet been authorized, please authorize by calling \"authorize\".");
        Invocation messagingException = ExpressionFactory._new((TypeReference)this.ref(MessagingException.class));
        messagingException.arg((Expression)failedToInvoke);
        messagingException.arg((Expression)event);
        messagingException.arg((Expression)newNotAuthorizedException);
        ifAccessTokenIsNull._throw((Expression)messagingException);
    }

    private Variable generateMethodCall(Block body, Variable object, String methodName, List<Expression> parameters, Variable event, org.mule.devkit.model.code.Type returnType, Variable poolObject, Variable interceptCallback, FieldVariable messageProcessorListener) {
        Invocation methodCall;
        Variable resultPayload = null;
        if (returnType != this.context.getCodeModel().VOID) {
            resultPayload = body.decl((org.mule.devkit.model.code.Type)this.ref(Object.class), "resultPayload");
        }
        if (poolObject != null) {
            body.assign((AssignmentTarget)poolObject, (Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)poolObject.type(), (Expression)object.invoke("getLifecyleEnabledObjectPool").invoke("borrowObject")));
            methodCall = poolObject.invoke(methodName);
        } else {
            methodCall = object.invoke(methodName);
        }
        for (Expression parameter : parameters) {
            methodCall.arg(parameter);
        }
        if (returnType != this.context.getCodeModel().VOID) {
            body.assign((AssignmentTarget)resultPayload, (Expression)methodCall);
        } else {
            body.add((Statement)methodCall);
        }
        Block scope = body;
        if (interceptCallback != null) {
            Conditional shallContinue = body._if(Op.cand((Expression)interceptCallback.invoke("getShallContinue"), (Expression)Op.ne((Expression)messageProcessorListener, (Expression)ExpressionFactory._null())));
            shallContinue._then().assign((AssignmentTarget)event, (Expression)messageProcessorListener.invoke("process").arg((Expression)event));
            scope = shallContinue._else();
        }
        if (returnType != this.context.getCodeModel().VOID) {
            this.generatePayloadOverwrite(scope, event, resultPayload);
        }
        return resultPayload;
    }

    private void generatePayloadOverwrite(Block block, Variable event, Variable resultPayload) {
        Invocation applyTransformers = event.invoke("getMessage").invoke("applyTransformers");
        applyTransformers.arg((Expression)event);
        Invocation newTransformerTemplate = ExpressionFactory._new((TypeReference)this.ref(TransformerTemplate.class));
        Variable overwritePayloadCallback = block.decl((org.mule.devkit.model.code.Type)this.ref(TransformerTemplate.OverwitePayloadCallback.class), "overwritePayloadCallback", ExpressionFactory._null());
        Conditional ifPayloadIsNull = block._if(resultPayload.eq(ExpressionFactory._null()));
        Invocation newOverwritePayloadCallback = ExpressionFactory._new((TypeReference)this.ref(TransformerTemplate.OverwitePayloadCallback.class));
        newOverwritePayloadCallback.arg((Expression)resultPayload);
        Invocation newOverwritePayloadCallbackWithNull = ExpressionFactory._new((TypeReference)this.ref(TransformerTemplate.OverwitePayloadCallback.class));
        newOverwritePayloadCallbackWithNull.arg((Expression)this.ref(NullPayload.class).staticInvoke("getInstance"));
        ifPayloadIsNull._else().assign((AssignmentTarget)overwritePayloadCallback, (Expression)newOverwritePayloadCallback);
        ifPayloadIsNull._then().assign((AssignmentTarget)overwritePayloadCallback, (Expression)newOverwritePayloadCallbackWithNull);
        newTransformerTemplate.arg((Expression)overwritePayloadCallback);
        Variable transformerList = block.decl((org.mule.devkit.model.code.Type)this.ref(List.class).narrow(Transformer.class), "transformerList");
        block.assign((AssignmentTarget)transformerList, (Expression)ExpressionFactory._new((TypeReference)this.ref(ArrayList.class).narrow(Transformer.class)));
        block.add((Statement)transformerList.invoke("add").arg((Expression)newTransformerTemplate));
        applyTransformers.arg((Expression)transformerList);
        block.add((Statement)applyTransformers);
    }
}

