/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.dsl;

import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.devkit.generation.AbstractModuleGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ClassAlreadyExistsException;
import org.mule.devkit.model.code.Conditional;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;

public class DSLWrapperGenerator
extends AbstractModuleGenerator {
    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return !this.getPojoType(typeElement).fullName().endsWith("HttpCallbackAdapter");
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) throws GenerationException {
        DefinedClass wrapperClass = this.buildWrapperClass(typeElement);
        FieldVariable object = this.generateFieldForPojo(typeElement, wrapperClass);
        this.initializeWrapper(typeElement, wrapperClass, object);
        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            Processor mp = executableElement.getAnnotation(Processor.class);
            if (mp == null) continue;
            LinkedList<Parameter> mandatoryParams = new LinkedList<Parameter>();
            LinkedList<FieldVariable> fields = new LinkedList<FieldVariable>();
            DefinedClass _interface = this.buildMessageDefinitionInterface(executableElement);
            DefinedClass _builder = this.buildMessageBuilderClass(executableElement, _interface);
            this.generateFieldForPojo(typeElement, _builder);
            this.handleParameters(executableElement.getParameters(), _interface, _builder, mandatoryParams, fields);
            this.generateBuilderConstructor(object, _builder, mandatoryParams);
            this.generateWrapperMethods(wrapperClass, object, executableElement.getSimpleName().toString(), (Type)_interface, _builder, this.multiply(mandatoryParams));
            this.generateBuildMethod(object, executableElement, _builder, fields);
        }
    }

    private void handleParameters(List<? extends VariableElement> parameters, DefinedClass _interface, DefinedClass _builder, List<Parameter> mandatoryParams, List<FieldVariable> fields) {
        for (VariableElement variableElement : parameters) {
            String paramName = variableElement.getSimpleName().toString();
            FieldVariable field = _builder.field(4, Object.class, paramName);
            fields.add(field);
            Optional optional = variableElement.getAnnotation(Optional.class);
            if (optional != null) {
                this.generateOptionalMethod(_interface, paramName, this.ref(variableElement.asType()), (Type)_interface);
                this.generateOptionalMethod(_interface, paramName, (Type)this.expressionType(), (Type)_interface);
                this.generateOptionalMethod(_builder, paramName, this.ref(variableElement.asType()), (Type)_interface);
                this.generateOptionalMethod(_builder, paramName, (Type)this.expressionType(), (Type)_interface);
            } else {
                mandatoryParams.add(new Parameter(paramName, this.ref(variableElement.asType()).fullName()));
            }
            Default defaultInfo = variableElement.getAnnotation(Default.class);
            if (defaultInfo != null) {
                field.init((Expression)this.defaultValue(variableElement.asType(), defaultInfo.value()));
                continue;
            }
            field.init(ExpressionFactory._null());
        }
    }

    private void generateWrapperMethods(DefinedClass wrapperClass, FieldVariable object, String methodName, Type returnType, DefinedClass _builder, Parameter[][] signatures) {
        for (int i = 0; i < signatures.length; ++i) {
            Method methodWrapper = wrapperClass.method(1, returnType, methodName);
            Invocation builderInstace = ExpressionFactory._new((TypeReference)_builder);
            builderInstace.arg((Expression)object);
            for (int k = 0; k < signatures[i].length; ++k) {
                Variable paramRef = methodWrapper.param(this.ref(signatures[i][k].getType()), signatures[i][k].getName());
                builderInstace.arg((Expression)paramRef);
            }
            methodWrapper.body()._return((Expression)builderInstace);
        }
    }

    private void generateBuildMethod(FieldVariable object, ExecutableElement executableElement, DefinedClass _builder, List<FieldVariable> fields) {
        Method build = _builder.method(1, (Type)this.pojoType(executableElement), "build");
        Variable muleContextParam = build.param((Type)this.muleContextInterface(), "muleContext");
        Variable placeholderParam = build.param(this.propertyPlaceholderInterface(), "placeholder");
        Variable varMP = build.body().decl((Type)this.pojoType(executableElement), "$mp").init((Expression)ExpressionFactory._new((TypeReference)this.pojoType(executableElement)));
        build.body().invoke((Expression)varMP, "setMuleContext").arg((Expression)muleContextParam);
        build.body().invoke((Expression)varMP, "setModuleObject").arg((Expression)object);
        for (FieldVariable field : fields) {
            String setterName = "set" + StringUtils.capitalize((String)field.name());
            Conditional fieldCond = build.body()._if(field.ne(ExpressionFactory._null()).cand(field._instanceof((Type)this.expressionType())));
            fieldCond._then().invoke((Expression)varMP, setterName).arg((Expression)ExpressionFactory.cast((Type)this.expressionType(), (Expression)field).invoke("toString").arg((Expression)placeholderParam));
            fieldCond._else().invoke((Expression)varMP, setterName).arg((Expression)field);
        }
        build.body()._return((Expression)varMP);
    }

    private void generateBuilderConstructor(FieldVariable object, DefinedClass _builder, List<Parameter> mandatoryParams) {
        Method builderConstructor = _builder.constructor(1);
        Variable objectParam = builderConstructor.param(object.type(), "object");
        builderConstructor.body().assign((AssignmentTarget)ExpressionFactory.refthis((String)"object"), (Expression)objectParam);
        for (Parameter param : mandatoryParams) {
            Variable constructotParam = builderConstructor.param(Object.class, param.getName());
            builderConstructor.body().assign((AssignmentTarget)ExpressionFactory.refthis((String)param.getName()), (Expression)constructotParam);
        }
    }

    private void generateOptionalMethod(DefinedClass defClazz, String paramName, Type type, Type returnType) {
        String methodName = "with" + StringUtils.capitalize((String)paramName);
        Method method = defClazz.method(1, returnType, methodName);
        Variable methodParam = method.param(type, paramName);
        method.javadoc().add((Object)("Sets " + paramName));
        method.javadoc().addParam(paramName + " Value to set");
        if (!defClazz.isInterface()) {
            method.body().assign((AssignmentTarget)ExpressionFactory.refthis((String)paramName), (Expression)methodParam);
            method.body()._return(ExpressionFactory._this());
        }
    }

    protected FieldVariable generateFieldForPojo(TypeElement typeElement, DefinedClass defClazz) {
        FieldVariable fieldPojo = defClazz.field(12, this.getPojoType(typeElement), "object");
        fieldPojo.javadoc().add((Object)"Plain old java object");
        return fieldPojo;
    }

    protected Type getPojoType(TypeElement typeElement) {
        return this.context.getClassForRole(this.context.getNameUtils().generateModuleObjectRoleKey(typeElement));
    }

    private void initializeWrapper(TypeElement typeElement, DefinedClass wrapperClass, FieldVariable object) {
        Method constructor = wrapperClass.constructor(1);
        constructor.body().assign((AssignmentTarget)object, (Expression)ExpressionFactory._new((Type)this.getPojoType(typeElement)));
        List<VariableElement> variableElements = ElementFilter.fieldsIn(typeElement.getEnclosedElements());
        for (VariableElement variableElement : variableElements) {
            Configurable configInfo = variableElement.getAnnotation(Configurable.class);
            if (configInfo == null) continue;
            String fieldName = variableElement.getSimpleName().toString();
            this.generateWrapperSetter(wrapperClass, variableElement, object);
            Default defaultInfo = variableElement.getAnnotation(Default.class);
            if (defaultInfo == null) continue;
            Invocation methdoCall = ExpressionFactory.invoke((Expression)object, (String)("set" + StringUtils.capitalize((String)fieldName)));
            methdoCall.arg((Expression)this.defaultValue(variableElement.asType(), defaultInfo.value()));
            constructor.body().add((Statement)methdoCall);
        }
    }

    protected DefinedClass buildMessageDefinitionInterface(ExecutableElement executableElement) {
        String typeName = this.context.getNameUtils().generateClassName(executableElement, "MessageProcessorDefinition");
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(typeName) + ".dsl");
        try {
            return pkg._interface(this.context.getNameUtils().getClassName(typeName))._implements(this.messageProcessorDefinitionInterface());
        }
        catch (ClassAlreadyExistsException e) {
            throw new RuntimeException(e);
        }
    }

    protected DefinedClass buildWrapperClass(TypeElement typeElement) {
        String typeName = this.context.getNameUtils().generateClassName(typeElement, ".dsl", "");
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(typeName));
        DefinedClass clazz = pkg._class(this.context.getNameUtils().getClassName(typeName));
        return clazz;
    }

    protected DefinedClass buildMessageBuilderClass(ExecutableElement executableElement, DefinedClass interfaceRef) {
        String typeName = this.context.getNameUtils().generateClassName(executableElement, "MessageProcessorBuilder");
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(typeName) + ".dsl.internal");
        return pkg._class(this.context.getNameUtils().getClassName(typeName))._implements(this.builderInterface().narrow(this.pojoType(executableElement)))._implements((TypeReference)interfaceRef);
    }

    protected Method generateWrapperSetter(DefinedClass clazz, VariableElement field, FieldVariable object) {
        String setterName = "set" + StringUtils.capitalize((String)field.getSimpleName().toString());
        Method setter = clazz.method(1, (Type)this.context.getCodeModel().VOID, setterName);
        setter.javadoc().add((Object)("Sets " + field.getSimpleName().toString()));
        setter.javadoc().addParam("value Value to set");
        Variable value = setter.param(this.ref(field.asType()), "value");
        setter.body().add((Statement)ExpressionFactory._this().ref((Variable)object).invoke(setterName).arg((Expression)value));
        return setter;
    }

    protected Invocation defaultValue(TypeMirror type, String init) {
        Invocation invocation = this.ref("org.mule.config.dsl.util.DefaultValueConverter").boxify().staticInvoke("valueOf");
        invocation.arg(ExpressionFactory.dotclass((TypeReference)this.ref(type).boxify()));
        invocation.arg(ExpressionFactory.lit((String)init));
        return invocation;
    }

    private TypeReference muleContextInterface() {
        return this.ref(MuleContext.class);
    }

    private Type propertyPlaceholderInterface() {
        return this.ref("org.mule.config.dsl.PropertyPlaceholder");
    }

    private TypeReference messageProcessorDefinitionInterface() {
        return this.ref("org.mule.config.dsl.MessageProcessorDefinition").boxify();
    }

    private TypeReference builderInterface() {
        return this.ref("org.mule.config.dsl.internal.DSLBuilder").boxify();
    }

    private TypeReference expressionType() {
        return this.ref(this.expressionTypeName()).boxify();
    }

    private String expressionTypeName() {
        return "org.mule.config.dsl.ExpressionEvaluatorDefinition";
    }

    private TypeReference pojoType(ExecutableElement executableElement) {
        return this.ref(this.pojoTypeName(executableElement)).boxify();
    }

    private String pojoTypeName(ExecutableElement executableElement) {
        return this.context.getNameUtils().generateClassName(executableElement, ".config", "MessageProcessor");
    }

    private Parameter[][] multiply(List<Parameter> params) {
        Parameter[][] result = new Parameter[1][params.size()];
        for (int i = 0; i < params.size(); ++i) {
            result[0][i] = new Parameter(params.get(i).getName());
        }
        for (Parameter param : params) {
            result = this.multiply(result, param, params.size());
        }
        return result;
    }

    private Parameter[][] multiply(Parameter[][] generate, Parameter placeholder, int length) {
        String[] types = new String[]{this.expressionTypeName(), placeholder.getType()};
        Parameter[][] results = new Parameter[types.length * generate.length][length];
        int n = 0;
        for (int i = 0; i < types.length; ++i) {
            for (int j = 0; j < generate.length; ++j) {
                for (int k = 0; k < length; ++k) {
                    results[n][k] = this.define(generate[j][k], placeholder, types[i]);
                }
                ++n;
            }
        }
        return results;
    }

    private Parameter define(Parameter result, Parameter placeholder, String type) {
        if (!placeholder.getName().equals(result.getName())) {
            return new Parameter(result);
        }
        if (result.hasType()) {
            return new Parameter(result);
        }
        return new Parameter(result.getName(), type);
    }

    private static class Parameter {
        private final String name;
        private final String type;

        public Parameter(String name) {
            this.name = name;
            this.type = null;
        }

        public Parameter(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public Parameter(Parameter base) {
            this(base.name, base.type);
        }

        public boolean hasType() {
            return this.type != null;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }
}

