/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.callback;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.lang.model.element.TypeElement;
import org.mule.MessageExchangePattern;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.api.callback.HttpCallback;
import org.mule.api.construct.FlowConstructInvalidException;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.transport.Connector;
import org.mule.config.spring.factories.AsyncMessageProcessorsFactoryBean;
import org.mule.construct.Flow;
import org.mule.devkit.generation.AbstractModuleGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.Block;
import org.mule.devkit.model.code.CatchBlock;
import org.mule.devkit.model.code.Conditional;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.TryStatement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.processor.strategy.AsynchronousProcessingStrategy;

public class HttpCallbackGenerator
extends AbstractModuleGenerator {
    public static final String HTTP_CALLBACK_ROLE = "HttpCallback";
    public static final String LOCAL_PORT_FIELD_NAME = "localPort";
    public static final String REMOTE_PORT_FIELD_NAME = "remotePort";
    public static final String DOMAIN_FIELD_NAME = "domain";
    public static final String ASYNC_FIELD_NAME = "async";
    private static final String CLASS_NAME = "DefaultHttpCallback";
    private static final String INBOUND_ENDPOINT_EXCHANGE_PATTERN = "REQUEST_RESPONSE";
    private Method buildUrlMethod;
    private FieldVariable muleContextField;
    private FieldVariable flowConstructVariable;
    private Method createHttpInboundEndpointMethod;
    private FieldVariable urlField;
    private Method createConnectorMethod;
    private Method wrapMessageProcessorInAsyncChain;
    private FieldVariable loggerField;
    private FieldVariable callbackFlowField;
    private FieldVariable localPortField;
    private FieldVariable callbackMessageProcessorField;
    private FieldVariable domainField;
    private FieldVariable localUrlField;
    private FieldVariable callbackPathField;
    private FieldVariable remotePortField;
    private FieldVariable async;

    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return typeElement.hasAnnotation(OAuth.class) || typeElement.hasAnnotation(OAuth2.class) || typeElement.hasProcessorMethodWithParameter(HttpCallback.class);
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) {
        DefinedClass callbackClass = this.getDefaultHttpCallbackClass(typeElement);
        this.generateFields(callbackClass);
        this.generateConstructorArgSimpleFlowConstruct(callbackClass);
        this.generateConstructorArgMessageProcessor(callbackClass);
        this.generateConstructorArgMessageProcessorAndCallbackPath(callbackClass);
        this.generateBuildUrlMethod(callbackClass);
        this.createMessageProcessorInnerClass(callbackClass);
        this.generateWrapMessageProcessorInAsyncChain(callbackClass);
        this.generateCreateConnectorMethod(callbackClass);
        this.generateCreateHttpInboundEndpointMethod(callbackClass);
        this.generateStartMethod(callbackClass);
        this.generateStopMethod(callbackClass);
        this.context.setClassRole(HTTP_CALLBACK_ROLE, callbackClass);
    }

    private void generateFields(DefinedClass callbackClass) {
        this.loggerField = FieldBuilder.newLoggerField((DefinedClass)callbackClass);
        this.localPortField = new FieldBuilder(callbackClass).privateVisibility().type(Integer.class).name(LOCAL_PORT_FIELD_NAME).build();
        this.remotePortField = new FieldBuilder(callbackClass).privateVisibility().type(Integer.class).name(REMOTE_PORT_FIELD_NAME).javadoc("The port number to be used in the dynamic http inbound endpoint that will receive the callback").build();
        this.domainField = new FieldBuilder(callbackClass).type(String.class).name(DOMAIN_FIELD_NAME).javadoc("The domain to be used in the dynamic http inbound endpoint that will receive the callback").build();
        this.urlField = new FieldBuilder(callbackClass).privateVisibility().type(String.class).name("url").javadoc("The dynamically generated url to pass on to the cloud connector. When this url is called the callback flow will be executed").getter().build();
        this.localUrlField = new FieldBuilder(callbackClass).privateVisibility().type(String.class).name("localUrl").build();
        this.muleContextField = new FieldBuilder(callbackClass).privateVisibility().type(MuleContext.class).name("muleContext").javadoc("Mule Context").setter().build();
        this.callbackFlowField = new FieldBuilder(callbackClass).privateVisibility().type(Flow.class).name("callbackFlow").javadoc("The flow to be called upon the http callback").build();
        this.flowConstructVariable = new FieldBuilder(callbackClass).privateVisibility().type(Flow.class).name("flowConstruct").javadoc("The dynamically created flow").build();
        this.callbackMessageProcessorField = new FieldBuilder(callbackClass).type(MessageProcessor.class).name("callbackMessageProcessor").javadoc("The message processor to be called upon the http callback").build();
        this.callbackPathField = new FieldBuilder(callbackClass).type(String.class).name("callbackPath").javadoc("Optional path to set up the endpoint").build();
        this.async = new FieldBuilder(callbackClass).type(Boolean.class).name(ASYNC_FIELD_NAME).javadoc("Whether the the message processor that invokes the callback flow is asynchronous").build();
    }

    private void generateConstructorArgSimpleFlowConstruct(DefinedClass callbackClass) {
        Method constructor = callbackClass.constructor(1);
        Variable callbackFlowArg = constructor.param((Type)this.ref(Flow.class), "callbackFlow");
        Variable muleContextArg = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        Variable callbackDomainArg = constructor.param((Type)this.ref(String.class), "callbackDomain");
        Variable localPortArg = constructor.param((Type)this.ref(Integer.class), LOCAL_PORT_FIELD_NAME);
        Variable remotePortArg = constructor.param((Type)this.ref(Integer.class), REMOTE_PORT_FIELD_NAME);
        Variable asyncArg = constructor.param((Type)this.ref(Boolean.class), ASYNC_FIELD_NAME);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.callbackFlowField), (Expression)callbackFlowArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.muleContextField), (Expression)muleContextArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.localPortField), (Expression)localPortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.remotePortField), (Expression)remotePortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.domainField), (Expression)callbackDomainArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.async), (Expression)asyncArg);
    }

    private void generateConstructorArgMessageProcessor(DefinedClass callbackClass) {
        Method constructor = callbackClass.constructor(1);
        Variable messageProcessorArg = constructor.param((Type)this.ref(MessageProcessor.class), "callbackMessageProcessor");
        Variable muleContextArg = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        Variable callbackDomainArg = constructor.param((Type)this.ref(String.class), "callbackDomain");
        Variable localPortArg = constructor.param((Type)this.ref(Integer.class), LOCAL_PORT_FIELD_NAME);
        Variable remotePortArg = constructor.param((Type)this.ref(Integer.class), REMOTE_PORT_FIELD_NAME);
        Variable asyncArg = constructor.param((Type)this.ref(Boolean.class), ASYNC_FIELD_NAME);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.callbackMessageProcessorField), (Expression)messageProcessorArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.muleContextField), (Expression)muleContextArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.localPortField), (Expression)localPortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.remotePortField), (Expression)remotePortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.domainField), (Expression)callbackDomainArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.async), (Expression)asyncArg);
    }

    private void generateConstructorArgMessageProcessorAndCallbackPath(DefinedClass callbackClass) {
        Method constructor = callbackClass.constructor(1);
        Variable messageProcessorArg = constructor.param((Type)this.ref(MessageProcessor.class), "callbackMessageProcessor");
        Variable muleContextArg = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        Variable callbackDomainArg = constructor.param((Type)this.ref(String.class), "callbackDomain");
        Variable localPortArg = constructor.param((Type)this.ref(Integer.class), LOCAL_PORT_FIELD_NAME);
        Variable remotePortArg = constructor.param((Type)this.ref(Integer.class), REMOTE_PORT_FIELD_NAME);
        Variable callbackPathArg = constructor.param((Type)this.ref(String.class), "callbackPath");
        Variable asyncArg = constructor.param((Type)this.ref(Boolean.class), ASYNC_FIELD_NAME);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.callbackMessageProcessorField), (Expression)messageProcessorArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.muleContextField), (Expression)muleContextArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.localPortField), (Expression)localPortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.domainField), (Expression)callbackDomainArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.remotePortField), (Expression)remotePortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.callbackPathField), (Expression)callbackPathArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.async), (Expression)asyncArg);
    }

    private void generateBuildUrlMethod(DefinedClass callbackClass) {
        this.buildUrlMethod = callbackClass.method(4, (Type)this.ref(String.class), "buildUrl");
        Block body = this.buildUrlMethod.body();
        Variable urlBuilder = body.decl((Type)this.ref(StringBuilder.class), "urlBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        Block ifDomainNotPrefixed = body._if(Op.not((Expression)this.domainField.invoke("startsWith").arg("http://")))._then();
        ifDomainNotPrefixed.invoke((Expression)urlBuilder, "append").arg("http://");
        body.invoke((Expression)urlBuilder, "append").arg((Expression)this.domainField);
        body.invoke((Expression)urlBuilder, "append").arg(":");
        body.invoke((Expression)urlBuilder, "append").arg((Expression)this.remotePortField);
        body.invoke((Expression)urlBuilder, "append").arg("/");
        Conditional ifCallbackPathNotNull = body._if(Op.ne((Expression)this.callbackPathField, (Expression)ExpressionFactory._null()));
        ifCallbackPathNotNull._then().invoke((Expression)urlBuilder, "append").arg((Expression)this.callbackPathField);
        ifCallbackPathNotNull._else().invoke((Expression)urlBuilder, "append").arg((Expression)this.ref(UUID.class).staticInvoke("randomUUID"));
        body._return((Expression)urlBuilder.invoke("toString"));
    }

    private void generateWrapMessageProcessorInAsyncChain(DefinedClass callbackClass) {
        this.wrapMessageProcessorInAsyncChain = callbackClass.method(4, (Type)this.ref(MessageProcessor.class), "wrapMessageProcessorInAsyncChain")._throws(this.ref(MuleException.class));
        Variable messageProcessorParam = this.wrapMessageProcessorInAsyncChain.param((Type)this.ref(MessageProcessor.class), "messageProcessor");
        Block body = this.wrapMessageProcessorInAsyncChain.body();
        Variable asyncMessageProcessorsFactoryBean = body.decl((Type)this.ref(AsyncMessageProcessorsFactoryBean.class), "asyncMessageProcessorsFactoryBean", (Expression)ExpressionFactory._new((TypeReference)this.ref(AsyncMessageProcessorsFactoryBean.class)));
        body.invoke((Expression)asyncMessageProcessorsFactoryBean, "setMuleContext").arg((Expression)this.muleContextField);
        body.invoke((Expression)asyncMessageProcessorsFactoryBean, "setMessageProcessors").arg((Expression)this.ref(Arrays.class).staticInvoke("asList").arg((Expression)messageProcessorParam));
        body.invoke((Expression)asyncMessageProcessorsFactoryBean, "setProcessingStrategy").arg((Expression)ExpressionFactory._new((TypeReference)this.ref(AsynchronousProcessingStrategy.class)));
        TryStatement tryStatement = body._try();
        tryStatement.body()._return((Expression)ExpressionFactory.cast((Type)this.ref(MessageProcessor.class), (Expression)asyncMessageProcessorsFactoryBean.invoke("getObject")));
        CatchBlock catchBlock = tryStatement._catch(this.ref(Exception.class));
        catchBlock.body()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(FlowConstructInvalidException.class)).arg((Expression)catchBlock.param("e")));
    }

    private void generateCreateConnectorMethod(DefinedClass callbackClass) {
        this.createConnectorMethod = callbackClass.method(4, (Type)this.ref(Connector.class), "createConnector")._throws(this.ref(MuleException.class));
        Block body = this.createConnectorMethod.body();
        Variable muleRegistryVariable = body.decl((Type)this.ref(MuleRegistry.class), "muleRegistry", (Expression)ExpressionFactory.invoke((Expression)this.muleContextField, (String)"getRegistry"));
        Variable httpConnectorVariable = body.decl((Type)this.ref(Connector.class), "httpConnector", (Expression)ExpressionFactory.invoke((Expression)muleRegistryVariable, (String)"lookupConnector").arg("connector.http.mule.default"));
        Conditional conditional = body._if(Op.ne((Expression)httpConnectorVariable, (Expression)ExpressionFactory._null()));
        conditional._then()._return((Expression)httpConnectorVariable);
        conditional._else().block().invoke((Expression)this.loggerField, "error").arg("Could not find connector with name 'connector.http.mule.default'");
        conditional._else().block()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(DefaultMuleException.class)).arg("Could not find connector with name 'connector.http.mule.default'"));
    }

    private void generateCreateHttpInboundEndpointMethod(DefinedClass callbackClass) {
        this.createHttpInboundEndpointMethod = callbackClass.method(4, (Type)this.ref(InboundEndpoint.class), "createHttpInboundEndpoint")._throws(this.ref(MuleException.class));
        Block body = this.createHttpInboundEndpointMethod.body();
        Variable inBuilderVariable = body.decl((Type)this.ref(EndpointURIEndpointBuilder.class), "inBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(EndpointURIEndpointBuilder.class)).arg((Expression)this.localUrlField).arg((Expression)this.muleContextField));
        body.invoke((Expression)inBuilderVariable, "setConnector").arg((Expression)ExpressionFactory.invoke((Method)this.createConnectorMethod));
        body.invoke((Expression)inBuilderVariable, "setExchangePattern").arg((Expression)this.ref(MessageExchangePattern.class).staticRef(INBOUND_ENDPOINT_EXCHANGE_PATTERN));
        Variable endpointFactoryVariable = body.decl((Type)this.ref(EndpointFactory.class), "endpointFactory", (Expression)ExpressionFactory.invoke((Expression)this.muleContextField, (String)"getEndpointFactory"));
        body._return((Expression)ExpressionFactory.invoke((Expression)endpointFactoryVariable, (String)"getInboundEndpoint").arg((Expression)inBuilderVariable));
    }

    private void generateStartMethod(DefinedClass callbackClass) {
        Method startMethod = callbackClass.method(1, (Type)this.context.getCodeModel().VOID, "start")._throws(this.ref(MuleException.class));
        Block body = startMethod.body();
        body.assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.urlField), (Expression)ExpressionFactory.invoke((Method)this.buildUrlMethod));
        body.assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.localUrlField), (Expression)this.urlField.invoke("replaceFirst").arg((Expression)this.domainField).arg("localhost"));
        body.assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)this.localUrlField), (Expression)this.localUrlField.invoke("replaceFirst").arg((Expression)this.ref(String.class).staticInvoke("valueOf").arg((Expression)this.remotePortField)).arg((Expression)this.ref(String.class).staticInvoke("valueOf").arg((Expression)this.localPortField)));
        Variable dynamicFlowName = body.decl((Type)this.ref(String.class), "dynamicFlowName", (Expression)this.ref(String.class).staticInvoke("format").arg("DynamicFlow-%s").arg((Expression)this.localUrlField));
        body.assign((AssignmentTarget)this.flowConstructVariable, (Expression)ExpressionFactory._new((TypeReference)this.ref(Flow.class)).arg((Expression)dynamicFlowName).arg((Expression)this.muleContextField));
        body.invoke((Expression)this.flowConstructVariable, "setMessageSource").arg((Expression)ExpressionFactory.invoke((Method)this.createHttpInboundEndpointMethod));
        Variable messageProcessor = body.decl((Type)this.ref(MessageProcessor.class), "messageProcessor");
        Conditional ifCallbackFlowNotNull = body._if(Op.ne((Expression)this.callbackFlowField, (Expression)ExpressionFactory._null()));
        ifCallbackFlowNotNull._then().assign((AssignmentTarget)messageProcessor, (Expression)ExpressionFactory._new((TypeReference)callbackClass.listClasses()[0]));
        ifCallbackFlowNotNull._else().assign((AssignmentTarget)messageProcessor, (Expression)this.callbackMessageProcessorField);
        body._if((Expression)this.async)._then().assign((AssignmentTarget)messageProcessor, (Expression)ExpressionFactory.invoke((Method)this.wrapMessageProcessorInAsyncChain).arg((Expression)messageProcessor));
        Variable mps = body.decl((Type)this.ref(List.class).narrow(this.ref(MessageProcessor.class)), "messageProcessors", (Expression)ExpressionFactory._new((TypeReference)this.ref(ArrayList.class).narrow(MessageProcessor.class)));
        body.invoke((Expression)mps, "add").arg((Expression)messageProcessor);
        body.invoke((Expression)this.flowConstructVariable, "setMessageProcessors").arg((Expression)mps);
        body.invoke((Expression)this.flowConstructVariable, "initialise");
        body.invoke((Expression)this.flowConstructVariable, "start");
        body.invoke((Expression)this.loggerField, "debug").arg((Expression)this.ref(String.class).staticInvoke("format").arg("Created flow with http inbound endpoint listening at: %s").arg((Expression)this.urlField));
    }

    private void generateStopMethod(DefinedClass callbackClass) {
        Method stopMethod = callbackClass.method(1, (Type)this.context.getCodeModel().VOID, "stop")._throws(this.ref(MuleException.class));
        Block body = stopMethod.body();
        Block block = body._if(Op.ne((Expression)this.flowConstructVariable, (Expression)ExpressionFactory._null()))._then();
        block.invoke((Expression)this.flowConstructVariable, "stop");
        block.invoke((Expression)this.flowConstructVariable, "dispose");
        block.invoke((Expression)this.loggerField, "debug").arg("Http callback flow stopped");
    }

    private void createMessageProcessorInnerClass(DefinedClass callbackClass) {
        DefinedClass messageProcessor = callbackClass._class("FlowRefMessageProcessor")._implements(this.ref(MessageProcessor.class));
        Method processMethod = messageProcessor.method(1, (Type)this.ref(MuleEvent.class), "process")._throws(this.ref(MuleException.class));
        processMethod.param((Type)this.ref(MuleEvent.class), "event");
        processMethod.body()._return((Expression)ExpressionFactory.invoke((Expression)this.callbackFlowField, (String)"process").arg((Expression)processMethod.params().get(0)));
    }

    private DefinedClass getDefaultHttpCallbackClass(TypeElement type) {
        String httpCallbackClassName = this.context.getNameUtils().generateClassNameInPackage(type, ".config.spring", CLASS_NAME);
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(httpCallbackClassName));
        DefinedClass clazz = pkg._class(this.context.getNameUtils().getClassName(httpCallbackClassName), new Class[]{HttpCallback.class});
        this.context.setClassRole(HTTP_CALLBACK_ROLE, clazz);
        return clazz;
    }
}

