/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.adapter;

import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.apache.commons.lang.StringUtils;
import org.mule.api.Capabilities;
import org.mule.api.MuleException;
import org.mule.api.annotations.Configurable;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.config.PoolingProfile;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.Block;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.mule.util.pool.DefaultLifecycleEnabledObjectPool;
import org.mule.util.pool.LifecyleEnabledObjectPool;

public class PoolAdapterGenerator
extends AbstractMessageGenerator {
    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return typeElement.isPoolable();
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) throws GenerationException {
        DefinedClass poolAdapter = this.getPoolAdapterClass(typeElement);
        poolAdapter.javadoc().add((Object)("A <code>" + poolAdapter.name() + "</code> is a wrapper around "));
        poolAdapter.javadoc().add((Object)this.ref(typeElement.asType()));
        poolAdapter.javadoc().add((Object)" that enables pooling on the POJO.");
        for (VariableElement field : typeElement.getFieldsAnnotatedWith(Configurable.class)) {
            FieldVariable configField = poolAdapter.field(4, this.ref(field.asType()), field.getSimpleName().toString());
            this.generateSetter(poolAdapter, configField);
        }
        FieldVariable muleContext = this.generateFieldForMuleContext(poolAdapter);
        FieldVariable flowConstruct = this.generateFieldForFlowConstruct(poolAdapter);
        FieldVariable poolingProfile = poolAdapter.field(2, (Type)this.ref(PoolingProfile.class), "poolingProfile");
        FieldVariable lifecyleEnabledObjectPool = poolAdapter.field(2, (Type)this.ref(LifecyleEnabledObjectPool.class), "lifecyleEnabledObjectPool");
        this.generateSetter(poolAdapter, poolingProfile);
        this.generateGetter(poolAdapter, poolingProfile);
        this.generateSetter(poolAdapter, lifecyleEnabledObjectPool);
        this.generateGetter(poolAdapter, lifecyleEnabledObjectPool);
        this.generateSetFlowConstructMethod(poolAdapter, flowConstruct);
        this.generateSetMuleContextMethod(poolAdapter, muleContext);
        this.generateStartMethod(typeElement, poolAdapter, lifecyleEnabledObjectPool, muleContext, poolingProfile);
        this.generateStopMethod(poolAdapter, lifecyleEnabledObjectPool);
        this.generateIsCapableOf(typeElement, poolAdapter);
    }

    private void generateStopMethod(DefinedClass poolAdapter, FieldVariable lifecyleEnabledObjectPool) {
        Method stopMethod = poolAdapter.method(1, (Type)this.context.getCodeModel().VOID, "stop");
        stopMethod._throws(MuleException.class);
        Block newBody = stopMethod.body()._if(Op.ne((Expression)lifecyleEnabledObjectPool, (Expression)ExpressionFactory._null()))._then();
        newBody.add((Statement)lifecyleEnabledObjectPool.invoke("stop"));
        newBody.add((Statement)lifecyleEnabledObjectPool.invoke("close"));
        newBody.assign((AssignmentTarget)lifecyleEnabledObjectPool, ExpressionFactory._null());
    }

    private void generateStartMethod(DevKitTypeElement typeElement, DefinedClass poolAdapter, FieldVariable lifecyleEnabledObjectPool, FieldVariable muleContext, FieldVariable poolingProfile) {
        DefinedClass objectFactory = this.context.getClassForRole(this.context.getNameUtils().generatePojoFactoryKey(typeElement));
        Method startMethod = poolAdapter.method(1, (Type)this.context.getCodeModel().VOID, "start");
        startMethod._throws(MuleException.class);
        Variable objectFactoryField = startMethod.body().decl((Type)objectFactory, "objectFactory", (Expression)ExpressionFactory._new((TypeReference)objectFactory));
        for (VariableElement field : typeElement.getFieldsAnnotatedWith(Configurable.class)) {
            startMethod.body().add((Statement)objectFactoryField.invoke("set" + StringUtils.capitalize((String)field.getSimpleName().toString())).arg((Expression)ExpressionFactory._this().ref(field.getSimpleName().toString())));
        }
        Invocation defaultLifecycleEnabledObjectPool = ExpressionFactory._new((TypeReference)this.ref(DefaultLifecycleEnabledObjectPool.class));
        defaultLifecycleEnabledObjectPool.arg((Expression)objectFactoryField);
        defaultLifecycleEnabledObjectPool.arg((Expression)poolingProfile);
        defaultLifecycleEnabledObjectPool.arg((Expression)muleContext);
        startMethod.body().assign((AssignmentTarget)lifecyleEnabledObjectPool, (Expression)defaultLifecycleEnabledObjectPool);
        startMethod.body().add((Statement)lifecyleEnabledObjectPool.invoke("initialise"));
        startMethod.body().add((Statement)lifecyleEnabledObjectPool.invoke("start"));
    }

    private DefinedClass getPoolAdapterClass(TypeElement typeElement) {
        String poolAdapterName = this.context.getNameUtils().generateClassName(typeElement, ".config", "PoolAdapter");
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(poolAdapterName));
        DefinedClass clazz = pkg._class(this.context.getNameUtils().getClassName(poolAdapterName));
        clazz._implements(Startable.class);
        clazz._implements(Stoppable.class);
        clazz._implements(MuleContextAware.class);
        clazz._implements(FlowConstructAware.class);
        clazz._implements(Capabilities.class);
        this.context.setClassRole(this.context.getNameUtils().generateModuleObjectRoleKey(typeElement), clazz);
        return clazz;
    }
}

