/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.adapter;

import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.api.annotations.oauth.OAuthConsumerKey;
import org.mule.api.annotations.oauth.OAuthConsumerSecret;
import org.mule.api.annotations.oauth.OAuthScope;
import org.mule.api.oauth.OAuth2Adapter;
import org.mule.api.oauth.UnableToAcquireAccessTokenException;
import org.mule.devkit.generation.AbstractOAuthAdapterGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.Block;
import org.mule.devkit.model.code.CatchBlock;
import org.mule.devkit.model.code.Conditional;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TryStatement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.util.IOUtils;

public class OAuth2AdapterGenerator
extends AbstractOAuthAdapterGenerator {
    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return typeElement.hasAnnotation(OAuth2.class);
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) throws GenerationException {
        DefinedClass oauthAdapter = this.getOAuthAdapterClass(typeElement, "OAuth2Adapter", OAuth2Adapter.class);
        OAuth2 oauth2 = typeElement.getAnnotation(OAuth2.class);
        this.authorizationCodePatternConstant(oauthAdapter, oauth2.verifierRegex());
        this.accessTokenPatternConstant(oauthAdapter, oauth2);
        this.expirationPatternConstant(oauthAdapter, oauth2);
        this.muleContextField(oauthAdapter);
        this.authorizationCodeField(oauthAdapter);
        this.redirectUrlField(oauthAdapter);
        this.oauthCallbackField(oauthAdapter);
        this.accessTokenField(oauthAdapter);
        FieldVariable saveAccessTokenCallback = this.saveAccessTokenCallbackField(oauthAdapter);
        FieldVariable restoreAccessTokenCallback = this.restoreAccessTokenCallbackField(oauthAdapter);
        this.expirationField(oauthAdapter, typeElement.getAnnotation(OAuth2.class));
        DefinedClass messageProcessor = this.generateMessageProcessorInnerClass(oauthAdapter);
        this.generateStartMethod(oauthAdapter);
        this.generateStopMethod(oauthAdapter);
        this.generateInitialiseMethod(oauthAdapter, messageProcessor, oauth2.callbackPath());
        FieldVariable logger = FieldBuilder.newLoggerField((DefinedClass)oauthAdapter);
        this.generateGetAuthorizationUrlMethod(oauthAdapter, typeElement, oauth2, logger);
        this.generateFetchAccessTokenMethod(oauthAdapter, typeElement, oauth2, restoreAccessTokenCallback, saveAccessTokenCallback, logger);
        this.generateHasTokenExpiredMethod(oauthAdapter, oauth2);
        this.generateResetMethod(oauthAdapter, oauth2);
    }

    private void accessTokenPatternConstant(DefinedClass oauthAdapter, OAuth2 oauth2) {
        new FieldBuilder(oauthAdapter).type(Pattern.class).name("ACCESS_CODE_PATTERN").staticField().finalField().initialValue((Expression)this.ref(Pattern.class).staticInvoke("compile").arg(oauth2.accessTokenRegex())).build();
    }

    private void expirationPatternConstant(DefinedClass oauthAdapter, OAuth2 oauth2) {
        if (!StringUtils.isEmpty((String)oauth2.expirationRegex())) {
            new FieldBuilder(oauthAdapter).type(Pattern.class).name("EXPIRATION_TIME_PATTERN").staticField().finalField().initialValue((Expression)this.ref(Pattern.class).staticInvoke("compile").arg(oauth2.expirationRegex())).build();
        }
    }

    private void expirationField(DefinedClass oauthAdapter, OAuth2 oauth2) {
        if (!StringUtils.isEmpty((String)oauth2.expirationRegex())) {
            new FieldBuilder(oauthAdapter).type(Date.class).name("expiration").setter().build();
        }
    }

    private void generateGetAuthorizationUrlMethod(DefinedClass oauthAdapter, DevKitTypeElement typeElement, OAuth2 oauth2, FieldVariable logger) {
        Method getAuthorizationUrl = oauthAdapter.method(1, (Type)this.context.getCodeModel().VOID, "getAuthorizationUrl");
        getAuthorizationUrl.type((Type)this.ref(String.class));
        Variable urlBuilder = getAuthorizationUrl.body().decl((Type)this.ref(StringBuilder.class), "urlBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        getAuthorizationUrl.body().invoke((Expression)urlBuilder, "append").arg(oauth2.authorizationUrl());
        getAuthorizationUrl.body().invoke((Expression)urlBuilder, "append").arg("?");
        getAuthorizationUrl.body().invoke((Expression)urlBuilder, "append").arg("response_type=code&");
        getAuthorizationUrl.body().invoke((Expression)urlBuilder, "append").arg("client_id=");
        getAuthorizationUrl.body().invoke((Expression)urlBuilder, "append").arg((Expression)ExpressionFactory.invoke((String)this.getterMethodForFieldAnnotatedWith(typeElement, OAuthConsumerKey.class)));
        getAuthorizationUrl.body().invoke((Expression)urlBuilder, "append").arg("&redirect_uri=");
        getAuthorizationUrl.body().invoke((Expression)urlBuilder, "append").arg((Expression)oauthAdapter.fields().get("redirectUrl"));
        if (typeElement.hasFieldAnnotatedWith(OAuthScope.class)) {
            Variable scope = getAuthorizationUrl.body().decl((Type)this.ref(String.class), "scope", (Expression)ExpressionFactory.invoke((String)this.getterMethodForFieldAnnotatedWith(typeElement, OAuthScope.class)));
            Block ifScopeNotNull = getAuthorizationUrl.body()._if(Op.ne((Expression)scope, (Expression)ExpressionFactory._null()))._then();
            ifScopeNotNull.invoke((Expression)urlBuilder, "append").arg("&scope=");
            ifScopeNotNull.invoke((Expression)urlBuilder, "append").arg((Expression)scope);
        }
        getAuthorizationUrl.body().invoke((Expression)logger, "debug").arg(ExpressionFactory.direct((String)"\"OAUth 2 authorization url: \" + urlBuilder"));
        getAuthorizationUrl.body()._return((Expression)urlBuilder.invoke("toString"));
    }

    private void generateFetchAccessTokenMethod(DefinedClass oauthAdapter, DevKitTypeElement typeElement, OAuth2 oauth2, FieldVariable restoreAccessTokenCallbackField, FieldVariable saveAccessTokenCallback, FieldVariable logger) {
        Method fetchAccessToken = oauthAdapter.method(1, (Type)this.context.getCodeModel().VOID, "fetchAccessToken");
        fetchAccessToken._throws(this.ref(UnableToAcquireAccessTokenException.class));
        Conditional ifRestoreCallbackNotNull = fetchAccessToken.body()._if(Op.ne((Expression)restoreAccessTokenCallbackField, (Expression)ExpressionFactory._null()));
        Conditional ifDebugEnabled = ifRestoreCallbackNotNull._then()._if((Expression)logger.invoke("isDebugEnabled"));
        Variable messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Attempting to restore access token..."));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((Expression)messageStringBuilder.invoke("toString")));
        TryStatement tryToRestore = ifRestoreCallbackNotNull._then()._try();
        tryToRestore.body().add((Statement)restoreAccessTokenCallbackField.invoke("restoreAccessToken"));
        ifDebugEnabled = ifRestoreCallbackNotNull._then()._if((Expression)logger.invoke("isDebugEnabled"));
        messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Access token and secret has been restored successfully "));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[accessToken = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((Expression)restoreAccessTokenCallbackField.invoke("getAccessToken")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((Expression)messageStringBuilder.invoke("toString")));
        tryToRestore.body().assign((AssignmentTarget)oauthAdapter.fields().get("accessToken"), (Expression)restoreAccessTokenCallbackField.invoke("getAccessToken"));
        CatchBlock logIfCannotRestore = tryToRestore._catch(this.ref(Exception.class));
        Variable e = logIfCannotRestore.param("e");
        logIfCannotRestore.body().add((Statement)logger.invoke("error").arg("Cannot restore access token, an unexpected error occurred").arg((Expression)e));
        Conditional ifAccessTokenNull = fetchAccessToken.body()._if(Op.eq((Expression)((Expression)oauthAdapter.fields().get("accessToken")), (Expression)ExpressionFactory._null()));
        TryStatement tryStatement = ifAccessTokenNull._then()._try();
        ifDebugEnabled = tryStatement.body()._if((Expression)logger.invoke("isDebugEnabled"));
        messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Retrieving access token..."));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((Expression)messageStringBuilder.invoke("toString")));
        Block body = tryStatement.body();
        Variable conn = body.decl((Type)this.ref(HttpURLConnection.class), "conn", (Expression)ExpressionFactory.cast((Type)this.ref(HttpURLConnection.class), (Expression)ExpressionFactory._new((TypeReference)this.ref(URL.class)).arg(oauth2.accessTokenUrl()).invoke("openConnection")));
        body.invoke((Expression)conn, "setRequestMethod").arg("POST");
        body.invoke((Expression)conn, "setDoOutput").arg(ExpressionFactory.lit((boolean)true));
        Invocation consumerKey = ExpressionFactory.invoke((String)this.getterMethodForFieldAnnotatedWith(typeElement, OAuthConsumerKey.class));
        Invocation consumerSecret = ExpressionFactory.invoke((String)this.getterMethodForFieldAnnotatedWith(typeElement, OAuthConsumerSecret.class));
        Variable builder = body.decl((Type)this.ref(StringBuilder.class), "builder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        body.invoke((Expression)builder, "append").arg("code=");
        body.invoke((Expression)builder, "append").arg((Expression)this.ref(URLEncoder.class).staticInvoke("encode").arg((Expression)oauthAdapter.fields().get("oauthVerifier")).arg("UTF-8"));
        body.invoke((Expression)builder, "append").arg("&client_id=");
        body.invoke((Expression)builder, "append").arg((Expression)this.ref(URLEncoder.class).staticInvoke("encode").arg((Expression)consumerKey).arg("UTF-8"));
        body.invoke((Expression)builder, "append").arg("&client_secret=");
        body.invoke((Expression)builder, "append").arg((Expression)this.ref(URLEncoder.class).staticInvoke("encode").arg((Expression)consumerSecret).arg("UTF-8"));
        body.invoke((Expression)builder, "append").arg("&grant_type=");
        body.invoke((Expression)builder, "append").arg((Expression)this.ref(URLEncoder.class).staticInvoke("encode").arg("authorization_code").arg("UTF-8"));
        body.invoke((Expression)builder, "append").arg("&redirect_uri=");
        body.invoke((Expression)builder, "append").arg((Expression)this.ref(URLEncoder.class).staticInvoke("encode").arg((Expression)oauthAdapter.fields().get("redirectUrl")).arg("UTF-8"));
        ifDebugEnabled = tryStatement.body()._if((Expression)logger.invoke("isDebugEnabled"));
        messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Sending request to ["));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(oauth2.accessTokenUrl()));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("] using the following as content ["));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((Expression)builder.invoke("toString")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("]"));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((Expression)messageStringBuilder.invoke("toString")));
        Variable out = body.decl((Type)this.ref(OutputStreamWriter.class), "out", (Expression)ExpressionFactory._new((TypeReference)this.ref(OutputStreamWriter.class)).arg((Expression)conn.invoke("getOutputStream")));
        body.invoke((Expression)out, "write").arg((Expression)builder.invoke("toString"));
        body.invoke((Expression)out, "close");
        Variable response = body.decl((Type)this.ref(String.class), "response", (Expression)this.ref(IOUtils.class).staticInvoke("toString").arg((Expression)conn.invoke("getInputStream")));
        ifDebugEnabled = tryStatement.body()._if((Expression)logger.invoke("isDebugEnabled"));
        messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Received response ["));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((Expression)response));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("]"));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((Expression)messageStringBuilder.invoke("toString")));
        Variable matcher = body.decl((Type)this.ref(Matcher.class), "matcher", (Expression)((FieldVariable)oauthAdapter.fields().get("ACCESS_CODE_PATTERN")).invoke("matcher").arg((Expression)response));
        Conditional ifAccessTokenFound = body._if(Op.cand((Expression)matcher.invoke("find"), (Expression)Op.gte((Expression)matcher.invoke("groupCount"), (Expression)ExpressionFactory.lit((int)1))));
        Invocation group = matcher.invoke("group").arg(ExpressionFactory.lit((int)1));
        ifAccessTokenFound._then().assign((AssignmentTarget)oauthAdapter.fields().get("accessToken"), (Expression)this.ref(URLDecoder.class).staticInvoke("decode").arg((Expression)group).arg("UTF-8"));
        ifDebugEnabled = ifAccessTokenFound._then()._if((Expression)logger.invoke("isDebugEnabled"));
        messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Access token retrieved successfully "));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[accessToken = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((Expression)oauthAdapter.fields().get("accessToken")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((Expression)messageStringBuilder.invoke("toString")));
        ifAccessTokenFound._else()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(Exception.class)).arg((Expression)this.ref(String.class).staticInvoke("format").arg("OAuth access token could not be extracted from: %s").arg((Expression)response)));
        Conditional ifSaveCallbackNotNull = ifAccessTokenFound._then()._if(Op.ne((Expression)saveAccessTokenCallback, (Expression)ExpressionFactory._null()));
        Invocation saveAccessToken = saveAccessTokenCallback.invoke("saveAccessToken").arg((Expression)oauthAdapter.fields().get("accessToken")).arg(ExpressionFactory._null());
        TryStatement tryToSave = ifSaveCallbackNotNull._then()._try();
        ifDebugEnabled = ifSaveCallbackNotNull._then()._if((Expression)logger.invoke("isDebugEnabled"));
        messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Attempting to save access token..."));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[accessToken = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((Expression)oauthAdapter.fields().get("accessToken")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((Expression)messageStringBuilder.invoke("toString")));
        tryToSave.body().add((Statement)saveAccessToken);
        CatchBlock logIfCannotSave = tryToSave._catch(this.ref(Exception.class));
        Variable e2 = logIfCannotSave.param("e");
        logIfCannotSave.body().add((Statement)logger.invoke("error").arg("Cannot save access token, an unexpected error occurred").arg((Expression)e2));
        if (!StringUtils.isEmpty((String)oauth2.expirationRegex())) {
            ifDebugEnabled = ifAccessTokenFound._then()._if((Expression)logger.invoke("isDebugEnabled"));
            messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Attempting to extract expiration time using "));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[expirationPattern = ")));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(oauth2.expirationRegex()));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
            ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((Expression)messageStringBuilder.invoke("toString")));
            Variable expirationMatcher = ifAccessTokenFound._then().decl((Type)this.ref(Matcher.class), "expirationMatcher", (Expression)((FieldVariable)oauthAdapter.fields().get("EXPIRATION_TIME_PATTERN")).invoke("matcher").arg((Expression)response));
            Conditional ifExpirationFound = ifAccessTokenFound._then()._if(Op.cand((Expression)expirationMatcher.invoke("find"), (Expression)Op.gte((Expression)expirationMatcher.invoke("groupCount"), (Expression)ExpressionFactory.lit((int)1))));
            Variable seconds = ifExpirationFound._then().decl((Type)this.ref(Long.class), "expirationSecsAhead", (Expression)this.ref(Long.class).staticInvoke("parseLong").arg((Expression)expirationMatcher.invoke("group").arg(ExpressionFactory.lit((int)1))));
            ifExpirationFound._then().assign((AssignmentTarget)oauthAdapter.fields().get("expiration"), (Expression)ExpressionFactory._new((TypeReference)this.ref(Date.class)).arg(Op.plus((Expression)this.ref(System.class).staticInvoke("currentTimeMillis"), (Expression)Op.mul((Expression)seconds, (Expression)ExpressionFactory.lit((int)1000)))));
            ifDebugEnabled = ifExpirationFound._then()._if((Expression)logger.invoke("isDebugEnabled"));
            messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Token expiration extracted successfully "));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[expiration = ")));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((Expression)oauthAdapter.fields().get("expiration")));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
            ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((Expression)messageStringBuilder.invoke("toString")));
            ifDebugEnabled = ifExpirationFound._else()._if((Expression)logger.invoke("isDebugEnabled"));
            messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Token expiration could not be extracted from "));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[response = ")));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((Expression)response));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
            ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((Expression)messageStringBuilder.invoke("toString")));
        }
        this.generateReThrow(tryStatement, Exception.class, RuntimeException.class);
    }

    private void generateHasTokenExpiredMethod(DefinedClass oauthAdapter, OAuth2 oauth2) {
        Method hasTokenExpired = oauthAdapter.method(1, (Type)this.context.getCodeModel().BOOLEAN, "hasTokenExpired");
        if (!StringUtils.isEmpty((String)oauth2.expirationRegex())) {
            FieldVariable expirationDate = (FieldVariable)oauthAdapter.fields().get("expiration");
            hasTokenExpired.body()._return(Op.cand((Expression)Op.ne((Expression)expirationDate, (Expression)ExpressionFactory._null()), (Expression)expirationDate.invoke("before").arg((Expression)ExpressionFactory._new((TypeReference)this.ref(Date.class)))));
        } else {
            hasTokenExpired.body()._return(ExpressionFactory.FALSE);
        }
    }

    private void generateResetMethod(DefinedClass oauthAdapter, OAuth2 oauth2) {
        Method reset = oauthAdapter.method(1, (Type)this.context.getCodeModel().VOID, "reset");
        if (!StringUtils.isEmpty((String)oauth2.expirationRegex())) {
            reset.body().assign((AssignmentTarget)oauthAdapter.fields().get("expiration"), ExpressionFactory._null());
        }
        reset.body().assign((AssignmentTarget)oauthAdapter.fields().get("oauthVerifier"), ExpressionFactory._null());
        reset.body().assign((AssignmentTarget)oauthAdapter.fields().get("accessToken"), ExpressionFactory._null());
    }

    private void generateReThrow(TryStatement tryStatement, Class<? extends Exception> exceptionToCatch, Class<? extends Exception> exceptionToThrow) {
        CatchBlock catchBlock = tryStatement._catch(this.ref(exceptionToCatch));
        Variable caughtException = catchBlock.param("e");
        catchBlock.body()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(exceptionToThrow)).arg((Expression)caughtException));
    }
}

