/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.adapter;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.api.annotations.lifecycle.Start;
import org.mule.api.annotations.lifecycle.Stop;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.config.MuleManifest;
import org.mule.devkit.generation.AbstractModuleGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.model.code.Block;
import org.mule.devkit.model.code.CatchBlock;
import org.mule.devkit.model.code.Conditional;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.ForLoop;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TryStatement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleAdapterGenerator
extends AbstractModuleGenerator {
    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return true;
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) {
        DefinedClass lifecycleAdapter = this.getLifecycleAdapterClass(typeElement);
        lifecycleAdapter.javadoc().add((Object)("A <code>" + lifecycleAdapter.name() + "</code> is a wrapper around "));
        lifecycleAdapter.javadoc().add((Object)this.ref(typeElement.asType()));
        lifecycleAdapter.javadoc().add((Object)" that adds lifecycle methods to the pojo.");
        ExecutableElement startElement = this.getStartElement(typeElement);
        lifecycleAdapter._implements(Startable.class);
        Method start = this.generateLifecycleInvocation(lifecycleAdapter, typeElement, startElement, "start", DefaultMuleException.class, false);
        start._throws(this.ref(MuleException.class));
        ExecutableElement stopElement = this.getStopElement(typeElement);
        lifecycleAdapter._implements(Stoppable.class);
        Method stop = this.generateLifecycleInvocation(lifecycleAdapter, typeElement, stopElement, "stop", DefaultMuleException.class, false);
        stop._throws(this.ref(MuleException.class));
        ExecutableElement postConstructElement = this.getPostConstructElement(typeElement);
        lifecycleAdapter._implements(Initialisable.class);
        this.generateLifecycleInvocation(lifecycleAdapter, typeElement, postConstructElement, "initialise", InitialisationException.class, true);
        ExecutableElement preDestroyElement = this.getPreDestroyElement(typeElement);
        lifecycleAdapter._implements(Disposable.class);
        this.generateLifecycleInvocation(lifecycleAdapter, typeElement, preDestroyElement, "dispose", null, false);
    }

    private DefinedClass getLifecycleAdapterClass(TypeElement typeElement) {
        String lifecycleAdapterName = this.context.getNameUtils().generateClassName(typeElement, ".config", "LifecycleAdapter");
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(lifecycleAdapterName));
        DefinedClass previous = this.context.getClassForRole(this.context.getNameUtils().generateModuleObjectRoleKey(typeElement));
        DefinedClass clazz = pkg._class(this.context.getNameUtils().getClassName(lifecycleAdapterName), (TypeReference)previous);
        this.context.setClassRole(this.context.getNameUtils().generateModuleObjectRoleKey(typeElement), clazz);
        return clazz;
    }

    private Method generateLifecycleInvocation(DefinedClass lifecycleWrapper, DevKitTypeElement typeElement, ExecutableElement superExecutableElement, String name, Class<?> catchException, boolean addThis) {
        Method lifecycleMethod = lifecycleWrapper.method(1, (Type)this.context.getCodeModel().VOID, name);
        if (name.equals("initialise")) {
            Variable log = lifecycleMethod.body().decl((Type)this.ref(Logger.class), "log", (Expression)this.ref(LoggerFactory.class).staticInvoke("getLogger").arg(lifecycleWrapper.dotclass()));
            Variable runtimeVersion = lifecycleMethod.body().decl((Type)this.ref(String.class), "runtimeVersion", (Expression)this.ref(MuleManifest.class).staticInvoke("getProductVersion"));
            Conditional ifUnkownVersion = lifecycleMethod.body()._if((Expression)runtimeVersion.invoke("equals").arg("Unknown"));
            ifUnkownVersion._then().add((Statement)log.invoke("warn").arg(ExpressionFactory.lit((String)"Unknown Mule runtime version. This module may not work properly!")));
            Block ifKnownVersion = ifUnkownVersion._else();
            Variable variable = ifKnownVersion.decl((Type)this.ref(String[].class), "expectedMinVersion", (Expression)ExpressionFactory.lit((String)typeElement.minMuleVersion()).invoke("split").arg("\\."));
            Variable currentRuntimeVersion = ifKnownVersion.decl((Type)this.ref(String[].class), "currentRuntimeVersion", (Expression)runtimeVersion.invoke("split").arg("\\."));
            ForLoop forEachVersionComponent = ifKnownVersion._for();
            Variable i = forEachVersionComponent.init((Type)this.context.getCodeModel().INT, "i", ExpressionFactory.lit((int)0));
            forEachVersionComponent.test(Op.lt((Expression)i, (Expression)variable.ref("length")));
            forEachVersionComponent.update(Op.incr((Expression)i));
            forEachVersionComponent.body()._if(Op.lt((Expression)this.ref(Integer.class).staticInvoke("parseInt").arg((Expression)currentRuntimeVersion.component((Expression)i)), (Expression)this.ref(Integer.class).staticInvoke("parseInt").arg((Expression)variable.component((Expression)i))))._then()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("This module is only valid for Mule " + typeElement.minMuleVersion()));
        }
        if (catchException != null && superExecutableElement != null && superExecutableElement.getThrownTypes() != null && superExecutableElement.getThrownTypes().size() > 0) {
            lifecycleMethod._throws(this.ref(catchException));
        }
        if (superExecutableElement != null) {
            Invocation startInvocation = ExpressionFactory._super().invoke(superExecutableElement.getSimpleName().toString());
            if (superExecutableElement.getThrownTypes().size() > 0) {
                TryStatement tryBlock = lifecycleMethod.body()._try();
                tryBlock.body().add((Statement)startInvocation);
                int i = 0;
                for (TypeMirror typeMirror : superExecutableElement.getThrownTypes()) {
                    CatchBlock catchBlock = tryBlock._catch(this.ref(typeMirror).boxify());
                    Variable catchedException = catchBlock.param("e" + i);
                    Invocation newMuleException = ExpressionFactory._new((TypeReference)this.ref(catchException));
                    newMuleException.arg((Expression)catchedException);
                    if (addThis) {
                        newMuleException.arg(ExpressionFactory._this());
                    }
                    catchBlock.body().add((Statement)newMuleException);
                    ++i;
                }
            } else {
                lifecycleMethod.body().add((Statement)startInvocation);
            }
        }
        return lifecycleMethod;
    }

    private ExecutableElement getStartElement(DevKitTypeElement typeElement) {
        List<ExecutableElement> startMethods = typeElement.getMethodsAnnotatedWith(Start.class);
        return !startMethods.isEmpty() ? startMethods.get(0) : null;
    }

    private ExecutableElement getStopElement(DevKitTypeElement typeElement) {
        List<ExecutableElement> stopMethods = typeElement.getMethodsAnnotatedWith(Stop.class);
        return !stopMethods.isEmpty() ? stopMethods.get(0) : null;
    }

    private ExecutableElement getPostConstructElement(DevKitTypeElement typeElement) {
        List<ExecutableElement> postConstructMethods = typeElement.getMethodsAnnotatedWith(PostConstruct.class);
        return !postConstructMethods.isEmpty() ? postConstructMethods.get(0) : null;
    }

    private ExecutableElement getPreDestroyElement(DevKitTypeElement typeElement) {
        List<ExecutableElement> preDestroyMethods = typeElement.getMethodsAnnotatedWith(PreDestroy.class);
        return !preDestroyMethods.isEmpty() ? preDestroyMethods.get(0) : null;
    }
}

