/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.adapter;

import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.annotations.Configurable;
import org.mule.api.lifecycle.InitialisationCallback;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.object.ObjectFactory;
import org.mule.devkit.generation.AbstractModuleGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;

public class LifecycleAdapterFactoryGenerator
extends AbstractModuleGenerator {
    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return typeElement.isPoolable();
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) {
        DefinedClass lifecycleAdapterFactory = this.getLifecycleAdapterFactoryClass(typeElement);
        lifecycleAdapterFactory.javadoc().add((Object)("A <code>" + lifecycleAdapterFactory.name() + "</code> is an implementation  "));
        lifecycleAdapterFactory.javadoc().add((Object)" of {@link ObjectFactory} interface for ");
        lifecycleAdapterFactory.javadoc().add((Object)this.ref(typeElement.asType()));
        DefinedClass poolObjectClass = this.context.getClassForRole(this.context.getNameUtils().generateModuleObjectRoleKey(typeElement));
        this.context.setClassRole(this.context.getNameUtils().generatePoolObjectRoleKey(typeElement), poolObjectClass);
        this.generateFields(typeElement, lifecycleAdapterFactory);
        this.generateInitialiseMethod(lifecycleAdapterFactory);
        this.generateDisposeMethod(lifecycleAdapterFactory);
        this.generateGetInstanceMethod(typeElement, lifecycleAdapterFactory, poolObjectClass);
        this.generateGetObjectClassMethod(lifecycleAdapterFactory, poolObjectClass);
        this.generateAddObjectInitialisationCallback(lifecycleAdapterFactory);
        this.generateIsSingleton(lifecycleAdapterFactory);
        this.generateIsAutoWireObject(lifecycleAdapterFactory);
        this.generateIsExternallyManagedLifecycle(lifecycleAdapterFactory);
    }

    private void generateIsExternallyManagedLifecycle(DefinedClass lifecycleAdapterFactory) {
        Method isExternallyManagedLifecycle = lifecycleAdapterFactory.method(1, (Type)this.context.getCodeModel().BOOLEAN, "isExternallyManagedLifecycle");
        isExternallyManagedLifecycle.body()._return(ExpressionFactory.FALSE);
    }

    private void generateIsAutoWireObject(DefinedClass lifecycleAdapterFactory) {
        Method isAutoWireObject = lifecycleAdapterFactory.method(1, (Type)this.context.getCodeModel().BOOLEAN, "isAutoWireObject");
        isAutoWireObject.body()._return(ExpressionFactory.FALSE);
    }

    private void generateIsSingleton(DefinedClass lifecycleAdapterFactory) {
        Method isSingleton = lifecycleAdapterFactory.method(1, (Type)this.context.getCodeModel().BOOLEAN, "isSingleton");
        isSingleton.body()._return(ExpressionFactory.FALSE);
    }

    private void generateAddObjectInitialisationCallback(DefinedClass lifecycleAdapterFactory) {
        Method addObjectInitialisationCallback = lifecycleAdapterFactory.method(1, (Type)this.context.getCodeModel().VOID, "addObjectInitialisationCallback");
        addObjectInitialisationCallback.param((Type)this.ref(InitialisationCallback.class), "callback");
        addObjectInitialisationCallback.body()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(UnsupportedOperationException.class)));
    }

    private void generateGetObjectClassMethod(DefinedClass lifecycleAdapterFactory, DefinedClass poolObjectClass) {
        Method getObjectClass = lifecycleAdapterFactory.method(1, (Type)this.ref(Class.class), "getObjectClass");
        getObjectClass.body()._return(poolObjectClass.dotclass());
    }

    private void generateGetInstanceMethod(DevKitTypeElement typeElement, DefinedClass lifecycleAdapterFactory, DefinedClass poolObjectClass) {
        Method getInstance = lifecycleAdapterFactory.method(1, (Type)this.ref(Object.class), "getInstance");
        getInstance.param((Type)this.ref(MuleContext.class), "muleContext");
        Variable object = getInstance.body().decl((Type)poolObjectClass, "object", (Expression)ExpressionFactory._new((TypeReference)poolObjectClass));
        for (VariableElement variable : typeElement.getFieldsAnnotatedWith(Configurable.class)) {
            getInstance.body().add((Statement)object.invoke("set" + StringUtils.capitalize((String)variable.getSimpleName().toString())).arg((Expression)ExpressionFactory._this().ref(variable.getSimpleName().toString())));
        }
        getInstance.body()._return((Expression)object);
    }

    private void generateDisposeMethod(DefinedClass lifecycleAdapterFactory) {
        lifecycleAdapterFactory.method(1, (Type)this.context.getCodeModel().VOID, "dispose");
    }

    private void generateInitialiseMethod(DefinedClass lifecycleAdapterFactory) {
        Method initialise = lifecycleAdapterFactory.method(1, (Type)this.context.getCodeModel().VOID, "initialise");
        initialise._throws(this.ref(InitialisationException.class));
    }

    private void generateFields(DevKitTypeElement typeElement, DefinedClass lifecycleAdapterFactory) {
        for (VariableElement variable : typeElement.getFieldsAnnotatedWith(Configurable.class)) {
            FieldVariable configField = lifecycleAdapterFactory.field(4, this.ref(variable.asType()), variable.getSimpleName().toString());
            this.generateSetter(lifecycleAdapterFactory, configField);
        }
    }

    private DefinedClass getLifecycleAdapterFactoryClass(TypeElement typeElement) {
        String lifecycleAdapterName = this.context.getNameUtils().generateClassName(typeElement, ".config", "LifecycleAdapterFactory");
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(lifecycleAdapterName));
        DefinedClass clazz = pkg._class(this.context.getNameUtils().getClassName(lifecycleAdapterName));
        clazz._implements(this.ref(ObjectFactory.class));
        this.context.setClassRole(this.context.getNameUtils().generatePojoFactoryKey(typeElement), clazz);
        return clazz;
    }
}

