/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.apache.commons.lang.StringUtils;
import org.mule.api.Capability;
import org.mule.api.MuleContext;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.ValidateConnection;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.devkit.generation.AbstractGenerator;
import org.mule.devkit.generation.DefaultDevKitTypeElement;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.Conditional;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldRef;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModuleGenerator
extends AbstractGenerator {
    protected static final String MULE_CONTEXT_FIELD_NAME = "muleContext";

    public Type ref(TypeMirror typeMirror) {
        return this.context.getCodeModel().ref(typeMirror);
    }

    public TypeReference ref(Class<?> clazz) {
        return this.context.getCodeModel().ref(clazz);
    }

    public Type ref(String fullyQualifiedClassName) {
        return this.context.getCodeModel().ref(fullyQualifiedClassName);
    }

    protected FieldVariable generateLoggerField(DefinedClass clazz) {
        return clazz.field(20, (Type)this.ref(Logger.class), "logger", (Expression)this.ref(LoggerFactory.class).staticInvoke("getLogger").arg(clazz.dotclass()));
    }

    protected Method generateSetter(DefinedClass clazz, FieldVariable field) {
        Method setter = clazz.method(1, (Type)this.context.getCodeModel().VOID, "set" + StringUtils.capitalize((String)field.name()));
        setter.javadoc().add((Object)("Sets " + field.name()));
        setter.javadoc().addParam("value Value to set");
        Variable value = setter.param(field.type(), "value");
        setter.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)field), (Expression)value);
        return setter;
    }

    protected Method generateGetter(DefinedClass clazz, FieldVariable field) {
        Method setter = clazz.method(1, field.type(), "get" + StringUtils.capitalize((String)field.name()));
        setter.javadoc().add((Object)("Retrieves " + field.name()));
        setter.body()._return((Expression)ExpressionFactory._this().ref((Variable)field));
        return setter;
    }

    protected FieldVariable generateFieldForMuleContext(DefinedClass messageProcessorClass) {
        FieldVariable muleContext = messageProcessorClass.field(4, (Type)this.ref(MuleContext.class), MULE_CONTEXT_FIELD_NAME);
        muleContext.javadoc().add((Object)"Mule Context");
        return muleContext;
    }

    protected Expression isNull(Invocation invocation) {
        return Op.eq((Expression)invocation, (Expression)ExpressionFactory._null());
    }

    protected String getterMethodForFieldAnnotatedWith(TypeElement typeElement, Class<? extends Annotation> annotation) {
        return this.methodForFieldAnnotatedWith(typeElement, annotation, "get");
    }

    private String methodForFieldAnnotatedWith(TypeElement typeElement, Class<? extends Annotation> annotation, String prefix) {
        List<VariableElement> fields = ElementFilter.fieldsIn(typeElement.getEnclosedElements());
        for (VariableElement field : fields) {
            if (field.getAnnotation(annotation) == null) continue;
            return prefix + StringUtils.capitalize((String)field.getSimpleName().toString());
        }
        return null;
    }

    protected ExecutableElement connectMethodForClass(DevKitTypeElement typeElement) {
        List<ExecutableElement> connectMethods = typeElement.getMethodsAnnotatedWith(Connect.class);
        return !connectMethods.isEmpty() ? connectMethods.get(0) : null;
    }

    protected ExecutableElement validateConnectionMethodForClass(DevKitTypeElement typeElement) {
        List<ExecutableElement> connectMethods = typeElement.getMethodsAnnotatedWith(ValidateConnection.class);
        return !connectMethods.isEmpty() ? connectMethods.get(0) : null;
    }

    protected ExecutableElement disconnectMethodForClass(DevKitTypeElement typeElement) {
        List<ExecutableElement> disconnectMethods = typeElement.getMethodsAnnotatedWith(Disconnect.class);
        return !disconnectMethods.isEmpty() ? disconnectMethods.get(0) : null;
    }

    protected ExecutableElement connectionIdentifierMethodForClass(DevKitTypeElement typeElement) {
        List<ExecutableElement> connectionIdentifierMethods = typeElement.getMethodsAnnotatedWith(ConnectionIdentifier.class);
        return !connectionIdentifierMethods.isEmpty() ? connectionIdentifierMethods.get(0) : null;
    }

    protected ExecutableElement connectForMethod(ExecutableElement executableElement) {
        return this.connectMethodForClass(new DefaultDevKitTypeElement((TypeElement)executableElement.getEnclosingElement()));
    }

    protected ExecutableElement connectionIdentifierForMethod(ExecutableElement executableElement) {
        return this.connectionIdentifierMethodForClass(new DefaultDevKitTypeElement((TypeElement)executableElement.getEnclosingElement()));
    }

    protected void generateIsCapableOf(DevKitTypeElement typeElement, DefinedClass capabilitiesAdapter) {
        Method isCapableOf = capabilitiesAdapter.method(1, (Type)this.context.getCodeModel().BOOLEAN, "isCapableOf");
        Variable capability = isCapableOf.param((Type)this.ref(Capability.class), "capability");
        isCapableOf.javadoc().add((Object)"Returns true if this module implements such capability");
        this.addCapability(isCapableOf, capability, this.ref(Capability.class).staticRef("LIFECYCLE_CAPABLE"));
        if (typeElement.hasAnnotation(OAuth2.class)) {
            this.addCapability(isCapableOf, capability, this.ref(Capability.class).staticRef("OAUTH2_CAPABLE"));
        }
        if (typeElement.hasAnnotation(OAuth.class)) {
            this.addCapability(isCapableOf, capability, this.ref(Capability.class).staticRef("OAUTH1_CAPABLE"));
        }
        if (typeElement.isPoolable()) {
            this.addCapability(isCapableOf, capability, this.ref(Capability.class).staticRef("POOLING_CAPABLE"));
        }
        ExecutableElement connectMethod = this.connectMethodForClass(typeElement);
        ExecutableElement disconnectMethod = this.disconnectMethodForClass(typeElement);
        if (connectMethod != null && disconnectMethod != null) {
            this.addCapability(isCapableOf, capability, this.ref(Capability.class).staticRef("CONNECTION_MANAGEMENT_CAPABLE"));
        }
        isCapableOf.body()._return(ExpressionFactory.FALSE);
    }

    private void addCapability(Method capableOf, Variable capability, FieldRef capabilityToCheckFor) {
        Conditional isCapable = capableOf.body()._if(Op.eq((Expression)capability, (Expression)capabilityToCheckFor));
        isCapable._then()._return(ExpressionFactory.TRUE);
    }
}

