/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.Plugin;
import org.mule.devkit.generation.DefaultDevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.devkit.generation.Generator;
import org.mule.devkit.validation.ValidationException;
import org.mule.devkit.validation.Validator;

@SupportedAnnotationTypes(value={"org.mule.api.annotations.Module", "org.mule.api.annotations.Connector"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class ModuleAnnotationProcessor
extends AbstractProcessor {
    private GeneratorContext context;
    private List<Plugin> plugins;

    public List<Plugin> getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList<Plugin>();
            URLClassLoader ucl = this.getUserClassLoader(this.getClass().getClassLoader());
            this.plugins.addAll(ModuleAnnotationProcessor.findServices(Plugin.class, ucl));
        }
        return this.plugins;
    }

    public URLClassLoader getUserClassLoader(ClassLoader parent) {
        String classpath = this.processingEnv.getOptions().get("-cp");
        if (classpath == null) {
            classpath = this.processingEnv.getOptions().get("-classpath");
        }
        ArrayList<URL> classpaths = new ArrayList<URL>();
        if (classpath != null) {
            for (String p : classpath.split(File.pathSeparator)) {
                File file = new File(p);
                try {
                    classpaths.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    this.warn(e.getMessage());
                }
            }
        }
        return new URLClassLoader(classpaths.toArray(new URL[classpaths.size()]), parent);
    }

    private static <T> List<T> findServices(Class<T> clazz, ClassLoader classLoader) {
        ServiceLoader<T> itr = ServiceLoader.load(clazz, classLoader);
        ArrayList r = new ArrayList();
        for (Object t : itr) {
            r.add(t);
        }
        return r;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        this.createContext();
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> elements = env.getElementsAnnotatedWith(typeElement);
            Set<TypeElement> typeElements = ElementFilter.typesIn(elements);
            for (TypeElement e : typeElements) {
                DefaultDevKitTypeElement devKitTypeElement = new DefaultDevKitTypeElement(e);
                try {
                    for (Plugin plugin : this.getPlugins()) {
                        for (Validator validator : plugin.getValidators()) {
                            if (!validator.shouldValidate(devKitTypeElement, this.context)) continue;
                            validator.validate(devKitTypeElement, this.context);
                        }
                        for (Generator generator : plugin.getGenerators()) {
                            generator.generate(devKitTypeElement, this.context);
                        }
                    }
                }
                catch (ValidationException tve) {
                    this.error(tve.getMessage(), tve.getElement());
                    return false;
                }
                catch (GenerationException ge) {
                    this.error(ge.getMessage());
                    return false;
                }
            }
        }
        try {
            this.context.getCodeModel().build();
        }
        catch (IOException e) {
            this.error(e.getMessage());
            return false;
        }
        try {
            this.context.getSchemaModel().build();
        }
        catch (IOException e) {
            this.error(e.getMessage());
            return false;
        }
        try {
            this.context.getStudioModel().build();
        }
        catch (IOException e) {
            this.error(e.getMessage());
            return false;
        }
        return true;
    }

    public void setPlugins(List<Plugin> plugins) {
        this.plugins = plugins;
    }

    private void createContext() {
        this.context = new GeneratorContext(this.processingEnv);
    }

    protected GeneratorContext getContext() {
        return this.context;
    }

    protected void note(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
    }

    protected void warn(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg);
    }

    protected void error(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
    }

    protected void error(String msg, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element);
    }
}

