/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mule.devkit.model.code.CodeModel;
import org.mule.devkit.model.code.CodeWriter;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.writer.FilerCodeWriter;
import org.mule.devkit.model.schema.SchemaModel;
import org.mule.devkit.model.studio.StudioModel;
import org.mule.devkit.utils.JavaDocUtils;
import org.mule.devkit.utils.NameUtils;
import org.mule.devkit.utils.SourceUtils;
import org.mule.devkit.utils.TypeMirrorUtils;

public class GeneratorContext {
    private CodeModel codeModel;
    private SchemaModel schemaModel;
    private StudioModel studioModel;
    private List<DefinedClass> registerAtBoot = new ArrayList<DefinedClass>();
    private Map<String, DefinedClass> roles;
    private Types types;
    private Elements elements;
    private TypeMirrorUtils typeMirrorUtils;
    private NameUtils nameUtils;
    private JavaDocUtils javaDocUtils;
    private Map<String, String> options;
    private Set<TypeMirror> registeredEnums;
    private SourceUtils sourceUtils;
    private Map<String, String> envOptions;

    public GeneratorContext(ProcessingEnvironment env) {
        this.codeModel = new CodeModel((CodeWriter)new FilerCodeWriter(env.getFiler()));
        this.schemaModel = new SchemaModel((CodeWriter)new FilerCodeWriter(env.getFiler()));
        this.roles = new HashMap<String, DefinedClass>();
        this.elements = env.getElementUtils();
        this.types = env.getTypeUtils();
        this.typeMirrorUtils = new TypeMirrorUtils(this.types);
        this.nameUtils = new NameUtils(this.elements);
        this.javaDocUtils = new JavaDocUtils(this.elements);
        this.studioModel = new StudioModel((CodeWriter)new FilerCodeWriter(env.getFiler()));
        this.options = env.getOptions();
        this.sourceUtils = new SourceUtils(env);
        this.registeredEnums = new HashSet<TypeMirror>();
        this.envOptions = Collections.unmodifiableMap(env.getOptions());
    }

    public CodeModel getCodeModel() {
        return this.codeModel;
    }

    public List<DefinedClass> getRegisterAtBoot() {
        return this.registerAtBoot;
    }

    public void registerAtBoot(DefinedClass clazz) {
        this.registerAtBoot.add(clazz);
    }

    public SchemaModel getSchemaModel() {
        return this.schemaModel;
    }

    public Types getTypeUtils() {
        return this.types;
    }

    public Elements getElementsUtils() {
        return this.elements;
    }

    public void setClassRole(String role, DefinedClass clazz) {
        this.roles.put(role, clazz);
    }

    public DefinedClass getClassForRole(String role) {
        return this.roles.get(role);
    }

    public TypeMirrorUtils getTypeMirrorUtils() {
        return this.typeMirrorUtils;
    }

    public NameUtils getNameUtils() {
        return this.nameUtils;
    }

    public JavaDocUtils getJavaDocUtils() {
        return this.javaDocUtils;
    }

    public StudioModel getStudioModel() {
        return this.studioModel;
    }

    public boolean hasOption(String option) {
        return this.options.containsKey(option);
    }

    public void registerEnum(TypeMirror enumToRegister) {
        this.registeredEnums.add(enumToRegister);
    }

    public boolean isEnumRegistered(TypeMirror enumToCheck) {
        return this.registeredEnums.contains(enumToCheck);
    }

    public SourceUtils getSourceUtils() {
        return this.sourceUtils;
    }

    public boolean isEnvOptionSet(String envOption) {
        return this.envOptions.containsKey(envOption);
    }
}

