/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.utils;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenUtils {
    public static final String DOT_M2_DIR = ".m2";
    public static final String ENV_M2_HOME = "M2_HOME";
    public static final String M2_DIR = "m2";
    public static final String BIN_DIR = "bin";
    public static final String M2_CONF_FILE = "m2.conf";
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.US);
    public static final boolean isMac = OS_NAME.toLowerCase().startsWith("mac");
    public static final boolean isLinux = OS_NAME.toLowerCase().startsWith("linux");

    @Nullable
    public static File resolveMavenHomeDirectory() {
        File home;
        File underUserHome;
        File mavenHomeFile;
        File homeFromEnv;
        String m2home = System.getenv(ENV_M2_HOME);
        if (!MavenUtils.isEmptyOrSpaces(m2home) && MavenUtils.isValidMavenHome(homeFromEnv = new File(m2home))) {
            return homeFromEnv;
        }
        String mavenHome = System.getenv("MAVEN_HOME");
        if (!MavenUtils.isEmptyOrSpaces(mavenHome) && MavenUtils.isValidMavenHome(mavenHomeFile = new File(mavenHome))) {
            return mavenHomeFile;
        }
        String userHome = MavenUtils.getUserHome();
        if (!MavenUtils.isEmptyOrSpaces(userHome) && MavenUtils.isValidMavenHome(underUserHome = new File(userHome, M2_DIR))) {
            return underUserHome;
        }
        if (isMac) {
            home = MavenUtils.fromBrew();
            if (home != null) {
                return home;
            }
            home = MavenUtils.fromMacSystemJavaTools();
            if (home != null) {
                return home;
            }
        } else if (isLinux) {
            home = new File("/usr/share/maven");
            if (MavenUtils.isValidMavenHome(home)) {
                return home;
            }
            home = new File("/usr/share/maven2");
            if (MavenUtils.isValidMavenHome(home)) {
                return home;
            }
        }
        return null;
    }

    @Nullable
    private static File fromMacSystemJavaTools() {
        File file;
        File symlinkDir = new File("/usr/share/maven");
        if (MavenUtils.isValidMavenHome(symlinkDir)) {
            return symlinkDir;
        }
        File dir = new File("/usr/share/java");
        String[] list = dir.list();
        if (list == null || list.length == 0) {
            return null;
        }
        String home = null;
        String prefix = "maven-";
        int versionIndex = "maven-".length();
        for (String path : list) {
            if (!path.startsWith("maven-") || home != null && MavenUtils.compareVersionNumbers(path.substring(versionIndex), home.substring(versionIndex)) <= 0) continue;
            home = path;
        }
        if (home != null && MavenUtils.isValidMavenHome(file = new File(dir, home))) {
            return file;
        }
        return null;
    }

    @Nullable
    private static File fromBrew() {
        File file;
        File brewDir = new File("/usr/local/Cellar/maven");
        String[] list = brewDir.list();
        if (list == null || list.length == 0) {
            return null;
        }
        if (list.length > 1) {
            Arrays.sort(list, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return MavenUtils.compareVersionNumbers(o2, o1);
                }
            });
        }
        return MavenUtils.isValidMavenHome(file = new File(brewDir, list[0] + "/libexec")) ? file : null;
    }

    public static boolean isEmptyOrSpaces(@Nullable String str) {
        return str == null || str.length() == 0 || str.trim().length() == 0;
    }

    public static boolean isValidMavenHome(File home) {
        return MavenUtils.getMavenConfFile(home).exists();
    }

    public static File getMavenConfFile(File mavenHome) {
        return new File(new File(mavenHome, BIN_DIR), M2_CONF_FILE);
    }

    @NotNull
    public static File resolveM2Dir() {
        return new File(MavenUtils.getUserHome(), DOT_M2_DIR);
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static int compareVersionNumbers(String version1, String version2) {
        DefaultArtifactVersion minVersion = new DefaultArtifactVersion(version1);
        DefaultArtifactVersion actualVersion = new DefaultArtifactVersion(version2);
        return minVersion.compareTo((ArtifactVersion)actualVersion);
    }
}

