/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.mule.tools.devkit.ctf.exceptions.CTFUtilsException;
import org.w3c.dom.Document;

public final class CTFFileUtils {
    private static String XMLIndent = "{http://xml.apache.org/xslt}indent-amount";

    private CTFFileUtils() {
    }

    public static void closeXML(Document workingDocument, String filePath) throws CTFUtilsException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty(XMLIndent, "1");
            DOMSource source = new DOMSource(workingDocument);
            StreamResult result = new StreamResult(new File(filePath));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new CTFUtilsException("Can not close XML document", e);
        }
    }

    public static String getPathIfExists(String basePath, String ... more) throws CTFUtilsException {
        try {
            Path pathFile = Paths.get(basePath, more);
            if (Files.exists(pathFile, LinkOption.NOFOLLOW_LINKS)) {
                return pathFile.toString();
            }
        }
        catch (Exception e) {
            throw new CTFUtilsException("Path does not exist " + basePath, e);
        }
        return null;
    }

    public static Document openXML(String filePath) throws CTFUtilsException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        Document ret = null;
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            ret = docBuilder.parse(filePath);
            ret.getDocumentElement().normalize();
        }
        catch (Exception e) {
            throw new CTFUtilsException("Can not open XML document", e);
        }
        return ret;
    }

    public static String getFile(String directory, final String startWiths, final String extension) throws CTFUtilsException {
        File dir = new File(directory);
        File[] matches = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(startWiths) && name.endsWith("." + extension);
            }
        });
        if (matches != null && matches.length == 0) {
            throw new CTFUtilsException("A file with extension " + extension + " was not found in: " + directory + ".", null);
        }
        if (matches != null && matches.length > 1) {
            throw new CTFUtilsException("Multiples files with partial name: " + startWiths + " and extension " + extension + " found in path " + directory, null);
        }
        if (matches == null) {
            throw new CTFUtilsException("A file with extension " + extension + " was not found in: " + directory + ". (Null matches)", null);
        }
        return matches[0].getName();
    }

    public static String getFileEndingWith(String directory, final String endsWith, final String extension) throws CTFUtilsException {
        File dir = new File(directory);
        File[] matches = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(endsWith + "." + extension);
            }
        });
        if (matches != null && matches.length == 0) {
            throw new CTFUtilsException("A file with extension " + extension + " was not found in: " + directory + ".", null);
        }
        if (matches != null && matches.length > 1) {
            throw new CTFUtilsException("Multiples files with partial name: " + endsWith + " and extension " + extension + " found in path " + directory, null);
        }
        if (matches == null) {
            throw new CTFUtilsException("A file with extension " + extension + " was not found in: " + directory + ". (Null matches)", null);
        }
        return matches[0].getName();
    }

    public static String getFileFullName(String directory, final String fullName) throws CTFUtilsException {
        File dir = new File(directory);
        File[] matches = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals(fullName);
            }
        });
        if (matches != null && matches.length == 0) {
            throw new CTFUtilsException("A file " + fullName + " was not found in: " + directory + ".", null);
        }
        if (matches == null) {
            throw new CTFUtilsException("A file " + fullName + " was not found in: " + directory + ". (Null matches)", null);
        }
        return matches[0].getName();
    }

    public static File[] getFilesStartingWith(String directory, final String startingWith, final String extension) throws CTFUtilsException {
        File dir = new File(directory);
        File[] matches = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(startingWith) && name.endsWith("." + extension);
            }
        });
        if (matches != null && matches.length == 0) {
            throw new CTFUtilsException("A file(s) starting with " + startingWith + " was not found in: " + directory + ".", null);
        }
        if (matches == null) {
            throw new CTFUtilsException("A file(s) starting with " + startingWith + " was not found in: " + directory + ". (Null matches)", null);
        }
        return matches;
    }

    public static void zipDirectory(File directory, File destZipFile) throws CTFUtilsException {
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destZipFile)));){
            CTFFileUtils.addFiles(directory, "", out);
        }
        catch (IOException e) {
            throw new CTFUtilsException("File not found: " + destZipFile, e);
        }
    }

    private static void addFiles(File baseFile, String zipEntryPath, ZipOutputStream out) throws CTFUtilsException {
        String[] files;
        for (String filePath : files = baseFile.list()) {
            File file = new File(baseFile, filePath);
            String entryName = CTFFileUtils.formEntryName(zipEntryPath, filePath);
            if (file.isDirectory()) {
                try {
                    out.putNextEntry(new ZipEntry(entryName + "/"));
                }
                catch (IOException e) {
                    throw new CTFUtilsException("Can not add files to ZIP file", e);
                }
                CTFFileUtils.addFiles(file, entryName, out);
                continue;
            }
            try {
                CTFFileUtils.writeFileToZip(out, entryName, file);
            }
            catch (FileNotFoundException e) {
                throw new CTFUtilsException("File not found " + file, e);
            }
            catch (IOException e) {
                throw new CTFUtilsException("Can not write files to ZIP file", e);
            }
        }
    }

    private static String formEntryName(@NotNull String zipEntryPath, @NotNull String filePath) {
        if (StringUtils.isNotBlank((String)zipEntryPath)) {
            return zipEntryPath + "/" + filePath;
        }
        return filePath;
    }

    private static void writeFileToZip(ZipOutputStream out, String entryName, File file) throws IOException {
        byte[] data = new byte[2048];
        try (BufferedInputStream origin = new BufferedInputStream(new FileInputStream(file), 2048);){
            int count;
            ZipEntry entry = new ZipEntry(entryName);
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                out.write(data, 0, count);
            }
        }
    }
}

