/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.platform;

import org.jetbrains.annotations.NotNull;
import org.mule.tools.devkit.ctf.configuration.ConfigurationManager;
import org.mule.tools.devkit.ctf.configuration.DeploymentProfiles;
import org.mule.tools.devkit.ctf.configuration.TestingProperties;
import org.mule.tools.devkit.ctf.exceptions.PlatformManagerException;
import org.mule.tools.devkit.ctf.platform.AbstractPlatformManager;
import org.mule.tools.devkit.ctf.platform.CloudHubPlatformManager;
import org.mule.tools.devkit.ctf.platform.DockerPlatformManager;
import org.mule.tools.devkit.ctf.platform.EmbeddedPlatformManager;
import org.mule.tools.devkit.ctf.platform.LocalPlatformImplementation;
import org.mule.tools.devkit.ctf.platform.PlatformManager;

public final class PlatformManagerFactory {
    private PlatformManagerFactory() {
    }

    public static PlatformManager getLifecycleManager(@NotNull ConfigurationManager configManager) {
        if (configManager == null) {
            throw new PlatformManagerException("Configuration manager can not be null", null);
        }
        String deploymentProfile = configManager.getProperties().getProperty(TestingProperties.DEPLOYMENTPROFILE);
        if (deploymentProfile == null) {
            throw new PlatformManagerException("Configuration Manager does not define a Deployment Profile", null);
        }
        AbstractPlatformManager ret = deploymentProfile.equals(DeploymentProfiles.embedded.toString()) ? new EmbeddedPlatformManager(configManager) : (deploymentProfile.equals(DeploymentProfiles.local.toString()) ? new LocalPlatformImplementation(configManager) : (deploymentProfile.equals(DeploymentProfiles.cloudhub.toString()) ? new CloudHubPlatformManager(configManager) : (deploymentProfile.equals(DeploymentProfiles.docker.toString()) ? new DockerPlatformManager(configManager) : null)));
        return ret;
    }
}

