/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.packager;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.mule.tools.devkit.ctf.configuration.ConfigurationManager;
import org.mule.tools.devkit.ctf.exceptions.CTFUtilsException;
import org.mule.tools.devkit.ctf.exceptions.ConfigurationLoadingFailedException;
import org.mule.tools.devkit.ctf.exceptions.WrongPomVersionRuntimeException;
import org.mule.tools.devkit.ctf.flows.MuleFlowsGenerator;
import org.mule.tools.devkit.ctf.utils.CTFFileUtils;
import org.mule.tools.devkit.ctf.utils.MavenUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class PackagerUtils {
    private PackagerUtils() {
    }

    public static String getArtifactID(@NotNull String connectorPath) throws CTFUtilsException {
        String pomXmlFile = connectorPath + "/pom.xml";
        String ret = "";
        Document xmlDoc = null;
        xmlDoc = CTFFileUtils.openXML(pomXmlFile);
        Node project = xmlDoc.getElementsByTagName("project").item(0);
        NodeList nodes = project.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node flow = nodes.item(i);
            if (!flow.getNodeName().equals("artifactId")) continue;
            ret = flow.getTextContent();
        }
        return ret;
    }

    public static String getConnectorTestingFrameworkVersionFromDependencyTree(@NotNull String m2Home, @NotNull String connectorPath, @NotNull String functionalTestingFolder, @NotNull ConfigurationManager configManager) throws ConfigurationLoadingFailedException {
        if (m2Home == null || connectorPath == null || functionalTestingFolder == null || configManager == null) {
            throw new ConfigurationLoadingFailedException("Can not run dependency tree. Null arguments", null);
        }
        String outputPath = functionalTestingFolder + "/dependencyOutput.txt";
        List<String> goals = Arrays.asList("dependency:tree -Dincludes=org.mule.tools.devkit:connector-testing-framework:jar", "--log-file " + outputPath);
        MuleFlowsGenerator.mavenRunnerInvoker(connectorPath, goals, m2Home, null, configManager);
        return PackagerUtils.parseDependencyFile(outputPath);
    }

    private static String parseDependencyFile(@NotNull String outputPath) throws ConfigurationLoadingFailedException {
        String ret = null;
        File dependencyFile = new File(outputPath);
        try {
            List<String> lines = Files.readAllLines(Paths.get(dependencyFile.toURI()), Charset.defaultCharset());
            for (String line : lines) {
                if (line.contains("org.mule.tools.devkit:connector-testing-framework:jar:")) {
                    String substring = line.substring(line.indexOf(":") + 1);
                    String version = substring.substring(substring.indexOf(":") + 5);
                    if (version.contains(":")) {
                        version = version.substring(0, version.indexOf(":"));
                    }
                    ret = version;
                    continue;
                }
                if (!line.contains("BUILD FAILURE")) continue;
                throw new ConfigurationLoadingFailedException(lines.toString(), null);
            }
        }
        catch (IOException e) {
            throw new ConfigurationLoadingFailedException("Can not parse dependency output file", e);
        }
        return ret;
    }

    public static String getConnectorDevkitVersion(@NotNull String connectorPath) throws WrongPomVersionRuntimeException {
        String pomXmlFile = connectorPath + "/pom.xml";
        String ret = "";
        Document xmlDoc = null;
        try {
            xmlDoc = CTFFileUtils.openXML(pomXmlFile);
        }
        catch (CTFUtilsException e) {
            throw new WrongPomVersionRuntimeException("Can not determine version of the DevkitParent in your pom.xml.", e);
        }
        NodeList parents = xmlDoc.getElementsByTagName("parent");
        for (int i = 0; i < parents.getLength(); ++i) {
            Node parent = parents.item(i);
            if (!PackagerUtils.parentNode(parent)) continue;
            ret = PackagerUtils.getTextFromNode(parent, "version");
            if (ret == null) {
                throw new WrongPomVersionRuntimeException("Can not determine version of the DevkitParent in your pom.xml.", null);
            }
            return ret;
        }
        throw new WrongPomVersionRuntimeException("No nodes named Parent. Can not determine version of the DevkitParent in your pom.xml.", null);
    }

    public static String getConnectorDevkitCategory(@NotNull String connectorPath) {
        String pomXmlFile = connectorPath + "/pom.xml";
        String ret = "";
        Document xmlDoc = null;
        try {
            xmlDoc = CTFFileUtils.openXML(pomXmlFile);
        }
        catch (CTFUtilsException e) {
            return null;
        }
        NodeList properties = xmlDoc.getElementsByTagName("properties");
        Node property = properties.item(0);
        ret = property == null ? null : PackagerUtils.getTextFromNode(property, "category");
        return ret;
    }

    private static String getTextFromNode(Node n, String key) {
        NodeList childNodes = n.getChildNodes();
        for (int j = 0; j < childNodes.getLength(); ++j) {
            Node node = childNodes.item(j);
            if (node.getNodeName() == null || !node.getNodeName().equals(key)) continue;
            String version = node.getTextContent();
            if (version.contains("$") || version.contains("{")) {
                return null;
            }
            return version;
        }
        return null;
    }

    private static boolean parentNode(Node n) {
        NodeList childNodes = n.getChildNodes();
        for (int j = 0; j < childNodes.getLength(); ++j) {
            Node node = childNodes.item(j);
            if (node.getTextContent() == null || !node.getTextContent().equals("mule-devkit-parent")) continue;
            return true;
        }
        return false;
    }

    public static boolean isConnectorVersionRightForMuleVersion(@NotNull String connectorVersion, @NotNull String muleVersion) {
        if (connectorVersion == null || muleVersion == null) {
            return true;
        }
        return MavenUtils.compareVersionNumbers(connectorVersion, muleVersion) <= 0;
    }

    public static boolean isRequiredMuleRuntimeRightForMuleVersion(@NotNull String requiredMuleRuntime, @NotNull String muleVersion) {
        return MavenUtils.compareVersionNumbers(muleVersion, requiredMuleRuntime) >= 0;
    }
}

