/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.mockup;

import org.apache.log4j.Logger;
import org.mule.tools.devkit.ctf.configuration.ConfigurationManager;
import org.mule.tools.devkit.ctf.configuration.DeploymentProfiles;
import org.mule.tools.devkit.ctf.configuration.TestingProperties;
import org.mule.tools.devkit.ctf.exceptions.ConfigurationLoadingFailedException;
import org.mule.tools.devkit.ctf.exceptions.ConfigurationPropertyException;
import org.mule.tools.devkit.ctf.mockup.ConnectorDispatcher;
import org.mule.tools.devkit.ctf.mockup.ConnectorMockup;
import org.mule.tools.devkit.ctf.mockup.EmbeddedConnectorMockup;
import org.mule.tools.devkit.ctf.mockup.LocalConnectorMockup;
import org.mule.tools.devkit.ctf.platform.AbstractPlatformManager;
import org.mule.tools.devkit.ctf.platform.PlatformManager;
import org.mule.tools.devkit.ctf.platform.PlatformManagerFactory;

public final class ConnectorTestContext<T> {
    private static final Logger logger = Logger.getLogger(ConnectorTestContext.class);
    private ConfigurationManager configManager;
    private AbstractPlatformManager platformManager;
    private ConnectorDispatcher<T> connectorDispatcher;
    private static ConnectorTestContext<?> instance;
    private boolean suiteInitialization;

    public boolean initializedBySuite() {
        return this.suiteInitialization;
    }

    @Deprecated
    public static <J> ConnectorTestContext<J> getInstance(Class<J> connectorClass) {
        return ConnectorTestContext.getInstance();
    }

    public static <J> ConnectorTestContext<J> getInstance() {
        if (instance == null || instance.getPlatformManager().getCurrentState().equals((Object)PlatformManager.PlatformStates.STOPPED)) {
            throw new RuntimeException("Connector Test Context not initialized. Please use initialize() first.");
        }
        return instance;
    }

    public static synchronized <T> void initialize(Class<T> connectorClass) {
        ConnectorTestContext.initialize(connectorClass, true);
    }

    public static synchronized <T> void initialize(Class<T> connectorClass, boolean suiteInitialization) {
        if (instance != null && suiteInitialization) {
            throw new RuntimeException("Connector Test Context has already been initialized.");
        }
        if (instance != null) {
            logger.debug((Object)"Ignoring test Initialize call. Context has already been initialized by the test suite.");
            return;
        }
        instance = new ConnectorTestContext<T>(connectorClass, suiteInitialization);
        PlatformManager manager = instance.getPlatformManager();
        manager.initialize();
        logger.info((Object)"Starting CTF Execution");
    }

    public static synchronized <T> void shutDown() {
        if (instance == null) {
            throw new RuntimeException("Connector Test Context not initialized. Please use initialise() first.");
        }
        PlatformManager manager = instance.getPlatformManager();
        manager.shutdown();
        instance = null;
        logger.info((Object)"Shutting Down CTF Execution");
    }

    public static synchronized <T> void shutDown(boolean fromSuite) {
        if (instance == null) {
            throw new RuntimeException("Connector Test Context not initialized. Please use initialise() first.");
        }
        if (!instance.initializedBySuite() && !fromSuite) {
            logger.debug((Object)"Shutting down test.");
            ConnectorTestContext.shutDown();
            return;
        }
        if (instance.initializedBySuite() && fromSuite) {
            logger.debug((Object)"Shutting down suite. Please use shutDown() instead of shutDown(true) when shutting down from the test suite.");
            ConnectorTestContext.shutDown();
            return;
        }
        if (instance.initializedBySuite()) {
            logger.debug((Object)"Ignoring test shut down call. Context has been initialized from the test suite.");
            return;
        }
    }

    public PlatformManager getPlatformManager() {
        return this.platformManager;
    }

    public ConnectorDispatcher<T> getConnectorDispatcher() {
        return this.connectorDispatcher;
    }

    private ConnectorTestContext(Class<T> connectorClass, boolean suiteInitialization) {
        try {
            this.suiteInitialization = suiteInitialization;
            String connectorPath = ConnectorMockup.getConnectorPath();
            this.configManager = new ConfigurationManager(connectorPath);
            logger.setLevel(this.configManager.getLoggingLevel());
            this.platformManager = (AbstractPlatformManager)PlatformManagerFactory.getLifecycleManager(this.configManager);
            this.connectorDispatcher = this.createDispatcher(connectorClass);
        }
        catch (ConfigurationLoadingFailedException e) {
            throw new RuntimeException(e);
        }
        catch (ConfigurationPropertyException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ConnectorDispatcher<T> createDispatcher(Class<T> connectorClass) throws Exception {
        ConnectorMockup ret;
        String deploymentProfile = this.configManager.getProperties().getProperty(TestingProperties.DEPLOYMENTPROFILE);
        if (deploymentProfile == null) {
            throw new ConfigurationPropertyException("No deployment profile set", null);
        }
        if (deploymentProfile.equals(DeploymentProfiles.embedded.toString())) {
            ret = new EmbeddedConnectorMockup<T>(connectorClass, this.configManager, this.platformManager);
        } else if (deploymentProfile.equals(DeploymentProfiles.local.toString()) || deploymentProfile.equals(DeploymentProfiles.cloudhub.toString()) || deploymentProfile.equals(DeploymentProfiles.docker.toString())) {
            ret = new LocalConnectorMockup<T>(connectorClass, this.configManager, this.platformManager);
        } else {
            throw new ConfigurationPropertyException("Deployment profile: " + deploymentProfile + " not implemented. Stand by for updates mate.", null);
        }
        return ret;
    }
}

