/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.junit;

import org.apache.log4j.Logger;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mule.tools.devkit.ctf.configuration.DeploymentProfiles;
import org.mule.tools.devkit.ctf.configuration.util.ConfigurationUtils;
import org.mule.tools.devkit.ctf.junit.MinMuleRuntime;
import org.mule.tools.devkit.ctf.packager.PackagerUtils;

public class MinMuleRuntimeTestRule
implements TestRule {
    private static final Logger logger = Logger.getLogger(MinMuleRuntimeTestRule.class);

    public Statement apply(Statement statement, Description description) {
        MinMuleRuntime requiredMuleRuntimeAnnotation = (MinMuleRuntime)description.getAnnotation(MinMuleRuntime.class);
        if (requiredMuleRuntimeAnnotation == null) {
            return statement;
        }
        boolean embedded = DeploymentProfiles.embedded.toString().equals(System.getProperty("deploymentprofile"));
        if (embedded || System.getProperty("deploymentprofile") == null) {
            return statement;
        }
        String minMuleVersion = requiredMuleRuntimeAnnotation.minversion();
        if (minMuleVersion == null || minMuleVersion.equals("")) {
            logger.trace((Object)"Test annotated with @RequiredMuleRuntime but missing runtime value as (runtime=x.y.z). Executing test", null);
            return statement;
        }
        String muleVersion = ConfigurationUtils.autoDetectMuleVersion(System.getProperty("muledirectory"));
        if (muleVersion == null && System.getProperty("muleversion") != null) {
            muleVersion = System.getProperty("muleversion");
        }
        if (PackagerUtils.isRequiredMuleRuntimeRightForMuleVersion(minMuleVersion, muleVersion)) {
            return statement;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
            }
        };
    }
}

