/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.junit;

import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.mule.tools.devkit.ctf.junit.MetaDataTestRule;
import org.mule.tools.devkit.ctf.junit.MinMuleRuntimeTestRule;
import org.mule.tools.devkit.ctf.junit.RunOnlyOnTestRule;
import org.mule.tools.devkit.ctf.mockup.ConnectorDispatcher;
import org.mule.tools.devkit.ctf.mockup.ConnectorTestContext;

public abstract class AbstractTestCase<T> {
    private Class<T> connectorClass;
    private T connector;
    private ConnectorDispatcher<T> dispatcher;
    @Rule
    public TestRule metadataRule = new MetaDataTestRule();
    @Rule
    public TestRule minMuleRuntime = new MinMuleRuntimeTestRule();
    @Rule
    public TestRule runOnlyOnRule = new RunOnlyOnTestRule();

    public AbstractTestCase(Class<T> connectorClass) {
        this.connectorClass = connectorClass;
    }

    @Deprecated
    public AbstractTestCase() {
    }

    @Deprecated
    public void setConnectorClass(Class<T> connectorClass) {
        this.connectorClass = connectorClass;
    }

    protected T getConnector() {
        return this.connector;
    }

    protected ConnectorDispatcher<T> getDispatcher() {
        return this.dispatcher;
    }

    @Before
    public void init() throws Exception {
        if (this.connectorClass == null) {
            throw new RuntimeException("ConnectorClass not defined. Please use super(connectorClass.class) in your Parent Constructor.");
        }
        ConnectorTestContext.initialize(this.connectorClass, false);
        ConnectorTestContext context = ConnectorTestContext.getInstance();
        this.dispatcher = context.getConnectorDispatcher();
        this.connector = this.dispatcher.createMockup();
    }

    @After
    public void shutdown() throws Exception {
        ConnectorTestContext.shutDown(false);
    }
}

