/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.junit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.mule.common.Result;
import org.mule.common.metadata.AbstractStructuredMetaDataModel;
import org.mule.common.metadata.DefaultDefinedMapMetaDataModel;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataField;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.MetaDataProperties;
import org.mule.common.metadata.MetaDataPropertyScope;
import org.mule.common.metadata.UnknownMetaDataModel;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.field.property.MetaDataFieldProperty;
import org.mule.common.metadata.field.property.ValidStringValuesFieldProperty;
import org.mule.tools.devkit.ctf.junit.AbstractTestCase;
import org.mule.tools.devkit.ctf.junit.MetaDataTest;
import org.mule.tools.devkit.ctf.mockup.ConnectorDispatcher;
import org.skyscreamer.jsonassert.JSONAssert;

public abstract class AbstractMetaDataTestCases<T>
extends AbstractTestCase<T> {
    private static final Logger logger = Logger.getLogger(AbstractMetaDataTestCases.class);
    private static final Comparator<MetaDataField> FIELD_COMPARATOR = new Comparator<MetaDataField>(){

        @Override
        public int compare(MetaDataField o1, MetaDataField o2) {
            return ObjectUtils.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
        }
    };
    private final List<String> metadataIds;
    private final Class<?> categoryClass;

    public AbstractMetaDataTestCases(@NotNull List<String> metadataIds, @NotNull Class<?> categoryClass, Class<T> connectorClass) {
        super(connectorClass);
        this.metadataIds = metadataIds;
        this.categoryClass = categoryClass;
    }

    @MetaDataTest
    @Test
    public void verify() throws IOException, JSONException {
        ConnectorDispatcher dispatcher = this.getDispatcher();
        Result<List<MetaDataKey>> metaDataKeysResult = dispatcher.fetchMetaDataKeys(this.categoryClass);
        Assert.assertTrue((String)"Unexpected error loading metadata keys", (Result.Status.SUCCESS == metaDataKeysResult.getStatus() ? 1 : 0) != 0);
        HashMap<String, MetaDataKey> keyById = new HashMap<String, MetaDataKey>();
        List metaDataKeys = (List)metaDataKeysResult.get();
        for (MetaDataKey metaDataKey : metaDataKeys) {
            keyById.put(metaDataKey.getCategory() + ":" + metaDataKey.getId(), metaDataKey);
            logger.debug((Object)("Datasense key loaded --> { " + metaDataKey.getId() + " }"));
        }
        File tempDir = this.createTmpDir();
        String basePath = "datasense/" + this.categoryClass.getSimpleName().toLowerCase();
        for (String metaDataKeyId : this.metadataIds) {
            MetaDataKey metaDataKey = (MetaDataKey)keyById.get(this.categoryClass.getSimpleName() + ":" + metaDataKeyId);
            Assert.assertNotNull((String)("Could not find metadataId " + metaDataKeyId), (Object)metaDataKey);
            Result<MetaData> metaDataResult = dispatcher.fetchMetaData(metaDataKey);
            this.serialize((MetaData)metaDataResult.get(), metaDataKeyId, tempDir, basePath);
        }
    }

    private void serialize(MetaData metaData, String metaDataKeyId, File tempDir, String path) throws JSONException {
        MetadataSerializer serializer = new MetadataSerializer(metaData);
        JSONObject actualResult = serializer.toJson();
        boolean isFileMissing = this.compareOrCreate(tempDir, path, metaDataKeyId, actualResult);
        Assert.assertFalse((String)"One or more records file could not be found. Review the logs for more information", (boolean)isFileMissing);
    }

    private boolean compareOrCreate(@NotNull File tempDir, @NotNull String outputPath, @NotNull String metaDataKeyId, @NotNull JSONObject actualResult) {
        String goldenFile = outputPath + "/" + metaDataKeyId + ".json";
        URL resource = this.getClass().getResource("/" + goldenFile);
        boolean isFileMissing = false;
        if (resource == null) {
            File outputFile = new File(tempDir, goldenFile);
            outputFile.getParentFile().mkdirs();
            logger.error((Object)("Missing test record file for key: " + metaDataKeyId + ". Copy the generated files inside test/resources/" + outputPath + ". Generated file: " + outputFile));
            try {
                IOUtils.write((String)actualResult.toString(), (OutputStream)new FileOutputStream(outputFile));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write file " + outputFile, e);
            }
            isFileMissing = true;
        } else {
            try {
                String data = IOUtils.toString((Reader)new InputStreamReader(resource.openStream(), "UTF-8"));
                JSONObject expectedResult = new JSONObject(data);
                JSONAssert.assertEquals((JSONObject)expectedResult, (JSONObject)actualResult, (boolean)true);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read from file " + goldenFile, e);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unable to transform response to JSONObject", e);
            }
        }
        return isFileMissing;
    }

    @NotNull
    private File createTmpDir() throws IOException {
        File tempFile = File.createTempFile("data", "out");
        tempFile.delete();
        File tempDir = new File(tempFile.getCanonicalPath(), ".dir");
        tempDir.mkdirs();
        return tempDir;
    }

    private static class MetadataSerializer {
        private final MetaData metadata;

        public MetadataSerializer(@NotNull MetaData metadata) {
            this.metadata = metadata;
        }

        public JSONObject toJson() throws JSONException {
            JsonTransformer transformer = new JsonTransformer();
            return transformer.generate(this.metadata);
        }

        private static class JsonTransformer {
            private JsonTransformer() {
            }

            public JSONObject generate(@NotNull MetaData metaData) throws JSONException {
                MetaDataPropertyScope[] values;
                JSONObject result = new JSONObject();
                for (MetaDataPropertyScope type : values = MetaDataPropertyScope.values()) {
                    MetaDataProperties properties = metaData.getProperties(type);
                    if (properties.getFields().isEmpty()) continue;
                    result.put(type.name().toLowerCase(), (Object)this.generate(properties));
                }
                MetaDataModel payload = metaData.getPayload();
                result.put("payload-type", (Object)payload.getDataType().name().toLowerCase());
                result.put("payload", (Object)this.generate(payload));
                return result;
            }

            @NotNull
            public JSONObject generate(@NotNull MetaDataProperties properties) throws JSONException {
                JSONObject result = new JSONObject();
                Set fields = properties.getFields();
                for (MetaDataField field : fields) {
                    result.put(field.getName(), (Collection)field.getProperties());
                }
                return result;
            }

            @NotNull
            public JSONObject generate(@NotNull MetaDataModel model) throws JSONException {
                if (model instanceof UnknownMetaDataModel) {
                    return new JSONObject();
                }
                if (model instanceof AbstractStructuredMetaDataModel) {
                    return this.generate((AbstractStructuredMetaDataModel)model);
                }
                throw new RuntimeException("Unsupported metadata model class: " + model.getClass());
            }

            @NotNull
            public JSONObject generate(@NotNull AbstractStructuredMetaDataModel model) throws JSONException {
                JSONObject result = new JSONObject();
                ArrayList fields = new ArrayList();
                fields.addAll(model.getFields());
                Collections.sort(fields, FIELD_COMPARATOR);
                for (MetaDataField field : fields) {
                    String fieldDesc;
                    String typeStr;
                    String key = Objects.toString(field.getName(), "UNDEFINED");
                    MetaDataModel dataModel = field.getMetaDataModel();
                    if (dataModel instanceof DefaultListMetaDataModel) {
                        result.put(key, (Object)this.generate((DefaultListMetaDataModel)dataModel));
                        continue;
                    }
                    if (dataModel instanceof DefaultDefinedMapMetaDataModel) {
                        result.put(key, (Object)this.generate((AbstractStructuredMetaDataModel)((DefaultDefinedMapMetaDataModel)dataModel)));
                        continue;
                    }
                    DataType dataType = dataModel.getDataType();
                    switch (dataType) {
                        case POJO: 
                        case ENUM: {
                            typeStr = dataType.getDefaultImplementationClass();
                            break;
                        }
                        default: {
                            typeStr = dataType.name().toLowerCase();
                        }
                    }
                    JSONObject props = this.generate(field.getProperties());
                    if (props.length() == 0) {
                        fieldDesc = typeStr;
                    } else {
                        JSONObject value = new JSONObject();
                        value.put("type", (Object)typeStr);
                        value.put("props", (Object)props);
                        fieldDesc = value;
                    }
                    result.put(key, (Object)fieldDesc);
                }
                return result;
            }

            @NotNull
            public JSONArray generate(@NotNull DefaultListMetaDataModel model) throws JSONException {
                MetaDataModel listDataModel = model.getElementModel();
                JSONArray result = new JSONArray();
                DataType dataType = listDataModel.getDataType();
                switch (dataType) {
                    case POJO: {
                        DefaultPojoMetaDataModel pojo = (DefaultPojoMetaDataModel)listDataModel;
                        JSONObject json = this.generate((AbstractStructuredMetaDataModel)pojo);
                        result.put((Object)json);
                        break;
                    }
                    case MAP: {
                        DefaultDefinedMapMetaDataModel map = (DefaultDefinedMapMetaDataModel)listDataModel;
                        JSONObject json = this.generate((AbstractStructuredMetaDataModel)map);
                        result.put((Object)json);
                        break;
                    }
                    case ENUM: {
                        result.put((Object)dataType.getDefaultImplementationClass());
                        break;
                    }
                    default: {
                        result.put((Object)dataType.name().toLowerCase());
                    }
                }
                return result;
            }

            @NotNull
            private JSONObject generate(@NotNull List<MetaDataFieldProperty> properties) throws JSONException {
                JSONObject result = new JSONObject();
                for (MetaDataFieldProperty property : properties) {
                    if (!(property instanceof ValidStringValuesFieldProperty)) continue;
                    ValidStringValuesFieldProperty validProps = (ValidStringValuesFieldProperty)property;
                    result.put("valid-values", (Collection)validProps.getValidStrings());
                }
                return result;
            }
        }
    }
}

