/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.handlers;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import org.mule.common.Result;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.tools.devkit.ctf.configuration.ConfigurationManager;
import org.mule.tools.devkit.ctf.configuration.TestingProperties;
import org.mule.tools.devkit.ctf.exceptions.MethodExecutionFailedException;
import org.mule.tools.devkit.ctf.exceptions.MuleManagerException;
import org.mule.tools.devkit.ctf.exceptions.SerializationFailedException;
import org.mule.tools.devkit.ctf.flows.MethodDescriptor;
import org.mule.tools.devkit.ctf.flows.RemoteMuleFlowsGenerator;
import org.mule.tools.devkit.ctf.handlers.MethodExecutionHandler;
import org.mule.tools.devkit.ctf.packager.ApplicationPackager;
import org.mule.tools.devkit.ctf.platform.AbstractPlatformManager;
import org.mule.tools.devkit.ctf.serialization.ObjectSerializerFactory;
import org.mule.tools.devkit.ctf.serialization.ObjectsSerializer;
import org.mule.tools.devkit.ctf.serialization.RPCSerializationUtils;

public final class RemoteMethodExecutionHandler<T>
extends MethodExecutionHandler<T> {
    private Map<String, WebResource> webResources = new HashMap<String, WebResource>();
    private Client jerseyClient;
    private ObjectsSerializer serializer;
    private AbstractPlatformManager lifecycleManager;
    private ApplicationPackager applicationPackager;

    public RemoteMethodExecutionHandler(Class<T> connectorClass, String connectorPath, ConfigurationManager configManager, AbstractPlatformManager lifecycleManager) {
        super(connectorClass, connectorPath, configManager);
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        this.jerseyClient = Client.create((ClientConfig)clientConfig);
        this.serializer = ObjectSerializerFactory.getInstance().getDefaultSerializer();
        this.lifecycleManager = lifecycleManager;
    }

    @Override
    public Object executeMethod(Method method, Object[] args) throws Throwable {
        Object ret;
        try {
            WebResource methodWebResource = this.getWebResource(method.getName());
            String methodName = RPCSerializationUtils.getUnCamel((String)method.getName());
            MethodDescriptor md = this.muleFlowGenerator.getMethodDescriptor(methodName);
            byte[] payloadToAttach = this.serializer.getSerializedArguments(md.getSignature(), args);
            Object response = methodWebResource.type("application/octet-stream").post(payloadToAttach.getClass(), (Object)payloadToAttach);
            ret = this.serializer.getDeserializedResult(response);
        }
        catch (SerializationFailedException e) {
            throw e;
        }
        catch (Exception e) {
            InvocationTargetException ite;
            Throwable ute;
            Throwable cause = e.getCause();
            if (cause instanceof UndeclaredThrowableException && (ute = ((UndeclaredThrowableException)cause).getUndeclaredThrowable()) instanceof InvocationTargetException && (ite = (InvocationTargetException)ute) != null) {
                throw ite.getTargetException();
            }
            if (cause != null) {
                throw cause;
            }
            throw e;
        }
        return ret;
    }

    private WebResource getWebResource(String methodName) throws MuleManagerException {
        String uncamelMethodName = RPCSerializationUtils.getUnCamel((String)methodName);
        WebResource ret = this.webResources.get(uncamelMethodName);
        if (ret == null) {
            String uri = this.lifecycleManager.getMuleManager().getURIforConnector(this.connectorClass.getName());
            ret = this.jerseyClient.resource(uri).path(uncamelMethodName);
            logger.debug((Object)("URI for method: " + uncamelMethodName + " --> " + ret));
            this.webResources.put(uncamelMethodName, ret);
        }
        return ret;
    }

    @Override
    public void onStart() {
        String connectorName = this.connectorClass.getName();
        this.muleFlowGenerator = new RemoteMuleFlowsGenerator(this.lifecycleManager.getMuleManager(), this.configManager, this.connectorClass);
        this.applicationPackager = new ApplicationPackager(this.configManager, this.muleFlowGenerator, this.connectorPath, connectorName);
        try {
            this.applicationPackager.generateMuleApp();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onDeploy() {
        String generatedApp = this.applicationPackager.getPackagedAppPath();
        try {
            this.lifecycleManager.getMuleManager().deployMuleApp(generatedApp, this.connectorClass.getName());
        }
        catch (MuleManagerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onUndeploy() {
    }

    @Override
    public void onStop() {
        this.jerseyClient.destroy();
    }

    @Override
    public Result<List<MetaDataKey>> fetchMetaDataKeys() {
        return (Result)this.executeMetadataRequest("fetchMetaDataKeys", null);
    }

    @Override
    public Map<MetaDataKey, Result<MetaData>> fetchAllMetaData() {
        return (Map)this.executeMetadataRequest("fetchMetaData", null);
    }

    @Override
    public Result<MetaData> fetchMetaData(MetaDataKey key) {
        return (Result)this.executeMetadataRequest("fetchMetaData", key);
    }

    private Object executeMetadataRequest(String metadataWebServiceName, MetaDataKey metaDataKey) {
        Object ret;
        try {
            WebResource methodWebResource = this.getWebResource(metadataWebServiceName);
            String configurationName = this.configManager.getProperties().getProperty(TestingProperties.ACTIVECONFIGURATION);
            Object[] args = metaDataKey == null ? new Object[]{configurationName} : new Object[]{configurationName, metaDataKey};
            ArrayList<String> signature = new ArrayList<String>();
            signature.add("configName");
            if (metaDataKey != null) {
                signature.add("metaDataKey");
            }
            byte[] payloadToAttach = this.serializer.getSerializedArguments(signature, args);
            Object response = methodWebResource.type("application/octet-stream").post(payloadToAttach.getClass(), (Object)payloadToAttach);
            ret = this.serializer.getDeserializedResult(response);
        }
        catch (MuleManagerException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    @Override
    public XMLStreamReader runWSDLOperation(XMLStreamReader input, String param) {
        XMLStreamReader ret = null;
        try {
            Object[] args = new Object[]{param, input};
            WebResource methodWebResource = this.getWebResource("invoke");
            ArrayList<String> signature = new ArrayList<String>();
            signature.add("operation");
            signature.add("__payload_");
            byte[] payloadToAttach = this.serializer.getSerializedArguments(signature, args);
            Object response = methodWebResource.type("application/octet-stream").post(payloadToAttach.getClass(), (Object)payloadToAttach);
            ret = (XMLStreamReader)this.serializer.getDeserializedResult(response);
        }
        catch (MuleManagerException e) {
            throw new MethodExecutionFailedException("Can not run WSDL Operation", e);
        }
        catch (NoSuchMethodException e) {
            throw new MethodExecutionFailedException("Can not run WSDL Operation", e);
        }
        catch (Exception e) {
            throw new MethodExecutionFailedException("Can not run WSDL Operation", e);
        }
        return ret;
    }
}

