/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.handlers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.construct.FlowConstruct;
import org.mule.common.Result;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.construct.Flow;
import org.mule.tck.MuleTestUtils;
import org.mule.tools.devkit.ctf.configuration.ConfigurationManager;
import org.mule.tools.devkit.ctf.configuration.TestingProperties;
import org.mule.tools.devkit.ctf.exceptions.DataSenseException;
import org.mule.tools.devkit.ctf.exceptions.MethodExecutionFailedException;
import org.mule.tools.devkit.ctf.flows.EmbeddedMuleFlowsGenerator;
import org.mule.tools.devkit.ctf.flows.MethodDescriptor;
import org.mule.tools.devkit.ctf.handlers.MethodExecutionHandler;
import org.mule.tools.devkit.ctf.mockup.BaseConnectorTestCase;
import org.mule.tools.devkit.ctf.serialization.RPCSerializationUtils;

public final class EmbeddedMethodExecutionHandler<T>
extends MethodExecutionHandler<T> {
    private MuleContext muleContext;
    private Map<MetaDataKey, Result<MetaData>> metaDataMap;

    public EmbeddedMethodExecutionHandler(Class<T> connectorClass, String connectorPath, ConfigurationManager configManager) {
        super(connectorClass, connectorPath, configManager);
    }

    @Override
    public Object executeMethod(Method method, Object[] args) throws Throwable {
        MuleEvent event;
        String unCamelMethodName = RPCSerializationUtils.getUnCamel((String)method.getName());
        Flow toRun = this.getFlow(unCamelMethodName);
        try {
            MethodDescriptor md = this.muleFlowGenerator.getMethodDescriptor(unCamelMethodName);
            MuleEvent flowArgs = this.processArguments(md, args);
            event = toRun.process(flowArgs);
        }
        catch (Exception e) {
            InvocationTargetException ite;
            Throwable ute;
            Throwable cause = e.getCause();
            if (cause instanceof UndeclaredThrowableException && (ute = ((UndeclaredThrowableException)cause).getUndeclaredThrowable()) instanceof InvocationTargetException && (ite = (InvocationTargetException)ute) != null) {
                throw ite.getTargetException();
            }
            if (cause != null) {
                throw cause;
            }
            throw e;
        }
        return event.getMessage().getPayload();
    }

    private MuleEvent processArguments(MethodDescriptor md, Object[] args) {
        MuleEvent ret;
        List<String> signature = md.getSignature();
        if (signature == null) {
            throw new MethodExecutionFailedException("Method Descriptor is Null. Can not process arguments.", null);
        }
        HashMap<String, Object> flowVars = new HashMap<String, Object>();
        int paramCounter = 0;
        for (Object obj : args) {
            if (obj != null) {
                flowVars.put(signature.get(paramCounter), obj);
            }
            ++paramCounter;
        }
        Object payload = flowVars.get("__payload_");
        if (payload == null) {
            payload = new Object();
        }
        Flow f = new Flow("testFlow", this.muleContext);
        try {
            ret = MuleTestUtils.getTestEvent(payload, (FlowConstruct)f, (MessageExchangePattern)MessageExchangePattern.REQUEST_RESPONSE, (MuleContext)this.muleContext);
        }
        catch (Exception e) {
            throw new MethodExecutionFailedException("Can not process Mule Event", e);
        }
        for (String flowVar : flowVars.keySet()) {
            ret.setFlowVariable(flowVar, flowVars.get(flowVar));
        }
        return ret;
    }

    private Flow getFlow(String methodName) {
        return (Flow)this.muleContext.getRegistry().lookupFlowConstruct(methodName);
    }

    @Override
    public void onStart() {
        try {
            this.muleFlowGenerator = new EmbeddedMuleFlowsGenerator(this.configManager, this.connectorClass);
            String connectorName = this.connectorClass.getName();
            String functionalTestingPath = this.connectorPath + "/target/functionalTesting";
            String flowsFile = this.muleFlowGenerator.generateFlows(connectorName, this.connectorPath, functionalTestingPath);
            BaseConnectorTestCase connectorTestCase = new BaseConnectorTestCase(flowsFile);
            this.muleContext = connectorTestCase.getMuleContext();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onDeploy() {
    }

    @Override
    public void onUndeploy() {
    }

    @Override
    public void onStop() {
        if (this.muleContext != null) {
            this.muleContext.dispose();
        }
    }

    @Override
    public Result<List<MetaDataKey>> fetchMetaDataKeys() {
        ConnectorMetaDataEnabled connectorMetaDataEnabled;
        try {
            connectorMetaDataEnabled = this.getConnectorMetaDataEnabled();
        }
        catch (DataSenseException e) {
            throw new RuntimeException(e);
        }
        return connectorMetaDataEnabled.getMetaDataKeys();
    }

    @Override
    public Map<MetaDataKey, Result<MetaData>> fetchAllMetaData() {
        ConnectorMetaDataEnabled connectorMetaDataEnabled;
        if (this.metaDataMap != null) {
            return this.metaDataMap;
        }
        try {
            connectorMetaDataEnabled = this.getConnectorMetaDataEnabled();
        }
        catch (DataSenseException e) {
            throw new RuntimeException(e);
        }
        this.metaDataMap = new HashMap<MetaDataKey, Result<MetaData>>();
        List keys = (List)this.fetchMetaDataKeys().get();
        for (MetaDataKey key : keys) {
            Result metaData = connectorMetaDataEnabled.getMetaData(key);
            this.metaDataMap.put(key, (Result<MetaData>)metaData);
        }
        return this.metaDataMap;
    }

    private ConnectorMetaDataEnabled getConnectorMetaDataEnabled() throws DataSenseException {
        String configurationName = this.configManager.getProperties().getProperty(TestingProperties.ACTIVECONFIGURATION);
        if (configurationName == null) {
            throw new DataSenseException("No active configuration set", null);
        }
        ConnectorMetaDataEnabled connectorMetaDataEnabled = (ConnectorMetaDataEnabled)this.muleContext.getRegistry().lookupObject(configurationName);
        if (connectorMetaDataEnabled == null) {
            throw new DataSenseException("No ConnectorMetadataEnabled Object with name: " + configurationName + " within Mule Context.", null);
        }
        return connectorMetaDataEnabled;
    }

    @Override
    public XMLStreamReader runWSDLOperation(XMLStreamReader input, String param) {
        MuleEvent event;
        Flow toRun = this.getFlow("invoke");
        try {
            Flow f = new Flow("testFlow", this.muleContext);
            MuleEvent flowArgs = MuleTestUtils.getTestEvent((Object)input, (FlowConstruct)f, (MessageExchangePattern)MessageExchangePattern.REQUEST_RESPONSE, (MuleContext)this.muleContext);
            flowArgs.setFlowVariable("operation", (Object)param);
            event = toRun.process(flowArgs);
        }
        catch (Exception e) {
            throw new MethodExecutionFailedException("Can not run Mule flow", e);
        }
        return (XMLStreamReader)event.getMessage().getPayload();
    }

    @Override
    public Result<MetaData> fetchMetaData(MetaDataKey key) {
        ConnectorMetaDataEnabled connectorMetaDataEnabled;
        try {
            connectorMetaDataEnabled = this.getConnectorMetaDataEnabled();
        }
        catch (DataSenseException e) {
            throw new RuntimeException(e);
        }
        return connectorMetaDataEnabled.getMetaData(key);
    }
}

