/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.flows;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.mule.tools.devkit.ctf.exceptions.CTFUtilsException;
import org.mule.tools.devkit.ctf.exceptions.SchemaAnalyserException;
import org.mule.tools.devkit.ctf.utils.CTFFileUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaAnalyser {
    private String xsdFile;
    private String editorsFile;
    private boolean isWSDLEnabled;
    private String keySeparator;
    private boolean multipleServiceDefinitionsDetected;
    private static final Logger logger = Logger.getLogger(SchemaAnalyser.class);

    public boolean isMultipleServiceDefinitionsDetected() {
        return this.multipleServiceDefinitionsDetected;
    }

    public SchemaAnalyser(String xsdFile, String editorsFile) {
        this.xsdFile = xsdFile;
        this.editorsFile = editorsFile;
        this.isWSDLEnabled = false;
        this.multipleServiceDefinitionsDetected = false;
    }

    public SchemaAnalyser(String xsdFile, String editorsFile, Level loggingLevel) {
        this.xsdFile = xsdFile;
        this.editorsFile = editorsFile;
        this.isWSDLEnabled = false;
        this.multipleServiceDefinitionsDetected = false;
        logger.setLevel(loggingLevel);
    }

    public void init() throws SchemaAnalyserException {
        try {
            Document xmlDoc = CTFFileUtils.openXML(this.xsdFile);
            NodeList elements = xmlDoc.getElementsByTagName("xs:element");
            for (int i = 0; i < elements.getLength(); ++i) {
                Node element = elements.item(i);
                if (element.getAttributes().getNamedItem("type") == null || element.getAttributes().getNamedItem("type").getNodeValue() == null || !element.getAttributes().getNamedItem("type").getNodeValue().equals("WSDLInvokeType")) continue;
                this.isWSDLEnabled = true;
                logger.debug((Object)"Connector is WSDL Enabled.");
                break;
            }
            if (this.isWSDLEnabled) {
                this.loadWSDLProperties();
            } else {
                logger.debug((Object)"Connector is not WSDL Enabled.");
            }
        }
        catch (CTFUtilsException | DOMException e) {
            throw new SchemaAnalyserException("Can not initialize Schema Analyser", e);
        }
        logger.debug((Object)"Initialising Schema Analyser complete.");
    }

    private void loadWSDLProperties() throws SchemaAnalyserException {
        try {
            Document xmlDoc = CTFFileUtils.openXML(this.editorsFile);
            NodeList elements = xmlDoc.getElementsByTagName("multi-type-chooser");
            for (int i = 0; i < elements.getLength(); ++i) {
                String captions;
                Node element = elements.item(i);
                if (element.getAttributes().getNamedItem("keySeparator") != null) {
                    this.keySeparator = element.getAttributes().getNamedItem("keySeparator").getNodeValue();
                    logger.debug((Object)("Detected Key Separator: " + this.keySeparator));
                }
                if (element.getAttributes().getNamedItem("captions") == null || !(captions = element.getAttributes().getNamedItem("captions").getNodeValue()).contains(",")) continue;
                this.multipleServiceDefinitionsDetected = true;
                logger.debug((Object)("Detected Multiple-Service-Definitions-based Connector (from detected captions: " + captions + ")"));
            }
        }
        catch (CTFUtilsException | DOMException e) {
            throw new SchemaAnalyserException("Can not load WSDL properties", e);
        }
    }

    public String getKeySeparator() {
        return this.keySeparator;
    }

    public boolean isWSDLConnectorEnabled() {
        return this.isWSDLEnabled;
    }
}

