/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.flows;

import org.mule.tools.devkit.ctf.configuration.ConfigurationManager;
import org.mule.tools.devkit.ctf.deployer.MuleManager;
import org.mule.tools.devkit.ctf.exceptions.ConfigurationLoadingFailedException;
import org.mule.tools.devkit.ctf.exceptions.FlowsGenerationFailedException;
import org.mule.tools.devkit.ctf.exceptions.TestsConfigurationPropertiesFileNotFoundException;
import org.mule.tools.devkit.ctf.flows.AnnotationsParser;
import org.mule.tools.devkit.ctf.flows.MuleFlowsGenerator;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class RemoteMuleFlowsGenerator
extends MuleFlowsGenerator {
    private MuleManager muleManager;

    public RemoteMuleFlowsGenerator(MuleManager muleManager, ConfigurationManager configManager, Class<?> connectorClass) {
        super(configManager, connectorClass);
        this.muleManager = muleManager;
    }

    @Override
    protected void completeHeaders(Document workingDocument) throws FlowsGenerationFailedException {
        NodeList root = workingDocument.getElementsByTagName("mule");
        Element mule = (Element)root.item(0);
        mule.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        mule.setAttribute("xmlns:doc", "http://www.mulesoft.org/schema/mule/documentation");
        mule.setAttribute("xmlns:spring", "http://www.springframework.org/schema/beans");
        mule.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        mule.setAttribute("xmlns:context", "http://www.springframework.org/schema/context");
        mule.setAttribute("xmlns:http", "http://www.mulesoft.org/schema/mule/http");
        mule.setAttribute("xsi:schemaLocation", mule.getAttribute("xsi:schemaLocation").trim() + " http://www.mulesoft.org/schema/mule/http " + "http://www.mulesoft.org/schema/mule/http/current/mule-http.xsd " + "http://www.mulesoft.org/schema/mule/ee/tracking " + "http://www.mulesoft.org/schema/mule/ee/tracking/current/mule-tracking-ee.xsd ");
    }

    @Override
    protected void completeFlows(Document workingDocument, String connectorName) throws TestsConfigurationPropertiesFileNotFoundException, ConfigurationLoadingFailedException {
        NodeList flows = workingDocument.getElementsByTagName("flow");
        for (int i = 0; i < flows.getLength(); ++i) {
            Node flow = flows.item(i);
            NamedNodeMap map = flow.getAttributes();
            String flowName = map.getNamedItem("name").getNodeValue();
            Node processor = flow.getFirstChild();
            Element http = workingDocument.createElement("http:inbound-endpoint");
            http.setAttribute("exchange-pattern", "request-response");
            http.setAttribute("host", "0.0.0.0");
            http.setAttribute("port", this.muleManager.getAssignedPort(connectorName));
            http.setAttribute("doc:name", "HTTPInbound");
            http.setAttribute("path", flow.getAttributes().getNamedItem("name").getNodeValue());
            http.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
            flow.insertBefore(http, processor);
            Element deSerializer = workingDocument.createElement("custom-transformer");
            deSerializer.setAttribute("class", "org.mule.tools.devkit.serializers.DeserializeArgumentsXStream");
            deSerializer.setAttribute("doc:name", "ArgumentsDeserializer");
            deSerializer.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
            flow.insertBefore(deSerializer, processor);
            boolean pagedAnnotationPresent = false;
            boolean wsdlCompleted = this.completeWSDLFlow(workingDocument, processor);
            if (!wsdlCompleted) {
                pagedAnnotationPresent = this.annotationParser.getAnnotations(flowName).contains((Object)AnnotationsParser.ProcessorsAnnotations.PAGED);
            }
            if (pagedAnnotationPresent) {
                Element setVariable = workingDocument.createElement("set-variable");
                setVariable.setAttribute("variableName", "elementList");
                setVariable.setAttribute("value", "#[new java.util.ArrayList()]");
                setVariable.setAttribute("doc:name", "createElementList");
                setVariable.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
                flow.insertBefore(setVariable, processor);
                Element forEach = workingDocument.createElement("foreach");
                forEach.setAttribute("doc:name", "consumeElements");
                forEach.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
                Element expressionComponent = workingDocument.createElement("expression-component");
                expressionComponent.setAttribute("doc:name", "addElements");
                CDATASection cData = workingDocument.createCDATASection("#[flowVars.elementList.add(payload)]");
                expressionComponent.appendChild(cData);
                expressionComponent.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
                forEach.appendChild(expressionComponent);
                flow.appendChild(forEach);
                Element setPayload = workingDocument.createElement("set-payload");
                setPayload.setAttribute("value", "#[flowVars.elementList]");
                setPayload.setAttribute("doc:name", "setListToPayload");
                setPayload.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
                flow.appendChild(setPayload);
            }
            Element serializer = workingDocument.createElement("custom-transformer");
            serializer.setAttribute("class", "org.mule.tools.devkit.serializers.SerializeResultXStream");
            serializer.setAttribute("doc:name", "ResultSerializer");
            serializer.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
            flow.appendChild(serializer);
            Element exceptionStrategy = workingDocument.createElement("catch-exception-strategy");
            exceptionStrategy.setAttribute("doc:name", "exceptionStrategy");
            exceptionStrategy.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
            Element setPayload = workingDocument.createElement("set-payload");
            setPayload.setAttribute("value", "#[exception]");
            setPayload.setAttribute("doc:name", "setPayloadWithException");
            setPayload.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
            exceptionStrategy.appendChild(setPayload);
            Element setProperty = workingDocument.createElement("set-property");
            setProperty.setAttribute("propertyName", "http.status");
            setProperty.setAttribute("value", "200");
            setProperty.setAttribute("doc:name", "setHTTPStatus");
            setProperty.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
            exceptionStrategy.appendChild(setProperty);
            Element component = workingDocument.createElement("component");
            component.setAttribute("class", "org.mule.tools.devkit.serializers.SerializeResultXStream");
            component.setAttribute("doc:name", "SerializeResult/Exception");
            component.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
            exceptionStrategy.appendChild(component);
            flow.appendChild(exceptionStrategy);
        }
        NodeList root = workingDocument.getElementsByTagName("mule");
        Element mule = (Element)root.item(0);
        Element firstFlow = (Element)flows.item(0);
        Element flowKeyResolver = workingDocument.createElement("flow");
        flowKeyResolver.setAttribute("name", "FetchMetaDataKeys");
        Element httpKeyResolver = workingDocument.createElement("http:inbound-endpoint");
        httpKeyResolver.setAttribute("exchange-pattern", "request-response");
        httpKeyResolver.setAttribute("host", "0.0.0.0");
        httpKeyResolver.setAttribute("port", this.muleManager.getAssignedPort(connectorName));
        httpKeyResolver.setAttribute("doc:name", "HTTPInbound");
        httpKeyResolver.setAttribute("path", "fetch-meta-data-keys");
        httpKeyResolver.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        flowKeyResolver.appendChild(httpKeyResolver);
        Element deSerializerKeyResolver = workingDocument.createElement("custom-transformer");
        deSerializerKeyResolver.setAttribute("class", "org.mule.tools.devkit.serializers.DeserializeArgumentsXStream");
        deSerializerKeyResolver.setAttribute("doc:name", "ArgumentsDeserializer");
        deSerializerKeyResolver.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        flowKeyResolver.appendChild(deSerializerKeyResolver);
        Element metaDataKeyResolver = workingDocument.createElement("custom-transformer");
        metaDataKeyResolver.setAttribute("class", "org.mule.tools.devkit.serializers.MetaDataKeyResolver");
        metaDataKeyResolver.setAttribute("doc:name", "MetaDataKeyResolver");
        metaDataKeyResolver.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        flowKeyResolver.appendChild(metaDataKeyResolver);
        Element serializerKeyResolver = workingDocument.createElement("custom-transformer");
        serializerKeyResolver.setAttribute("class", "org.mule.tools.devkit.serializers.SerializeResultXStream");
        serializerKeyResolver.setAttribute("doc:name", "ResultSerializer");
        serializerKeyResolver.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        flowKeyResolver.appendChild(serializerKeyResolver);
        Element exceptionStrategyKeyResolver = workingDocument.createElement("catch-exception-strategy");
        exceptionStrategyKeyResolver.setAttribute("doc:name", "exceptionStrategy");
        exceptionStrategyKeyResolver.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        Element setPayloadKeyResolver = workingDocument.createElement("set-payload");
        setPayloadKeyResolver.setAttribute("value", "#[exception]");
        setPayloadKeyResolver.setAttribute("doc:name", "setPayloadWithException");
        setPayloadKeyResolver.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        exceptionStrategyKeyResolver.appendChild(setPayloadKeyResolver);
        Element setPropertyKeyResolver = workingDocument.createElement("set-property");
        setPropertyKeyResolver.setAttribute("propertyName", "http.status");
        setPropertyKeyResolver.setAttribute("value", "200");
        setPropertyKeyResolver.setAttribute("doc:name", "setHTTPStatus");
        setPropertyKeyResolver.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        exceptionStrategyKeyResolver.appendChild(setPropertyKeyResolver);
        Element componentKeyResolver = workingDocument.createElement("component");
        componentKeyResolver.setAttribute("class", "org.mule.tools.devkit.serializers.SerializeResultXStream");
        componentKeyResolver.setAttribute("doc:name", "SerializeResult/Exception");
        componentKeyResolver.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        exceptionStrategyKeyResolver.appendChild(componentKeyResolver);
        flowKeyResolver.appendChild(exceptionStrategyKeyResolver);
        mule.insertBefore(flowKeyResolver, firstFlow);
        Element flowResolver = workingDocument.createElement("flow");
        flowResolver.setAttribute("name", "FetchMetaData");
        Element httpResolver = workingDocument.createElement("http:inbound-endpoint");
        httpResolver.setAttribute("exchange-pattern", "request-response");
        httpResolver.setAttribute("host", "0.0.0.0");
        httpResolver.setAttribute("port", this.muleManager.getAssignedPort(connectorName));
        httpResolver.setAttribute("doc:name", "HTTPInbound");
        httpResolver.setAttribute("path", "fetch-meta-data");
        httpResolver.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        flowResolver.appendChild(httpResolver);
        Element deSerializerResolver = workingDocument.createElement("custom-transformer");
        deSerializerResolver.setAttribute("class", "org.mule.tools.devkit.serializers.DeserializeArgumentsXStream");
        deSerializerResolver.setAttribute("doc:name", "ArgumentsDeserializer");
        deSerializerResolver.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        flowResolver.appendChild(deSerializerResolver);
        Element metaDataResolver = workingDocument.createElement("custom-transformer");
        metaDataResolver.setAttribute("class", "org.mule.tools.devkit.serializers.MetaDataResolver");
        metaDataResolver.setAttribute("doc:name", "MetaDataResolver");
        metaDataResolver.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        flowResolver.appendChild(metaDataResolver);
        Element serializerResolver = workingDocument.createElement("custom-transformer");
        serializerResolver.setAttribute("class", "org.mule.tools.devkit.serializers.SerializeResultXStream");
        serializerResolver.setAttribute("doc:name", "ResultSerializer");
        serializerResolver.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        flowResolver.appendChild(serializerResolver);
        Element exceptionStrategyResolver = workingDocument.createElement("catch-exception-strategy");
        exceptionStrategyResolver.setAttribute("doc:name", "exceptionStrategy");
        exceptionStrategyResolver.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        Element setPayloadResolver = workingDocument.createElement("set-payload");
        setPayloadResolver.setAttribute("value", "#[exception]");
        setPayloadResolver.setAttribute("doc:name", "setPayloadWithException");
        setPayloadResolver.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        exceptionStrategyResolver.appendChild(setPayloadResolver);
        Element setPropertyResolver = workingDocument.createElement("set-property");
        setPropertyResolver.setAttribute("propertyName", "http.status");
        setPropertyResolver.setAttribute("value", "200");
        setPropertyResolver.setAttribute("doc:name", "setHTTPStatus");
        setPropertyResolver.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        exceptionStrategyResolver.appendChild(setPropertyResolver);
        Element componentResolver = workingDocument.createElement("component");
        componentResolver.setAttribute("class", "org.mule.tools.devkit.serializers.SerializeResultXStream");
        componentResolver.setAttribute("doc:name", "SerializeResult/Exception");
        componentResolver.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        exceptionStrategyResolver.appendChild(componentResolver);
        flowResolver.appendChild(exceptionStrategyResolver);
        mule.insertBefore(flowResolver, firstFlow);
    }

    @Override
    protected boolean resourcesAvailable(String connectorPath) {
        return this.isXSDAvailable(connectorPath) && this.isZIPAvailable(connectorPath) && this.isXMLAvailable(connectorPath);
    }
}

