/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.flows;

import org.mule.tools.devkit.ctf.configuration.ConfigurationManager;
import org.mule.tools.devkit.ctf.exceptions.ConfigurationLoadingFailedException;
import org.mule.tools.devkit.ctf.exceptions.FlowsGenerationFailedException;
import org.mule.tools.devkit.ctf.exceptions.TestsConfigurationPropertiesFileNotFoundException;
import org.mule.tools.devkit.ctf.flows.AnnotationsParser;
import org.mule.tools.devkit.ctf.flows.MuleFlowsGenerator;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class EmbeddedMuleFlowsGenerator
extends MuleFlowsGenerator {
    public EmbeddedMuleFlowsGenerator(ConfigurationManager configManager, Class<?> connectorClass) {
        super(configManager, connectorClass);
    }

    @Override
    protected void completeHeaders(Document workingDocument) throws FlowsGenerationFailedException {
        NodeList root = workingDocument.getElementsByTagName("mule");
        Element mule = (Element)root.item(0);
        mule.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        mule.setAttribute("xmlns:doc", "http://www.mulesoft.org/schema/mule/documentation");
        mule.setAttribute("xmlns:spring", "http://www.springframework.org/schema/beans");
        mule.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        mule.setAttribute("xmlns:context", "http://www.springframework.org/schema/context");
        mule.setAttribute("xsi:schemaLocation", mule.getAttribute("xsi:schemaLocation").trim() + " http://www.mulesoft.org/schema/mule/http " + "http://www.mulesoft.org/schema/mule/http/current/mule-http.xsd " + "http://www.mulesoft.org/schema/mule/ee/tracking " + "http://www.mulesoft.org/schema/mule/ee/tracking/current/mule-tracking-ee.xsd ");
    }

    @Override
    protected void completeFlows(Document workingDocument, String connectorClass) throws TestsConfigurationPropertiesFileNotFoundException, ConfigurationLoadingFailedException {
        NodeList flows = workingDocument.getElementsByTagName("flow");
        for (int i = 0; i < flows.getLength(); ++i) {
            Node flow = flows.item(i);
            NamedNodeMap map = flow.getAttributes();
            String flowName = map.getNamedItem("name").getNodeValue();
            Node processor = flow.getFirstChild();
            boolean pagedAnnotationPresent = false;
            boolean wsdlCompleted = this.completeWSDLFlow(workingDocument, processor);
            if (!wsdlCompleted) {
                pagedAnnotationPresent = this.annotationParser.getAnnotations(flowName).contains((Object)AnnotationsParser.ProcessorsAnnotations.PAGED);
            }
            if (!pagedAnnotationPresent) continue;
            Element setVariable = workingDocument.createElement("set-variable");
            setVariable.setAttribute("variableName", "elementList");
            setVariable.setAttribute("value", "#[new java.util.ArrayList()]");
            setVariable.setAttribute("doc:name", "createElementList");
            setVariable.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
            flow.insertBefore(setVariable, processor);
            Element forEach = workingDocument.createElement("foreach");
            forEach.setAttribute("doc:name", "consumeElements");
            forEach.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
            Element expressionComponent = workingDocument.createElement("expression-component");
            expressionComponent.setAttribute("doc:name", "addElements");
            CDATASection cData = workingDocument.createCDATASection("#[flowVars.elementList.add(payload)]");
            expressionComponent.appendChild(cData);
            expressionComponent.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
            forEach.appendChild(expressionComponent);
            flow.appendChild(forEach);
            Element setPayload = workingDocument.createElement("set-payload");
            setPayload.setAttribute("value", "#[flowVars.elementList]");
            setPayload.setAttribute("doc:name", "setListToPayload");
            setPayload.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
            flow.appendChild(setPayload);
        }
    }

    @Override
    protected boolean resourcesAvailable(String connectorPath) {
        return this.isXSDAvailable(connectorPath) && this.isXMLAvailable(connectorPath);
    }
}

