/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.deployer;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.mule.tools.devkit.ctf.configuration.ConfigurationManager;
import org.mule.tools.devkit.ctf.configuration.TestingProperties;
import org.mule.tools.devkit.ctf.deployer.MuleManager;
import org.mule.tools.devkit.ctf.exceptions.MuleManagerException;
import org.mule.tools.devkit.ctf.exceptions.UnavailableLocalPortRuntimeException;

public final class LocalMuleManager
extends MuleManager {
    private static String FOLDER_NAME = "connectorApp";
    private String deployedMule;
    private ConfigurationManager configManager;
    private static final Logger logger = Logger.getLogger(LocalMuleManager.class);
    private Map<String, String> assignedPorts;
    private Process process;

    public LocalMuleManager(@NotNull ConfigurationManager configManager) throws MuleManagerException {
        this.configManager = configManager;
        this.assignedPorts = new HashMap<String, String>();
        if (configManager == null) {
            throw new MuleManagerException("Configuration manager can not be null", null);
        }
        logger.setLevel(configManager.getLoggingLevel());
    }

    @Override
    public void startMule(@NotNull String muleVersion) throws MuleManagerException {
        this.deployedMule = this.configManager.getProperties().getProperty(TestingProperties.MULEDIRECTORY);
        if (this.deployedMule == null) {
            throw new MuleManagerException("No Mule directory selected.", null);
        }
        logger.debug((Object)("Starting local Mule version: " + muleVersion + " within Mule directory: " + this.deployedMule));
        FileUtils.deleteQuietly((File)new File(this.deployedMule + "/apps/" + FOLDER_NAME));
        FileUtils.deleteQuietly((File)new File(this.deployedMule + "/apps/" + FOLDER_NAME + "-anchor.txt"));
        if (SystemUtils.IS_OS_WINDOWS) {
            this.executeCommandWindows(this.deployedMule + "/bin/mule.bat");
        } else {
            String[] execCommand = new String[]{this.deployedMule + "/bin/mule", "start"};
            this.executeCommand(execCommand);
        }
        logger.debug((Object)("Starting local Mule version: " + muleVersion + " complete"));
    }

    private void executeCommand(String[] execCommand) throws MuleManagerException {
        try {
            this.process = Runtime.getRuntime().exec(execCommand);
        }
        catch (IOException e) {
            throw new MuleManagerException("Can not execute command with parameters: " + execCommand, e);
        }
        Thread threadInput = new Thread(new Runnable(){

            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(LocalMuleManager.this.process.getInputStream(), Charset.defaultCharset()));
                try {
                    String line = reader.readLine();
                    while (line != null && !line.trim().equals("--EOF--")) {
                        logger.debug((Object)line);
                        line = reader.readLine();
                    }
                    reader.close();
                }
                catch (IOException e) {
                    logger.trace((Object)"Error while consuming process input stream", (Throwable)e);
                }
            }
        });
        threadInput.start();
        Thread threadError = new Thread(new Runnable(){

            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(LocalMuleManager.this.process.getErrorStream(), Charset.defaultCharset()));
                try {
                    String line = reader.readLine();
                    while (line != null && !line.trim().equals("--EOF--")) {
                        logger.debug((Object)line);
                        line = reader.readLine();
                    }
                    reader.close();
                }
                catch (IOException e) {
                    logger.trace((Object)"Error while consuming process error stream", (Throwable)e);
                }
            }
        });
        threadError.start();
        try {
            int exitVal = this.process.waitFor();
            logger.debug((Object)("Command Execution exit code: " + exitVal));
        }
        catch (InterruptedException e) {
            throw new MuleManagerException("Can not execute command", e);
        }
    }

    private void executeCommandWindows(String execCommand) throws MuleManagerException {
        try {
            this.process = new ProcessBuilder(execCommand).start();
        }
        catch (IOException e) {
            throw new MuleManagerException("Can not execute command with parameters: " + execCommand, e);
        }
        Thread threadInput = new Thread(new Runnable(){

            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(LocalMuleManager.this.process.getInputStream(), Charset.defaultCharset()));
                try {
                    String line = reader.readLine();
                    while (line != null && !line.trim().equals("--EOF--")) {
                        logger.debug((Object)line);
                        line = reader.readLine();
                    }
                    reader.close();
                }
                catch (IOException e) {
                    logger.trace((Object)"Error while consuming process input stream", (Throwable)e);
                }
            }
        });
        threadInput.start();
    }

    @Override
    public void shutdownMule() throws MuleManagerException {
        logger.debug((Object)("Shutting down Mule within Mule directory: " + this.deployedMule));
        FileUtils.deleteQuietly((File)new File(this.deployedMule + "/apps/" + FOLDER_NAME + "-anchor.txt"));
        this.waitOnUndeployApp(this.deployedMule + "/apps/" + FOLDER_NAME);
        if (SystemUtils.IS_OS_WINDOWS) {
            this.execCommandWindows("cmd /c taskkill /f /t /pid " + this.windowsProcessId(this.process));
        } else {
            String[] execCommand = new String[]{this.deployedMule + "/bin/mule", "stop"};
            this.executeCommand(execCommand);
        }
        logger.debug((Object)"Shutting down Mule complete");
    }

    private void execCommandWindows(String execCommand) throws MuleManagerException {
        try {
            Runtime.getRuntime().exec(execCommand);
        }
        catch (IOException e) {
            throw new MuleManagerException("Can not execute command with parameters: " + execCommand, e);
        }
    }

    @Override
    public void deployMuleApp(String generatedApp, String connectorClassName) throws MuleManagerException {
        logger.debug((Object)("Deploying local Mule app at " + this.getURIforConnector(connectorClassName)));
        String anchorFile = this.copyFolder(generatedApp);
        try {
            this.waitOnApp(anchorFile);
        }
        catch (MuleManagerException e) {
            String logsDir = this.deployedMule + "/logs/";
            File muleAppConnectorAppLog = new File(logsDir + "mule-app-connectorApp.log");
            File muleLog = new File(logsDir + "mule_ee.log");
            if (muleAppConnectorAppLog.exists()) {
                throw new MuleManagerException("Can not deploy Mule app within " + this.deployedMule + ". Please check the log at: " + muleAppConnectorAppLog.getAbsolutePath(), e);
            }
            if (muleLog.exists()) {
                throw new MuleManagerException("Can not deploy Mule app within " + this.deployedMule + ". Mule Runtime could not be loaded. Please check the log at: " + muleAppConnectorAppLog.getAbsolutePath(), e);
            }
            throw new MuleManagerException("Can not deploy Mule app within " + this.deployedMule + ". No logs found within " + logsDir, e);
        }
        logger.debug((Object)"Deploying local Mule app complete");
    }

    private void waitOnApp(String anchorFile) throws MuleManagerException {
        File file = new File(anchorFile);
        long startTime = System.currentTimeMillis();
        while (!file.exists()) {
            try {
                Thread.sleep(1000L);
                if (System.currentTimeMillis() - startTime <= 90000L) continue;
                throw new MuleManagerException("Could not deploy Mule App. You might manually deploy the Mule Environment to search for errors.", null);
            }
            catch (InterruptedException e) {
                logger.trace((Object)"Interrupt exception", (Throwable)e);
            }
        }
    }

    private void waitOnUndeployApp(String appFolder) throws MuleManagerException {
        File file = new File(appFolder);
        long startTime = System.currentTimeMillis();
        while (file.exists()) {
            try {
                Thread.sleep(1000L);
                if (System.currentTimeMillis() - startTime <= 90000L) continue;
                logger.warn((Object)("We could not undeploy the Mule App after 90 seconds. \nThis might indicate that the apps folder within the given Mule directory is locked by other proccess. \nPlease remove the folder connectorApp or the connectorapp-anchor.txt file at: " + appFolder));
            }
            catch (InterruptedException e) {
                logger.trace((Object)"Interrupt exception", (Throwable)e);
            }
        }
    }

    private Long windowsProcessId(Process process) throws MuleManagerException {
        if (process.getClass().getName().equals("java.lang.Win32Process") || process.getClass().getName().equals("java.lang.ProcessImpl")) {
            try {
                Field f = process.getClass().getDeclaredField("handle");
                f.setAccessible(true);
                long handl = f.getLong(process);
                Kernel32 kernel = Kernel32.INSTANCE;
                WinNT.HANDLE handle = new WinNT.HANDLE();
                handle.setPointer(Pointer.createConstant((long)handl));
                int ret = kernel.GetProcessId(handle);
                return ret;
            }
            catch (Exception e) {
                throw new MuleManagerException("Can not determine Windows Process ID", e);
            }
        }
        return null;
    }

    private String copyFolder(String generatedApp) throws MuleManagerException {
        String anchor = null;
        try {
            anchor = this.deployedMule + "/apps/" + FOLDER_NAME + "-anchor.txt";
            FileUtils.copyDirectory((File)new File(generatedApp), (File)new File(this.deployedMule + "/apps/" + FOLDER_NAME + "/"));
        }
        catch (IOException e) {
            throw new MuleManagerException("Can not copy folder", e);
        }
        return anchor;
    }

    @Override
    public String getMuleIPAddress() {
        return "localhost";
    }

    @Override
    public String getAssignedPort(String connectorClass) {
        String ret = this.assignedPorts.get(connectorClass);
        if (ret == null) {
            ret = this.getLocalFreePort();
            this.assignedPorts.put(connectorClass, ret);
        }
        return ret;
    }

    private String getLocalFreePort() {
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(0);
            int availablePort = ss.getLocalPort();
            ss.setReuseAddress(true);
            ss.close();
            return String.valueOf(availablePort);
        }
        catch (IOException e) {
            throw new UnavailableLocalPortRuntimeException("Could not determine a free local port at localhost", e);
        }
    }
}

