/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.deployer;

import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.PortBinding;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.mule.tools.devkit.ctf.configuration.ConfigurationManager;
import org.mule.tools.devkit.ctf.configuration.TestingProperties;
import org.mule.tools.devkit.ctf.deployer.MuleManager;
import org.mule.tools.devkit.ctf.exceptions.CTFUtilsException;
import org.mule.tools.devkit.ctf.exceptions.CloudHubException;
import org.mule.tools.devkit.ctf.exceptions.MuleManagerException;
import org.mule.tools.devkit.ctf.utils.CTFFileUtils;

public final class DockerMuleManager
extends MuleManager {
    DefaultDockerClient dockerClient;
    String DOCKER_IMAGE;
    String containerId;
    String DOCKER_URL;
    String DOCKER_IP;
    String DOCKER_PORT;
    String DEPLOYER_PORT;
    String APP_PORT;
    Client jerseyClient;
    private static final Logger logger = Logger.getLogger(DockerMuleManager.class);

    public DockerMuleManager(@NotNull ConfigurationManager configManager) {
        this.DOCKER_IP = configManager.getProperties().getProperty(TestingProperties.DOCKERIP);
        this.DOCKER_PORT = configManager.getProperties().getProperty(TestingProperties.DOCKERPORT);
        this.DOCKER_IMAGE = configManager.getProperties().getProperty(TestingProperties.DOCKERIMAGE);
        this.DOCKER_URL = String.format("http://%s:%s", this.DOCKER_IP, this.DOCKER_PORT);
    }

    @Override
    public void shutdownMule() {
        try {
            this.dockerClient.stopContainer(this.containerId, 0);
            this.dockerClient.removeContainer(this.containerId);
        }
        catch (DockerException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deployMuleApp(@NotNull String generatedApp, @NotNull String connectorClassName) throws MuleManagerException {
        File zippedFile = new File(generatedApp + ".zip");
        logger.debug((Object)"Deploying Mule app to Docker server");
        try {
            CTFFileUtils.zipDirectory(new File(generatedApp), zippedFile);
        }
        catch (CTFUtilsException e) {
            throw new CloudHubException("Can not zip file from connector app: " + generatedApp, e);
        }
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(zippedFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        FormDataMultiPart part = new FormDataMultiPart().field("app", (Object)stream, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        this.jerseyClient = Client.create((ClientConfig)clientConfig);
        this.jerseyClient.resource("http://" + this.DOCKER_IP + ":" + this.DEPLOYER_PORT + "/upload").type(MediaType.MULTIPART_FORM_DATA_TYPE).post(ClientResponse.class, (Object)part);
        logger.debug((Object)"Mule App deployed");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getMuleIPAddress() {
        return this.DOCKER_IP;
    }

    @Override
    public void startMule(String muleVersion) throws MuleManagerException {
        System.out.println(muleVersion);
        logger.debug((Object)"Creating Dockerized Mule ESB");
        try {
            this.dockerClient = DefaultDockerClient.builder().uri(new URI(this.DOCKER_URL)).build();
            String[] ports = new String[]{"8081", "8082"};
            HostConfig hostConfig = HostConfig.builder().publishAllPorts(Boolean.valueOf(true)).build();
            if (this.DOCKER_IMAGE == null) {
                this.DOCKER_IMAGE = this.selectDockerImage(muleVersion);
            }
            ContainerConfig muleContainer = ContainerConfig.builder().hostConfig(hostConfig).image(this.DOCKER_IMAGE).exposedPorts(ports).build();
            ContainerCreation dockerContainer = this.dockerClient.createContainer(muleContainer);
            this.dockerClient.startContainer(dockerContainer.id());
            this.containerId = dockerContainer.id();
            Thread.sleep(10000L);
            ContainerInfo containerInfo = this.dockerClient.inspectContainer(dockerContainer.id());
            this.DEPLOYER_PORT = ((PortBinding)((List)containerInfo.networkSettings().ports().get("8081")).get(0)).hostPort();
            this.APP_PORT = ((PortBinding)((List)containerInfo.networkSettings().ports().get("8082")).get(0)).hostPort();
            logger.debug((Object)("App Port: " + this.APP_PORT));
        }
        catch (URISyntaxException e) {
            throw new MuleManagerException("F", e.getCause());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (DockerException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getURIforConnector(String connectorClassName) {
        return "http://" + this.getMuleIPAddress() + ":" + this.APP_PORT + "/";
    }

    @Override
    public String getAssignedPort(String connectorClass) {
        return "8082";
    }

    public String selectDockerImage(String muleVersion) throws MuleManagerException {
        if (muleVersion.equals("mule37")) {
            return "estebanwasinger/mule:3.7.0-Java8";
        }
        if (muleVersion.equals("mule36")) {
            return "estebanwasinger/mule:3.6.2-EE";
        }
        if (muleVersion.equals("mule35")) {
            return "estebanwasinger/mule:3.5.3-EE";
        }
        throw new MuleManagerException("Unsupported Mule version for Docker deployment");
    }
}

