/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.deployer;

import com.mulesoft.ch.rest.model.Application;
import com.mulesoft.ch.rest.model.ApplicationStatus;
import com.mulesoft.ch.rest.model.LogResults;
import com.mulesoft.cloudhub.client.CloudHubConnectionImpl;
import com.mulesoft.cloudhub.client.CloudHubDomainConnectionI;
import java.io.File;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.mule.tools.devkit.ctf.configuration.ConfigurationManager;
import org.mule.tools.devkit.ctf.configuration.TestingProperties;
import org.mule.tools.devkit.ctf.deployer.MuleManager;
import org.mule.tools.devkit.ctf.exceptions.CTFUtilsException;
import org.mule.tools.devkit.ctf.exceptions.CloudHubException;
import org.mule.tools.devkit.ctf.exceptions.MuleManagerException;
import org.mule.tools.devkit.ctf.utils.CTFFileUtils;

public final class CloudMuleManager
extends MuleManager {
    private CloudHubConnectionImpl cloudHubClient;
    private CloudHubDomainConnectionI cloudHubConnection;
    private String CloudHubDomain;
    private static final String CloudHubAddress = "https://cloudhub.io/";
    private ConfigurationManager configManager;
    private static final Logger logger = Logger.getLogger(CloudMuleManager.class);

    public CloudMuleManager(@NotNull ConfigurationManager configManager) throws MuleManagerException {
        this.configManager = configManager;
        if (configManager == null) {
            throw new MuleManagerException("Configuration manager can not be null", null);
        }
        logger.setLevel(configManager.getLoggingLevel());
    }

    @Override
    public void shutdownMule() throws MuleManagerException {
        logger.debug((Object)"Undeploying CloudHub application");
        this.cloudHubConnection.deleteApplication();
    }

    @Override
    public void deployMuleApp(String generatedApp, String connectorClassName) throws MuleManagerException {
        logger.debug((Object)"Deploying CloudHub app");
        this.CloudHubDomain = "ctf-" + connectorClassName.substring(connectorClassName.lastIndexOf(".") + 1).toLowerCase() + "-" + System.currentTimeMillis();
        this.cloudHubConnection = this.cloudHubClient.connectWithDomain(this.CloudHubDomain);
        Application app = null;
        if (!this.cloudHubConnection.isDomainAvailable(this.CloudHubDomain)) {
            throw new CloudHubException("Can not deploy CloudHub app. Domain: " + this.CloudHubDomain + " is not available. Please log to your CloudHub account and delete it manually.", null);
        }
        app = new Application();
        app.setDomain(this.CloudHubDomain);
        app.setHasFile(false);
        app.setWorkers(Integer.valueOf(1));
        app.setMuleVersion(this.configManager.getProperties().getProperty(TestingProperties.MULEVERSION));
        this.cloudHubClient.createApplication(app);
        File zippedFile = new File(generatedApp + ".zip");
        try {
            CTFFileUtils.zipDirectory(new File(generatedApp), zippedFile);
        }
        catch (CTFUtilsException e) {
            throw new CloudHubException("Can not zip file from connector app: " + generatedApp, e);
        }
        String cloudHubTimeOut = this.configManager.getProperties().getProperty(TestingProperties.CLOUDHUBTIMEOUT);
        int timeOut = 180000;
        if (cloudHubTimeOut != null) {
            timeOut = Integer.valueOf(cloudHubTimeOut);
        }
        this.cloudHubConnection.deployApplication(zippedFile, 0L);
        ApplicationStatus applicationStatus = this.cloudHubConnection.retrieveApplicationStatus();
        long startTime = System.currentTimeMillis();
        while (applicationStatus.compareTo((Enum)ApplicationStatus.STARTED) != 0) {
            try {
                Thread.sleep(5000L);
                if (System.currentTimeMillis() - startTime > (long)timeOut || applicationStatus.compareTo((Enum)ApplicationStatus.DEPLOY_FAILED) == 0) {
                    LogResults logResults = this.cloudHubConnection.retrieveApplicationLog(null);
                    this.cloudHubConnection.deleteApplication();
                    throw new CloudHubException("Could not deploy Mule app om CloudHub. Log results: " + logResults.getData(), null);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            applicationStatus = this.cloudHubConnection.retrieveApplicationStatus();
        }
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    @Override
    public String getMuleIPAddress() {
        return this.CloudHubDomain + ".cloudhub.io";
    }

    @Override
    public void startMule(String muleVersion) throws MuleManagerException {
        String user = this.configManager.getProperties().getProperty(TestingProperties.CLOUDHUBUSER);
        String password = this.configManager.getProperties().getProperty(TestingProperties.CLOUDHUBPASSWORD);
        this.cloudHubClient = new CloudHubConnectionImpl(CloudHubAddress, user, password, null, false);
        this.cloudHubClient.isCsAuthentication();
    }

    @Override
    public String getAssignedPort(String connectorClass) {
        return "${http.port}";
    }

    @Override
    public String getURIforConnector(String connectorClassName) {
        return "http://" + this.getMuleIPAddress() + "/";
    }
}

