/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.configuration.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.mule.tools.devkit.ctf.exceptions.CTFUtilsException;
import org.mule.tools.devkit.ctf.exceptions.ConfigurationLoadingFailedException;
import org.mule.tools.devkit.ctf.utils.CTFFileUtils;

public final class ConfigurationUtils {
    private static final Logger logger = Logger.getLogger(ConfigurationUtils.class);

    private ConfigurationUtils() {
    }

    private static String getAutomationCredentialsPropertiesPath(String connectorPath) throws ConfigurationLoadingFailedException {
        String automationCredentialsProperty = System.getProperty("automation-credentials.properties");
        if (automationCredentialsProperty == null) {
            automationCredentialsProperty = "automation-credentials.properties";
        }
        String resourcePath = connectorPath + "/src/test/resources";
        String automationFile = resourcePath + "/" + automationCredentialsProperty;
        try {
            CTFFileUtils.getFileFullName(resourcePath, automationCredentialsProperty);
        }
        catch (CTFUtilsException e) {
            throw new ConfigurationLoadingFailedException("No automation default file found within " + resourcePath, e);
        }
        return automationFile;
    }

    public static Properties getAutomationCredentialsProperties() throws ConfigurationLoadingFailedException {
        String connectorPath = System.getProperty("user.dir");
        Properties ret = new Properties();
        String automationPath = ConfigurationUtils.getAutomationCredentialsPropertiesPath(connectorPath);
        try {
            ret.load(new FileInputStream(automationPath));
        }
        catch (IOException e) {
            throw new ConfigurationLoadingFailedException("Can not load Automation Credentials File within path " + automationPath, e);
        }
        return ret;
    }

    public static String autoDetectMuleVersion(String muleDirectory) {
        String muleVersion;
        if (muleDirectory == null) {
            return null;
        }
        String libMulePath = muleDirectory + "/lib/mule";
        try {
            File[] results = CTFFileUtils.getFilesStartingWith(libMulePath, "mule-core", "jar");
            String firstFile = results[1].getName();
            if (firstFile.contains("tests")) {
                firstFile = results[0].getName();
            }
            muleVersion = firstFile.substring(firstFile.indexOf(".") - 1, firstFile.lastIndexOf("."));
            if (firstFile.contains("SNAPSHOT")) {
                muleVersion = muleVersion.substring(0, muleVersion.indexOf("-"));
            }
        }
        catch (CTFUtilsException e) {
            logger.trace((Object)("Imposible to detect a Mule version within: " + muleDirectory), (Throwable)e);
            logger.error((Object)("Imposible to detect a Mule version within: " + muleDirectory));
            return null;
        }
        return muleVersion;
    }
}

