/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.configuration.retriever;

import com.google.common.collect.Iterables;
import com.mulesoft.cloudhub.client.CloudHubConnectionImpl;
import com.mulesoft.cloudhub.client.CloudHubException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.mule.tools.devkit.ctf.exceptions.ConfigurationLoadingFailedException;

public class CloudHubConfigurationRetriever {
    private static final Logger logger = Logger.getLogger(CloudHubConfigurationRetriever.class);

    public static String getCloudHubUser() throws ConfigurationLoadingFailedException {
        String cloudHubUser = System.getProperty("cloudhubuser");
        if (cloudHubUser != null) {
            return cloudHubUser;
        }
        throw new ConfigurationLoadingFailedException("A CloudHub deployment profile was selected but CloudHub user is missing. Please use -Dcloudhubuser=<user> with your CloudHub credentials.", null);
    }

    public static String getCloudHubPassword() throws ConfigurationLoadingFailedException {
        String cloudHubPassword = System.getProperty("cloudhubpassword");
        if (cloudHubPassword != null) {
            return cloudHubPassword;
        }
        throw new ConfigurationLoadingFailedException("A CloudHub deployment profile was selected but either CloudHub password is missing. Please use -Dcloudhubpassword=<password> with your credentials.", null);
    }

    public static String getCloudHubMuleVersion(String cloudHubUser, String cloudHubPassword, String muleVersion) throws ConfigurationLoadingFailedException {
        List<String> supportedMuleVersions;
        CloudHubConnectionImpl connection = new CloudHubConnectionImpl("https://anypoint.mulesoft.com/cloudhub/", cloudHubUser, cloudHubPassword, null, false);
        try {
            supportedMuleVersions = connection.getSupportedMuleVersions();
        }
        catch (CloudHubException e) {
            throw new ConfigurationLoadingFailedException("CloudHub user or password are incorrect. Please review your credentials.", e);
        }
        supportedMuleVersions = CloudHubConfigurationRetriever.filterMuleVersions(supportedMuleVersions);
        Collections.sort(supportedMuleVersions);
        if (muleVersion == null) {
            muleVersion = (String)Iterables.getLast(supportedMuleVersions);
            logger.info((Object)("Mule Version has not been specified using the latest available in CloudHub: [" + muleVersion + "]"));
            return muleVersion;
        }
        if (!supportedMuleVersions.contains(muleVersion)) {
            String versions = StringUtils.join(supportedMuleVersions, (String)", ");
            throw new ConfigurationLoadingFailedException("The especified mule versions currently does not exist in CloudHub, please select one of the following versions: " + versions, null);
        }
        return muleVersion;
    }

    @NotNull
    private static List<String> filterMuleVersions(List<String> supportedMuleVersions) {
        ArrayList<String> withOutGateWay = new ArrayList<String>();
        for (String version : supportedMuleVersions) {
            if (version.startsWith("API") || version.startsWith("3.4") || version.startsWith("3.3")) continue;
            withOutGateWay.add(version);
        }
        return withOutGateWay;
    }
}

