/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mule.tools.devkit.ctf.configuration.TestingProperties;
import org.mule.tools.devkit.ctf.exceptions.ConfigurationPropertyException;

public final class ConfigurationProperties {
    private static final Logger logger = Logger.getLogger(ConfigurationProperties.class);
    private Map<TestingProperties, String> properties = new HashMap<TestingProperties, String>();

    public ConfigurationProperties() {
    }

    public ConfigurationProperties(Level loggingLevel) {
        logger.setLevel(loggingLevel);
    }

    public void setProperty(TestingProperties property, String value) throws ConfigurationPropertyException {
        this.setProperty(property, value, null);
    }

    public void setProperty(TestingProperties property, String value, Object[] validOptions) throws ConfigurationPropertyException {
        if (validOptions == null) {
            this.properties.put(property, value);
            logger.debug((Object)("Loading property: " + (Object)((Object)property) + " with value: " + value + " (unchecked)"));
            return;
        }
        if (!ConfigurationProperties.checkProperty(value, validOptions)) {
            List<Object> l = Arrays.asList(validOptions);
            ArrayList<String> ll = new ArrayList<String>();
            for (int i = 0; i < l.size(); ++i) {
                ll.add(l.get(i).toString());
            }
            throw new ConfigurationPropertyException("Property: " + (Object)((Object)property) + " has an incorrect value. Please use one of " + ll, null);
        }
        this.properties.put(property, value);
        logger.debug((Object)("Loading property: " + (Object)((Object)property) + " with value: " + value));
    }

    @Nullable
    public String getProperty(@NotNull TestingProperties property) {
        String ret = this.properties.get((Object)property);
        if (ret == null) {
            logger.trace((Object)("Property: " + (Object)((Object)property) + " has a NULL value and has not been defined."));
        }
        return ret;
    }

    public static boolean checkProperty(@NotNull String value, @NotNull Object[] validOptions) {
        List<Object> l = Arrays.asList(validOptions);
        ArrayList<String> ll = new ArrayList<String>();
        for (int i = 0; i < l.size(); ++i) {
            ll.add(l.get(i).toString());
        }
        return ll.contains(value);
    }
}

