/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.shade147.io.xml;

import com.thoughtworks.xstream.shade147.core.JVM;
import com.thoughtworks.xstream.shade147.io.StreamException;
import com.thoughtworks.xstream.shade147.io.naming.NameCoder;
import com.thoughtworks.xstream.shade147.io.xml.QNameMap;
import com.thoughtworks.xstream.shade147.io.xml.StaxDriver;
import com.thoughtworks.xstream.shade147.io.xml.XmlFriendlyNameCoder;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;

public class StandardStaxDriver
extends StaxDriver {
    public StandardStaxDriver() {
    }

    public StandardStaxDriver(QNameMap qnameMap, XmlFriendlyNameCoder nameCoder) {
        super(qnameMap, nameCoder);
    }

    public StandardStaxDriver(QNameMap qnameMap, NameCoder nameCoder) {
        super(qnameMap, nameCoder);
    }

    public StandardStaxDriver(QNameMap qnameMap) {
        super(qnameMap);
    }

    public StandardStaxDriver(XmlFriendlyNameCoder nameCoder) {
        super(nameCoder);
    }

    public StandardStaxDriver(NameCoder nameCoder) {
        super(nameCoder);
    }

    protected XMLInputFactory createInputFactory() {
        ReflectiveOperationException exception = null;
        try {
            Class staxInputFactory = JVM.getStaxInputFactory();
            if (staxInputFactory != null) {
                return (XMLInputFactory)staxInputFactory.newInstance();
            }
            throw new StreamException("Java runtime has no standard XMLInputFactory implementation.", exception);
        }
        catch (InstantiationException e) {
            exception = e;
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (ClassNotFoundException e) {
            exception = e;
        }
        throw new StreamException("Cannot create standard XMLInputFactory instance of Java runtime.", exception);
    }

    protected XMLOutputFactory createOutputFactory() {
        ReflectiveOperationException exception = null;
        try {
            Class staxOutputFactory = JVM.getStaxOutputFactory();
            if (staxOutputFactory != null) {
                return (XMLOutputFactory)staxOutputFactory.newInstance();
            }
            throw new StreamException("Java runtime has no standard XMLOutputFactory implementation.", exception);
        }
        catch (InstantiationException e) {
            exception = e;
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (ClassNotFoundException e) {
            exception = e;
        }
        throw new StreamException("Cannot create standard XMLOutputFactory instance of Java runtime.", exception);
    }
}

