/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.platform;

import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.mule.tools.devkit.ctf.configuration.ConfigurationManager;
import org.mule.tools.devkit.ctf.deployer.MuleManager;
import org.mule.tools.devkit.ctf.exceptions.PlatformManagerException;
import org.mule.tools.devkit.ctf.platform.PlatformHookPoint;
import org.mule.tools.devkit.ctf.platform.PlatformManager;

public abstract class AbstractPlatformManager
implements PlatformManager {
    protected PlatformManager.PlatformStates currentState;
    protected ConfigurationManager configManager;
    protected MuleManager muleManager;
    protected PlatformHookPoint hookPoint;
    private static final Logger logger = Logger.getLogger(AbstractPlatformManager.class);

    public AbstractPlatformManager(@NotNull ConfigurationManager configManager) {
        this.configManager = configManager;
        this.currentState = PlatformManager.PlatformStates.STOPPED;
        logger.setLevel(configManager.getLoggingLevel());
    }

    @Override
    public PlatformManager.PlatformStates getCurrentState() {
        return this.currentState;
    }

    public void addHookPoint(PlatformHookPoint point) {
        this.hookPoint = point;
    }

    @Override
    public void initialize() {
        if (this.currentState.equals((Object)PlatformManager.PlatformStates.STARTED)) {
            logger.debug((Object)"Platform already initialized.");
            return;
        }
        logger.debug((Object)"Performing Initialization phase");
        try {
            this.performStart();
            if (this.hookPoint != null) {
                this.hookPoint.onStart();
            }
            this.performDeploy();
            if (this.hookPoint != null) {
                this.hookPoint.onDeploy();
            }
        }
        catch (Exception e) {
            throw new PlatformManagerException(e);
        }
        this.currentState = PlatformManager.PlatformStates.STARTED;
        logger.debug((Object)"Initialization phase complete");
    }

    @Override
    public void shutdown() {
        if (this.currentState.equals((Object)PlatformManager.PlatformStates.STOPPED)) {
            logger.debug((Object)"Platform already stopped.");
            return;
        }
        logger.debug((Object)"Performing Shutdown phase");
        try {
            this.performUndeploy();
            if (this.hookPoint != null) {
                this.hookPoint.onUndeploy();
            }
            this.performStop();
            if (this.hookPoint != null) {
                this.hookPoint.onStop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.currentState = PlatformManager.PlatformStates.STOPPED;
        logger.debug((Object)"Shutdown phase complete");
    }

    protected abstract void performStart() throws Exception;

    protected abstract void performDeploy() throws Exception;

    protected abstract void performUndeploy() throws Exception;

    protected abstract void performStop() throws Exception;

    public MuleManager getMuleManager() {
        return this.muleManager;
    }
}

