/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.packager;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.mule.tools.devkit.ctf.configuration.ConfigurationManager;
import org.mule.tools.devkit.ctf.configuration.TestingProperties;
import org.mule.tools.devkit.ctf.exceptions.CTFUtilsException;
import org.mule.tools.devkit.ctf.exceptions.ConfigurationLoadingFailedException;
import org.mule.tools.devkit.ctf.exceptions.MuleAppGenerationFailedException;
import org.mule.tools.devkit.ctf.flows.MuleFlowsGenerator;
import org.mule.tools.devkit.ctf.packager.PackagerUtils;
import org.mule.tools.devkit.ctf.utils.CTFFileUtils;

public final class ApplicationPackager {
    private MuleFlowsGenerator muleFlowsGenerator;
    private ConfigurationManager configManager;
    private String connectorName;
    private String connectorPath;
    private static final Logger logger = Logger.getLogger(ApplicationPackager.class);

    public ApplicationPackager(@NotNull ConfigurationManager configManager, @NotNull MuleFlowsGenerator muleFlowsGenerator, @NotNull String connectorPath, @NotNull String connectorName) {
        this.muleFlowsGenerator = muleFlowsGenerator;
        this.configManager = configManager;
        this.connectorName = connectorName;
        this.connectorPath = connectorPath;
        logger.setLevel(configManager.getLoggingLevel());
    }

    public String getPackagedAppPath() {
        return this.getFunctionalTestingPath() + "/" + this.connectorName + "-packagedapp";
    }

    public void generateMuleApp() throws Exception {
        logger.debug((Object)"Generating Mule app");
        String absPathXMLFile = this.muleFlowsGenerator.generateFlows(this.connectorName, this.connectorPath, this.getFunctionalTestingPath());
        logger.debug((Object)"Flows created");
        String automationCredentialsFile = this.configManager.getProperties().getProperty(TestingProperties.CONFIGURATIONSFILE);
        String resourcePath = this.connectorPath + "/src/test/resources";
        String credentialsFilePath = resourcePath + "/" + automationCredentialsFile;
        try {
            CTFFileUtils.getFileFullName(resourcePath, automationCredentialsFile);
        }
        catch (CTFUtilsException e) {
            logger.trace((Object)("No automation default file found within " + resourcePath), (Throwable)e);
            throw new ConfigurationLoadingFailedException("The automation credentials files was not found within the available resources. Please add '" + automationCredentialsFile + "' to src/test/resources.", e);
        }
        logger.debug((Object)"Automation Credentials file loaded");
        String packagedApp = this.getPackagedAppPath();
        File folder = new File(packagedApp);
        boolean success = folder.mkdirs();
        if (!success) {
            logger.warn((Object)"Mule app structure already present within connector target folder");
        }
        logger.debug((Object)"Folder structure created");
        String deployproperties = this.getDeployPropertiesFile(this.connectorName, packagedApp);
        try {
            FileUtils.copyFile((File)new File(credentialsFilePath), (File)new File(packagedApp + "/" + automationCredentialsFile));
            FileUtils.copyFile((File)new File(absPathXMLFile), (File)new File(packagedApp + "/" + this.connectorName + ".flows.xml"));
        }
        catch (IOException e) {
            throw new MuleAppGenerationFailedException("Can not copy credentials file nor flows files ", e);
        }
        String pluginsFolder = packagedApp + "/plugins";
        success = new File(pluginsFolder).mkdirs();
        if (!success) {
            logger.warn((Object)"Mule app structure - plugin folder - already present within connector target folder");
        }
        String zipFilePath = this.connectorPath + "/target";
        String artifactID = PackagerUtils.getArtifactID(this.connectorPath);
        String zipFile = CTFFileUtils.getFile(zipFilePath, artifactID, "zip");
        String destination = pluginsFolder + "/" + zipFile;
        try {
            FileUtils.copyFile((File)new File(zipFilePath + "/" + zipFile), (File)new File(destination));
        }
        catch (IOException e) {
            throw new MuleAppGenerationFailedException("Can not move connector ZIP file to destination folder", e);
        }
        String libFolder = packagedApp + "/lib";
        success = new File(libFolder).mkdirs();
        if (!success) {
            logger.warn((Object)"Mule app structure - lib folder - already present within connector target folder");
        }
        String mavenRepo = this.configManager.getProperties().getProperty(TestingProperties.MAVENLOCALREPO);
        String m2Home = this.configManager.getProperties().getProperty(TestingProperties.M2HOME);
        String functionaTestingPath = this.getFunctionalTestingPath();
        String connectorTestingFrameworkVersion = PackagerUtils.getConnectorTestingFrameworkVersionFromDependencyTree(m2Home, this.connectorPath, functionaTestingPath, this.configManager);
        String connectorTestingFrameworkJarPath = mavenRepo + "/repository/org/mule/tools/devkit/connector-testing-framework/" + connectorTestingFrameworkVersion;
        String kissFileName = CTFFileUtils.getFileFullName(connectorTestingFrameworkJarPath, "connector-testing-framework-" + connectorTestingFrameworkVersion + ".jar");
        String kissJarFilePath = connectorTestingFrameworkJarPath + "/" + kissFileName;
        String destinationJar = libFolder + "/" + kissFileName;
        try {
            FileUtils.copyFile((File)new File(kissJarFilePath), (File)new File(destinationJar));
        }
        catch (IOException e) {
            throw new MuleAppGenerationFailedException("Can not move framework ZIP file to destination folder", e);
        }
        Map<String, String> requiredJars = this.configManager.getRequiredLibraries();
        this.copyRequiredJarsFolder(requiredJars, this.connectorPath, pluginsFolder);
        String classesFolder = packagedApp + "/classes";
        success = new File(classesFolder).mkdirs();
        if (!success) {
            logger.warn((Object)"Mule app structure - class folder - already present within connector target folder");
        }
        try {
            FileUtils.copyFile((File)new File(credentialsFilePath), (File)new File(classesFolder + "/" + automationCredentialsFile));
            FileUtils.copyFile((File)new File(deployproperties), (File)new File(classesFolder + "/" + "mule-deploy.properties"));
            FileUtils.copyFile((File)new File(absPathXMLFile), (File)new File(classesFolder + "/" + this.connectorName + ".flows.xml"));
            this.copyResourcers(classesFolder);
        }
        catch (IOException e) {
            throw new MuleAppGenerationFailedException("Can not move files to destination folder", e);
        }
        String serializationJarPath = mavenRepo + "/repository/org/mule/tools/devkit/connector-testing-framework-serializers/" + connectorTestingFrameworkVersion;
        String serializerFileName = CTFFileUtils.getFileFullName(serializationJarPath, "connector-testing-framework-serializers-" + connectorTestingFrameworkVersion + ".jar");
        String serializaerJarFilePath = serializationJarPath + "/" + serializerFileName;
        String serializaerdestinationJar = libFolder + "/" + serializerFileName;
        try {
            FileUtils.copyFile((File)new File(serializaerJarFilePath), (File)new File(serializaerdestinationJar));
        }
        catch (IOException e) {
            throw new MuleAppGenerationFailedException("Can not move serializers ZIP file to destination folder", e);
        }
        String serializationEngineJarPath = mavenRepo + "/repository/org/mule/tools/devkit/connector-testing-framework-serializer-engine/" + connectorTestingFrameworkVersion;
        String serializerEngineFileName = CTFFileUtils.getFileFullName(serializationEngineJarPath, "connector-testing-framework-serializer-engine-" + connectorTestingFrameworkVersion + ".jar");
        String serializerEngineJarFilePath = serializationEngineJarPath + "/" + serializerEngineFileName;
        String serializerEnginedestinationJar = libFolder + "/" + serializerEngineFileName;
        try {
            FileUtils.copyFile((File)new File(serializerEngineJarFilePath), (File)new File(serializerEnginedestinationJar));
        }
        catch (IOException e) {
            throw new MuleAppGenerationFailedException("Can not move serializer engine ZIP file to destination folder", e);
        }
        logger.debug((Object)"Generating Mule app complete");
    }

    private void copyRequiredJarsFolder(@NotNull Map<String, String> requiredJars, @NotNull String connectorPath, @NotNull String pluginsFolder) throws MuleAppGenerationFailedException {
        if (requiredJars.isEmpty()) {
            return;
        }
        try {
            File zipFile = new File(pluginsFolder, "plugin-dependency-lib.zip");
            String tmpFolder = pluginsFolder + "/tmp";
            boolean success = new File(tmpFolder).mkdirs();
            if (!success) {
                logger.warn((Object)"Functional temporal folder already present within connector target folder");
            }
            for (String jarName : requiredJars.keySet()) {
                String jarLocation = requiredJars.get(jarName) + "/" + jarName;
                String jarDestination = tmpFolder + "/lib/" + jarName;
                logger.debug((Object)("Copying Jar from: " + jarLocation + " to " + jarDestination));
                FileUtils.copyFile((File)new File(jarLocation), (File)new File(jarDestination));
            }
            PrintWriter writer = new PrintWriter("plugin.properties", "UTF-8");
            writer.print("# Plugin Properties");
            writer.close();
            FileUtils.copyFile((File)new File("plugin.properties"), (File)new File(tmpFolder + "/org/mule/module/plugin-dependency-lib/" + "plugin.properties"));
            CTFFileUtils.zipDirectory(new File(tmpFolder), zipFile);
            FileUtils.deleteDirectory((File)new File(tmpFolder));
        }
        catch (IOException e) {
            throw new MuleAppGenerationFailedException("Can not copy required JARs files", e);
        }
        catch (CTFUtilsException e) {
            throw new MuleAppGenerationFailedException("Can not copy required JARs files", e);
        }
    }

    private void copyResourcers(@NotNull String classesFolder) throws IOException {
        File[] listOfFiles;
        String resourcesPath = "./src/test/resources/";
        File folder = new File(resourcesPath);
        for (File f : listOfFiles = folder.listFiles()) {
            if (!f.isFile()) continue;
            FileUtils.copyFile((File)new File(f.getAbsolutePath()), (File)new File(classesFolder + "/" + f.getName()));
        }
    }

    public String getFunctionalTestingPath() {
        return this.connectorPath + "/target/functionalTesting";
    }

    private String getDeployPropertiesFile(@NotNull String connectorName, @NotNull String packagedApp) throws FileNotFoundException, UnsupportedEncodingException {
        String filePath = packagedApp + "/mule-deploy.properties";
        PrintWriter writer = new PrintWriter(filePath, "UTF-8");
        writer.println("#Autogenerated file - Functional Testing Framework");
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss - dd/MM/yyyy");
        writer.println("#" + dateFormat.format(new Date()));
        writer.println("redeployment.enabled=true");
        writer.println("encoding=UTF-8");
        writer.println("domain=default");
        writer.println("config.resources=" + connectorName + ".flows.xml");
        writer.close();
        return filePath;
    }
}

