/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.mockup;

import org.apache.log4j.Logger;
import org.mule.tools.devkit.ctf.configuration.ConfigurationManager;
import org.mule.tools.devkit.ctf.configuration.DeploymentProfiles;
import org.mule.tools.devkit.ctf.configuration.TestingProperties;
import org.mule.tools.devkit.ctf.exceptions.ConfigurationLoadingFailedException;
import org.mule.tools.devkit.ctf.exceptions.ConfigurationPropertyException;
import org.mule.tools.devkit.ctf.mockup.ConnectorDispatcher;
import org.mule.tools.devkit.ctf.mockup.ConnectorMockup;
import org.mule.tools.devkit.ctf.mockup.EmbeddedConnectorMockup;
import org.mule.tools.devkit.ctf.mockup.LocalConnectorMockup;
import org.mule.tools.devkit.ctf.platform.AbstractPlatformManager;
import org.mule.tools.devkit.ctf.platform.PlatformManager;
import org.mule.tools.devkit.ctf.platform.PlatformManagerFactory;

public final class ConnectorTestContext<T> {
    private static final Logger logger = Logger.getLogger(ConnectorTestContext.class);
    private ConfigurationManager configManager;
    private AbstractPlatformManager platformManager;
    private ConnectorDispatcher<T> connectorDispatcher;
    private static ConnectorTestContext<?> instance;
    private boolean suiteInitialization;
    private int testCount;

    public int incrementTestCount() {
        ++this.testCount;
        return this.testCount;
    }

    public int decrementTestCount() {
        --this.testCount;
        return this.testCount;
    }

    public boolean isSuiteInitialization() {
        return this.suiteInitialization;
    }

    public static <J> ConnectorTestContext<J> getInstance(Class<J> connectorClass) {
        logger.warn((Object)"getInstance(final Class<J> connectorClass) is depredecated. Please use getInstance() instead.");
        return ConnectorTestContext.getInstance();
    }

    public static <J> ConnectorTestContext<J> getInstance() {
        if (instance == null || instance.getPlatformManager().getCurrentState().equals((Object)PlatformManager.PlatformStates.STOPPED)) {
            throw new RuntimeException("Connector Test Context not initialized. Please use initialize() first.");
        }
        return instance;
    }

    public static synchronized <T> void initialize(Class<T> connectorClass) {
        if (instance != null) {
            throw new RuntimeException("Connector Test Context has already been initialized.");
        }
        instance = new ConnectorTestContext<T>(connectorClass, true);
        PlatformManager manager = instance.getPlatformManager();
        manager.initialize();
    }

    public static synchronized <T> void initialize(Class<T> connectorClass, boolean suiteInitialization) {
        if (instance != null && suiteInitialization && instance.isSuiteInitialization()) {
            throw new RuntimeException("It seems that you have set suiteInitialization=true and the context has already been initialized.");
        }
        if (instance != null && !suiteInitialization && instance.isSuiteInitialization()) {
            logger.debug((Object)"Ignoring test Initialize call. Context has already been initialized by the test suite.");
            return;
        }
        if (instance != null && !instance.isSuiteInitialization() && !suiteInitialization) {
            logger.debug((Object)("Ignoring Initialize call. Context has already been initialized. Keeping test count: " + instance.incrementTestCount()));
            return;
        }
        if (instance == null && !suiteInitialization) {
            ConnectorTestContext.initialize(connectorClass);
            return;
        }
        if (instance == null && suiteInitialization) {
            logger.debug((Object)"Initializing suite. Please use initialize(connectorClass) instead of initialize(connectoClass, true).");
            ConnectorTestContext.initialize(connectorClass);
            return;
        }
    }

    public static synchronized <T> void shutDown() {
        if (instance == null) {
            throw new RuntimeException("Connector Test Context not initialized. Please use initialise() first.");
        }
        PlatformManager manager = instance.getPlatformManager();
        manager.shutdown();
        instance = null;
    }

    public static synchronized <T> void shutDown(boolean suiteInitialization) {
        if (instance == null) {
            throw new RuntimeException("Connector Test Context not initialized. Please use initialise() first.");
        }
        if (!instance.isSuiteInitialization() && !suiteInitialization) {
            int testCount = instance.decrementTestCount();
            if (testCount == 0) {
                ConnectorTestContext.shutDown();
                return;
            }
            logger.debug((Object)("Ignoring shutDown request. There are still: " + testCount + " to be executed."));
            return;
        }
        if (instance.isSuiteInitialization() && suiteInitialization) {
            logger.debug((Object)"Shutting down suite. Please use shutDown() instead of shutDown(true) when shutting down from the test suite.");
            ConnectorTestContext.shutDown();
            return;
        }
        if (instance.isSuiteInitialization() && !suiteInitialization) {
            logger.debug((Object)"Ignoring test shut down call. Context has been initialized from the test suite.");
            return;
        }
    }

    public PlatformManager getPlatformManager() {
        return this.platformManager;
    }

    public ConnectorDispatcher<T> getConnectorDispatcher() {
        return this.connectorDispatcher;
    }

    private ConnectorTestContext(Class<T> connectorClass, boolean suiteInitialization) {
        try {
            this.suiteInitialization = suiteInitialization;
            this.testCount = 0;
            String connectorPath = ConnectorMockup.getConnectorPath();
            this.configManager = new ConfigurationManager(connectorPath);
            logger.setLevel(this.configManager.getLoggingLevel());
            this.platformManager = (AbstractPlatformManager)PlatformManagerFactory.getLifecycleManager(this.configManager);
            this.connectorDispatcher = this.createDispatcher(connectorClass);
        }
        catch (ConfigurationLoadingFailedException e) {
            throw new RuntimeException(e);
        }
        catch (ConfigurationPropertyException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ConnectorDispatcher<T> createDispatcher(Class<T> connectorClass) throws Exception {
        ConnectorMockup ret;
        String deploymentProfile = this.configManager.getProperties().getProperty(TestingProperties.DEPLOYMENTPROFILE);
        if (deploymentProfile == null) {
            throw new ConfigurationPropertyException("No deployment profile set", null);
        }
        if (deploymentProfile.equals(DeploymentProfiles.embedded.toString())) {
            ret = new EmbeddedConnectorMockup<T>(connectorClass, this.configManager, this.platformManager);
        } else if (deploymentProfile.equals(DeploymentProfiles.local.toString())) {
            ret = new LocalConnectorMockup<T>(connectorClass, this.configManager, this.platformManager);
        } else {
            throw new ConfigurationPropertyException("Deployment profile: " + deploymentProfile + " not implemented. Stand by for updates mate.", null);
        }
        return ret;
    }
}

