/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.mockup;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import net.sf.cglib.proxy.Enhancer;
import org.mule.common.Result;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.tools.devkit.ctf.configuration.ConfigurationManager;
import org.mule.tools.devkit.ctf.handlers.MethodExecutionHandler;
import org.mule.tools.devkit.ctf.mockup.ConnectorDispatcher;
import org.mule.tools.devkit.ctf.mockup.ConnectorInvocationHandler;
import org.mule.tools.devkit.ctf.platform.AbstractPlatformManager;

public abstract class ConnectorMockup<T>
implements ConnectorDispatcher<T> {
    protected Class<T> connectorClass;
    protected AbstractPlatformManager lifecycleManager;
    protected ConfigurationManager configManager;
    protected MethodExecutionHandler<T> methodExecutionHandler;
    protected T mockup;

    protected abstract MethodExecutionHandler<T> getMethodExecutionHandler();

    public ConnectorMockup(Class<T> connectorClass, ConfigurationManager configManager, AbstractPlatformManager lifecycleManager) {
        this.connectorClass = connectorClass;
        this.configManager = configManager;
        this.lifecycleManager = lifecycleManager;
        this.methodExecutionHandler = this.getMethodExecutionHandler();
        lifecycleManager.addHookPoint(this.methodExecutionHandler);
    }

    @Override
    public T createMockup() {
        if (this.mockup != null) {
            return this.mockup;
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(this.connectorClass);
        enhancer.setCallback(new ConnectorInvocationHandler<T>(this.methodExecutionHandler));
        this.mockup = enhancer.create();
        return this.mockup;
    }

    @Override
    public XMLStreamReader invokeWsdlOperation(XMLStreamReader input, String wsdlId, String operationName) {
        return this.getMethodExecutionHandler().invokeWSDLOperation(input, wsdlId, operationName);
    }

    @Override
    public XMLStreamReader invokeWsdlOperation(XMLStreamReader input, String operationName) {
        return this.invokeWsdlOperation(input, null, operationName);
    }

    @Override
    public Collection<?> runPaginatedMethod(String camelisedMethodName, Object[] args) throws Throwable {
        Collection ret;
        Method method = this.getMethodByName(camelisedMethodName);
        if (method == null) {
            throw new RuntimeException("No such method: " + camelisedMethodName + ". Please specify the method name as defined in the connector class.");
        }
        try {
            ret = (Collection)this.methodExecutionHandler.execute(method, args);
        }
        catch (Throwable e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                throw cause;
            }
            throw e;
        }
        return ret;
    }

    @Override
    public Result<List<MetaDataKey>> fetchMetaDataKeys() {
        return this.getMethodExecutionHandler().fetchMetaDataKeys();
    }

    @Override
    public Result<MetaData> fetchMetaData(MetaDataKey key) {
        return this.getMethodExecutionHandler().fetchMetaData(key);
    }

    protected static String getConnectorPath() {
        return System.getProperty("user.dir");
    }

    private Method getMethodByName(String camelisedMethodName) {
        Method[] methods;
        for (Method m : methods = this.connectorClass.getMethods()) {
            if (!m.getName().equals(camelisedMethodName)) continue;
            return m;
        }
        return null;
    }
}

