/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.junit;

import org.apache.log4j.Logger;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mule.tools.devkit.ctf.configuration.ConfigurationManager;
import org.mule.tools.devkit.ctf.configuration.DeploymentProfiles;
import org.mule.tools.devkit.ctf.junit.MinMuleRuntime;
import org.mule.tools.devkit.ctf.packager.PackagerUtils;

public class MinMuleRuntimeTestRule
implements TestRule {
    private static final Logger logger = Logger.getLogger(MinMuleRuntimeTestRule.class);

    public Statement apply(Statement statement, Description description) {
        MinMuleRuntime requiredMuleRuntimeAnnotation = (MinMuleRuntime)description.getAnnotation(MinMuleRuntime.class);
        if (requiredMuleRuntimeAnnotation == null) {
            return statement;
        }
        boolean local = DeploymentProfiles.local.toString().equals(System.getProperty("deploymentprofile"));
        if (!local) {
            return statement;
        }
        String minMuleRuntime = requiredMuleRuntimeAnnotation.minversion();
        if (minMuleRuntime == null || minMuleRuntime.equals("") || !minMuleRuntime.startsWith("mule")) {
            logger.trace((Object)"Test annotated with @RequiredMuleRuntime but missing runtime value as (runtime=muleXY). Executing test", null);
            return statement;
        }
        String muleVersion = ConfigurationManager.autoDetectVersion(System.getProperty("muledirectory"));
        if (PackagerUtils.isRequiredMuleRuntimeRightForMuleVersion(minMuleRuntime, muleVersion)) {
            return statement;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
            }
        };
    }
}

