/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.junit;

import org.apache.log4j.Logger;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mule.tools.devkit.ctf.configuration.ConfigurationManager;
import org.mule.tools.devkit.ctf.configuration.DeploymentProfiles;
import org.mule.tools.devkit.ctf.exceptions.WrongPomVersionRuntimeException;
import org.mule.tools.devkit.ctf.junit.MetaDataTest;
import org.mule.tools.devkit.ctf.packager.PackagerUtils;

public class MetaDataTestRule
implements TestRule {
    private static final Logger logger = Logger.getLogger(MetaDataTestRule.class);

    public Statement apply(Statement statement, Description description) {
        MetaDataTest datasenseAnnotation = (MetaDataTest)description.getAnnotation(MetaDataTest.class);
        if (datasenseAnnotation == null) {
            return statement;
        }
        String connectorPath = System.getProperty("user.dir");
        try {
            String muleVersion;
            boolean local = DeploymentProfiles.local.toString().equals(System.getProperty("deploymentprofile"));
            if (!local) {
                return statement;
            }
            String connectorVersion = PackagerUtils.getConnectorDevkitVersion(connectorPath);
            if (PackagerUtils.isConnectorVersionRightForMuleVersion(connectorVersion, muleVersion = ConfigurationManager.autoDetectVersion(System.getProperty("muledirectory")))) {
                return statement;
            }
            return new Statement(){

                public void evaluate() throws Throwable {
                }
            };
        }
        catch (WrongPomVersionRuntimeException e) {
            logger.trace((Object)"Can not detect DevKit Parent version from POM", (Throwable)e);
            return statement;
        }
    }
}

