/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.junit;

import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.mule.tools.devkit.ctf.junit.MetaDataTestRule;
import org.mule.tools.devkit.ctf.junit.MinMuleRuntimeTestRule;
import org.mule.tools.devkit.ctf.mockup.ConnectorDispatcher;
import org.mule.tools.devkit.ctf.mockup.ConnectorTestContext;

public abstract class AbstractTestCase<T> {
    private Class<T> connectorClass;
    private T connector;
    private ConnectorDispatcher<T> dispatcher;
    @Rule
    public TestRule metadataRule = new MetaDataTestRule();
    @Rule
    public TestRule minMuleRuntime = new MinMuleRuntimeTestRule();

    protected T getConnector() {
        return this.connector;
    }

    protected ConnectorDispatcher<T> getDispatcher() {
        return this.dispatcher;
    }

    protected void setConnectorClass(Class<T> connectorClass) {
        this.connectorClass = connectorClass;
    }

    @Before
    public void init() throws Exception {
        if (this.connectorClass == null) {
            throw new RuntimeException("ConnectorClass not defined. Please use setConnectorClass.");
        }
        ConnectorTestContext.initialize(this.connectorClass, false);
        ConnectorTestContext context = ConnectorTestContext.getInstance();
        this.dispatcher = context.getConnectorDispatcher();
        this.connector = this.dispatcher.createMockup();
    }

    @After
    public void shutdown() throws Exception {
        ConnectorTestContext.shutDown(false);
    }
}

