/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.handlers;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;
import org.mule.common.Result;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.streaming.PagingConfiguration;
import org.mule.tools.devkit.ctf.configuration.ConfigurationManager;
import org.mule.tools.devkit.ctf.exceptions.MethodExecutionFailedException;
import org.mule.tools.devkit.ctf.flows.AnnotationsParser;
import org.mule.tools.devkit.ctf.flows.MethodDescriptor;
import org.mule.tools.devkit.ctf.flows.MuleFlowsGenerator;
import org.mule.tools.devkit.ctf.flows.SchemaAnalyser;
import org.mule.tools.devkit.ctf.platform.PlatformHookPoint;
import org.mule.tools.devkit.ctf.serialization.RPCSerializationUtils;

public abstract class MethodExecutionHandler<T>
implements PlatformHookPoint {
    protected Class<T> connectorClass;
    protected String connectorPath;
    protected MuleFlowsGenerator muleFlowGenerator;
    protected ConfigurationManager configManager;
    private static final Logger logger = Logger.getLogger(MethodExecutionHandler.class);

    public abstract Result<List<MetaDataKey>> fetchMetaDataKeys();

    public abstract Map<MetaDataKey, Result<MetaData>> fetchAllMetaData();

    public abstract Result<MetaData> fetchMetaData(MetaDataKey var1);

    public abstract XMLStreamReader runWSDLOperation(XMLStreamReader var1, String var2);

    public MethodExecutionHandler(Class<T> connectorClass, String connectorPath, ConfigurationManager configManager) {
        this.connectorClass = connectorClass;
        this.configManager = configManager;
        this.connectorPath = connectorPath;
        logger.setLevel(configManager.getLoggingLevel());
    }

    public XMLStreamReader invokeWSDLOperation(XMLStreamReader input, String wsdlId, String operationName) {
        SchemaAnalyser schemaAnalyser = this.getMuleFlowGenerator().getSchemaAnalyser();
        if (!schemaAnalyser.isWSDLConnectorEnabled()) {
            throw new MethodExecutionFailedException("Your connector is not WSDL-enabled. You can not invoke this operation.");
        }
        if (schemaAnalyser.isMultipleServiceDefinitionsDetected() && wsdlId == null) {
            throw new MethodExecutionFailedException("You need to specify a WSDL ID, since your connector has multiple service definition files. Please use invokeWSDLOperation(XMLStreamReader input, String WSDL_ID, String Operation) instead");
        }
        String param = wsdlId != null ? wsdlId + this.getMuleFlowGenerator().getSchemaAnalyser().getKeySeparator() + operationName : operationName;
        return this.runWSDLOperation(input, param);
    }

    public Object execute(Method method, Object[] args) throws Throwable {
        logger.debug((Object)("Executing method: " + method.getName()));
        return this.executeMethod(method, this.checkForPagingConfiguration(method, args));
    }

    protected abstract Object executeMethod(Method var1, Object[] var2) throws Throwable;

    public MuleFlowsGenerator getMuleFlowGenerator() {
        return this.muleFlowGenerator;
    }

    protected Object[] checkForPagingConfiguration(Method method, Object[] args) throws NoSuchMethodException {
        String methodName = RPCSerializationUtils.getUnCamel((String)method.getName());
        boolean pagedAnnotationPresent = this.muleFlowGenerator.getAnnotationParser().getAnnotations(methodName).contains((Object)AnnotationsParser.ProcessorsAnnotations.PAGED);
        if (!pagedAnnotationPresent) {
            return args;
        }
        PagingConfiguration pagingConfiguration = null;
        for (Object obj : args) {
            if (!(obj instanceof PagingConfiguration)) continue;
            pagingConfiguration = (PagingConfiguration)obj;
        }
        int fecthSize = 100;
        if (pagingConfiguration != null && pagingConfiguration.getFetchSize() > 0) {
            fecthSize = pagingConfiguration.getFetchSize();
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        MethodDescriptor md = this.muleFlowGenerator.getMethodDescriptor(methodName);
        List<String> methodSignature = md.getSignature();
        int paramCounter = 0;
        for (Object obj : args) {
            if (methodSignature.get(paramCounter++).equals("FetchSize")) {
                ret.add(fecthSize);
                continue;
            }
            ret.add(obj);
        }
        return ret.toArray();
    }
}

