/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.flows;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.jetbrains.annotations.NotNull;
import org.mockito.asm.ClassReader;
import org.mockito.asm.ClassVisitor;
import org.mockito.asm.tree.ClassNode;
import org.mockito.asm.tree.LocalVariableNode;
import org.mockito.asm.tree.MethodNode;
import org.mule.tools.devkit.Field;
import org.mule.tools.devkit.XsdSampleGenerator;
import org.mule.tools.devkit.ctf.configuration.ConfigurationManager;
import org.mule.tools.devkit.ctf.configuration.TestingProperties;
import org.mule.tools.devkit.ctf.exceptions.ASMClassLoaderRuntimeException;
import org.mule.tools.devkit.ctf.exceptions.AnnotationProcessorException;
import org.mule.tools.devkit.ctf.exceptions.CTFUtilsException;
import org.mule.tools.devkit.ctf.exceptions.ConfigurationLoadingFailedException;
import org.mule.tools.devkit.ctf.exceptions.ConfigurationPropertyException;
import org.mule.tools.devkit.ctf.exceptions.ConnectorPackagingFailedException;
import org.mule.tools.devkit.ctf.exceptions.FlowsGenerationFailedException;
import org.mule.tools.devkit.ctf.exceptions.MavenInvokerRuntimeException;
import org.mule.tools.devkit.ctf.exceptions.MuleAppGenerationFailedException;
import org.mule.tools.devkit.ctf.exceptions.SchemaAnalyserException;
import org.mule.tools.devkit.ctf.exceptions.TestsConfigurationPropertiesFileNotFoundException;
import org.mule.tools.devkit.ctf.flows.AnnotationsParser;
import org.mule.tools.devkit.ctf.flows.MethodDescriptor;
import org.mule.tools.devkit.ctf.flows.MuleMethods;
import org.mule.tools.devkit.ctf.flows.SchemaAnalyser;
import org.mule.tools.devkit.ctf.packager.PackagerUtils;
import org.mule.tools.devkit.ctf.serialization.RPCSerializationUtils;
import org.mule.tools.devkit.ctf.utils.CTFFileUtils;
import org.objectweb.asm.Type;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class MuleFlowsGenerator {
    protected Map<String, MethodDescriptor> availableMethods = new HashMap<String, MethodDescriptor>();
    protected XsdSampleGenerator flowGenerator = new XsdSampleGenerator();
    protected ConfigurationManager configManager;
    protected AnnotationsParser annotationParser;
    protected SchemaAnalyser schemaAnalyser;
    protected Class<?> connectorClass;
    private static final Logger logger = Logger.getLogger(MuleFlowsGenerator.class);
    private List<String> processorsNameWhiteList;

    public MuleFlowsGenerator(@NotNull ConfigurationManager configManager, @NotNull Class<?> connectorClass) {
        this.configManager = configManager;
        this.connectorClass = connectorClass;
        this.processorsNameWhiteList = new ArrayList<String>();
        this.processorsNameWhiteList.add("invoke");
        logger.setLevel(configManager.getLoggingLevel());
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configManager;
    }

    protected abstract void completeHeaders(@NotNull Document var1) throws FlowsGenerationFailedException;

    protected abstract void completeFlows(@NotNull Document var1, String var2) throws TestsConfigurationPropertiesFileNotFoundException, ConfigurationLoadingFailedException;

    protected abstract boolean resourcesAvailable(@NotNull String var1);

    protected boolean completeWSDLFlow(@NotNull Document workingDocument, @NotNull Node firstProcessorNode) {
        boolean flowCompleted = false;
        if (this.schemaAnalyser.isWSDLConnectorEnabled()) {
            Node invokeProcessor = firstProcessorNode.getNextSibling();
            Attr type = workingDocument.createAttribute("type");
            type.setValue("#[flowVars.operation]");
            invokeProcessor.getAttributes().setNamedItem(type);
            flowCompleted = true;
        }
        return flowCompleted;
    }

    public String generateFlows(@NotNull String connectorName, @NotNull String connectorPath, @NotNull String functionalTestingPath) throws FlowsGenerationFailedException {
        String annotationsFileName;
        String xsdFileName;
        logger.debug((Object)("Generation Mule flows for connector within path: " + connectorPath));
        String forceCompiling = this.configManager.getProperties().getProperty(TestingProperties.FORCECOMPILING);
        if (Boolean.valueOf(forceCompiling).booleanValue() || !this.resourcesAvailable(connectorPath)) {
            try {
                this.packageConnector(connectorPath);
            }
            catch (ConnectorPackagingFailedException e) {
                throw new FlowsGenerationFailedException("Failed to package connector when generating flows", e);
            }
        }
        String xsdFilePath = connectorPath + "/target/generated-sources/mule/META-INF";
        try {
            xsdFileName = CTFFileUtils.getFile(xsdFilePath, "mule-", "xsd");
        }
        catch (CTFUtilsException e) {
            throw new FlowsGenerationFailedException("Can not access XSD connector file", e);
        }
        String xsdFile = xsdFilePath + "/" + xsdFileName;
        String annotationsFilePath = connectorPath + "/target/generated-sources/apt";
        try {
            annotationsFileName = CTFFileUtils.getFile(annotationsFilePath, "testdata-annotations-output", "xml");
        }
        catch (CTFUtilsException e) {
            throw new FlowsGenerationFailedException("Can not access testdata-annotations-output file", e);
        }
        String annotationFile = annotationsFilePath + "/" + annotationsFileName;
        String generatedXML = functionalTestingPath + "/" + connectorName + ".flows.xml";
        try {
            this.flowGenerator.generateFlows(xsdFile, generatedXML, true);
        }
        catch (Exception e) {
            throw new FlowsGenerationFailedException("Can not generate flows", e);
        }
        this.annotationParser = new AnnotationsParser(annotationFile);
        try {
            this.annotationParser.init();
        }
        catch (AnnotationProcessorException e) {
            throw new FlowsGenerationFailedException("Can not initialize Annotation Parser", e);
        }
        String editorsFile = connectorPath + "/target/generated-sources/mule/" + this.annotationParser.getConnectorNamespace() + "/editors.xml";
        this.schemaAnalyser = new SchemaAnalyser(xsdFile, editorsFile, this.configManager.getLoggingLevel());
        try {
            this.schemaAnalyser.init();
        }
        catch (SchemaAnalyserException e) {
            throw new FlowsGenerationFailedException("Can not initialize Schema Analyser", e);
        }
        Document xmlDoc = null;
        try {
            xmlDoc = CTFFileUtils.openXML(generatedXML);
        }
        catch (CTFUtilsException e) {
            throw new FlowsGenerationFailedException("Can not open generated flows file", e);
        }
        Document workingDocument = null;
        try {
            workingDocument = this.cloneXMlStructure(xmlDoc);
        }
        catch (ParserConfigurationException e) {
            throw new FlowsGenerationFailedException("Can not clone flows file", e);
        }
        this.removeAutogeneratedFlows(xmlDoc, workingDocument);
        try {
            this.completeFlows(workingDocument, connectorName);
        }
        catch (ConfigurationLoadingFailedException | TestsConfigurationPropertiesFileNotFoundException e) {
            throw new FlowsGenerationFailedException("Can not complete flows file", e);
        }
        this.completeHeaders(workingDocument);
        try {
            this.completeConfigurations(workingDocument);
        }
        catch (ConfigurationLoadingFailedException | ConfigurationPropertyException | TestsConfigurationPropertiesFileNotFoundException e) {
            throw new FlowsGenerationFailedException("Failed to complete headers when generating flows", e);
        }
        try {
            CTFFileUtils.closeXML(workingDocument, generatedXML);
        }
        catch (CTFUtilsException e) {
            throw new FlowsGenerationFailedException("Can not close  generated flows file", e);
        }
        try {
            for (String processor : this.annotationParser.getProcessors()) {
                List<AnnotationsParser.ProcessorsAnnotations> annotations = this.annotationParser.getAnnotations(processor);
                MethodDescriptor md = new MethodDescriptor(processor, annotations, MuleMethods.PROCESSOR, this.getMethodSignature(processor));
                this.availableMethods.put(processor, md);
            }
        }
        catch (MuleAppGenerationFailedException e) {
            throw new FlowsGenerationFailedException("Can not load available connector methods", e);
        }
        logger.debug((Object)"Generation Mule flows complete");
        return generatedXML;
    }

    private List<String> getMethodSignature(String processor) throws MuleAppGenerationFailedException {
        Map<String, String> params;
        ArrayList<String> ret = new ArrayList<String>();
        String processorName = RPCSerializationUtils.getCamel((String)processor);
        try {
            params = this.getParameterNames(processorName);
        }
        catch (IOException e) {
            throw new MuleAppGenerationFailedException("Can not access connectors parameters through bytecode", e);
        }
        List xsdParamlist = null;
        try {
            String processorCustomName = RPCSerializationUtils.getFlowLikeCamel((String)processor) + "Type";
            xsdParamlist = this.flowGenerator.getParameters(processorCustomName);
        }
        catch (XPathExpressionException e) {
            throw new MuleAppGenerationFailedException("Can not get connector paramenters for " + processor, e);
        }
        if (params == null) {
            throw new MuleAppGenerationFailedException("Could not determine parameters for operation: " + processor + ". It seems to be an inconsistency between the connector source code and the generated resources. Please try to run mvn clean", null);
        }
        for (String param : params.keySet()) {
            String type = params.get(param);
            if (type.equals("Lorg/mule/api/MuleEvent;")) {
                logger.warn((Object)("Processor: " + processor + " has a Mule event in its signature. Mule events are injected by the Mule environment and therefore your Mule event object is discarded."));
                continue;
            }
            String paramName = this.getParamNameAccordingToType(param, type, xsdParamlist);
            if (paramName == null) {
                if (param.equals("payload")) {
                    logger.warn((Object)("Assuming param: " + param + " of type: " + type + " as annotated with @Payload."));
                    paramName = "__payload_";
                } else {
                    logger.warn((Object)("Argument: " + param + " of type: " + type + " could not be resolved for processor: " + processor + ". If is annotated with @Payload please named it as payload and not: " + param + " and use -Dforcecompiling=true next time."));
                    continue;
                }
            }
            ret.add(paramName);
        }
        return ret;
    }

    private String getParamNameAccordingToType(@NotNull String param, @NotNull String type, @NotNull List<Field> xsdParamlist) {
        if (type.equals("Lorg/mule/streaming/PagingConfiguration;")) {
            return "FetchSize";
        }
        if (xsdParamlist.isEmpty()) {
            return param;
        }
        String paramUnCamel = RPCSerializationUtils.getUnCamel((String)param);
        for (Field p : xsdParamlist) {
            String fieldNameUnCamel = RPCSerializationUtils.getUnCamel((String)p.getName());
            if (!fieldNameUnCamel.equals(paramUnCamel) && !fieldNameUnCamel.equals(paramUnCamel + "-ref")) continue;
            if (!p.getType().equals("pojo")) {
                return param;
            }
            return param + "Ref";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getParameterNames(@NotNull String methodName) throws IOException {
        ClassNode classNode;
        ClassLoader declaringClassLoader = this.connectorClass.getClassLoader();
        Method[] availableMethodsList = this.connectorClass.getMethods();
        Method targetMethod = null;
        for (Method m : availableMethodsList) {
            if (!m.getName().equals(methodName)) continue;
            targetMethod = m;
        }
        if (targetMethod == null) {
            return null;
        }
        Type declaringType = Type.getType(this.connectorClass);
        String url = declaringType.getInternalName() + ".class";
        InputStream classFileInputStream = declaringClassLoader.getResourceAsStream(url);
        if (classFileInputStream == null) {
            throw new IllegalArgumentException("The constructor's class loader cannot find the bytecode that defined the constructor's class (URL: " + url + "). In other words, you are doomed mate.");
        }
        try {
            classNode = new ClassNode();
            ClassReader classReader = new ClassReader(classFileInputStream);
            classReader.accept((ClassVisitor)classNode, 0);
        }
        finally {
            classFileInputStream.close();
        }
        List methods = classNode.methods;
        for (MethodNode method : methods) {
            if (!method.name.equals(methodName)) continue;
            Type[] argumentTypes = Type.getArgumentTypes((String)method.desc);
            LinkedHashMap<String, String> parameterNames = new LinkedHashMap<String, String>(argumentTypes.length);
            List localVariables = method.localVariables;
            for (int i = 0; i < argumentTypes.length; ++i) {
                parameterNames.put(this.getLocalVariableByIndex((List<LocalVariableNode>)localVariables, (int)(i + 1)).name, Type.getType((String)argumentTypes[i].toString()).toString());
            }
            return parameterNames;
        }
        return null;
    }

    private LocalVariableNode getLocalVariableByIndex(@NotNull List<LocalVariableNode> localVariables, int index) {
        for (LocalVariableNode node : localVariables) {
            if (node.index != index) continue;
            return node;
        }
        throw new ASMClassLoaderRuntimeException("Failed to load method local variables using: method.localVariables. Problem with ClassLoader.", null);
    }

    public MethodDescriptor getMethodDescriptor(@NotNull String methodName) throws NoSuchMethodException {
        MethodDescriptor ret = this.availableMethods.get(methodName);
        if (ret == null) {
            throw new NoSuchMethodException("No such method: " + methodName);
        }
        return ret;
    }

    private Document cloneXMlStructure(Document xmlDoc) throws ParserConfigurationException {
        NodeList root = xmlDoc.getElementsByTagName("mule");
        Element mule = (Element)root.item(0);
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document ret = docBuilder.newDocument();
        Node newMule = mule.cloneNode(false);
        ret.adoptNode(newMule);
        ret.appendChild(newMule);
        return ret;
    }

    private void removeAutogeneratedFlows(Document source, Document workingDocument) {
        List<String> validProcessors = this.annotationParser.getProcessors();
        NodeList flows = source.getElementsByTagName("flow");
        for (int i = 0; i < flows.getLength(); ++i) {
            Node flow = flows.item(i);
            NamedNodeMap map = flow.getAttributes();
            String name = map.getNamedItem("name").getNodeValue();
            if (!validProcessors.contains(name) && !this.processorsNameWhiteList.contains(name)) continue;
            Node newNode = flow.cloneNode(true);
            workingDocument.adoptNode(newNode);
            workingDocument.getDocumentElement().appendChild(newNode);
        }
    }

    private void completeConfigurations(Document workingDocument) throws TestsConfigurationPropertiesFileNotFoundException, ConfigurationLoadingFailedException, ConfigurationPropertyException {
        NodeList root = workingDocument.getElementsByTagName("mule");
        Element mule = (Element)root.item(0);
        NodeList flows = workingDocument.getElementsByTagName("flow");
        Element firstFlow = (Element)flows.item(0);
        Element propertyPlaceholder = workingDocument.createElement("context:property-placeholder");
        String configurationsFileName = this.configManager.getProperties().getProperty(TestingProperties.CONFIGURATIONSFILE);
        propertyPlaceholder.setAttribute("location", configurationsFileName);
        propertyPlaceholder.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        mule.insertBefore(propertyPlaceholder, firstFlow);
        String connectorNamespace = this.annotationParser.getConnectorNamespace();
        String configurationName = this.configManager.getProperties().getProperty(TestingProperties.ACTIVECONFIGURATION);
        Element configuration = workingDocument.createElement(connectorNamespace + ":" + configurationName);
        Map<String, String> placeholders = this.configManager.getConnectionConfigurationPlaceholders();
        for (String placeholder : placeholders.keySet()) {
            configuration.setAttribute(placeholder, "${" + configurationName + "." + placeholder + "}");
        }
        configuration.setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        Map<String, String> listParameters = this.configManager.getConnectionConfigurationListProperties();
        for (String listParameter : listParameters.keySet()) {
            Element list = workingDocument.createElement(connectorNamespace + ":" + RPCSerializationUtils.getUnCamel((String)listParameter));
            ArrayList<String> values = new ArrayList<String>(Arrays.asList(listParameters.get(listParameter).split(",")));
            for (String val : values) {
                Element listVal = workingDocument.createElement(connectorNamespace + ":" + RPCSerializationUtils.getUnCamel((String)listParameter));
                listVal.appendChild(workingDocument.createTextNode(val.trim()));
                list.appendChild(listVal);
            }
            configuration.appendChild(list);
        }
        configuration.setAttribute("doc:name", configurationName);
        configuration.setAttribute("name", configurationName);
        mule.insertBefore(configuration, firstFlow);
        NodeList all = workingDocument.getElementsByTagName("*");
        for (int j = 0; j < all.getLength(); ++j) {
            Node current = all.item(j);
            NamedNodeMap attrs = current.getAttributes();
            Node config = attrs.getNamedItem("config-ref");
            if (config != null) {
                config.setNodeValue(this.configManager.getProperties().getProperty(TestingProperties.ACTIVECONFIGURATION));
            }
            ((Element)current).setAttribute("xmlns", "http://www.mulesoft.org/schema/mule/core");
        }
    }

    private void packageConnector(@NotNull String connectorPath) throws ConnectorPackagingFailedException {
        List<String> goals = Arrays.asList("package", "-Ptestdata-generator", "-DskipTests");
        String javaHome = this.configManager.getProperties().getProperty(TestingProperties.CUSTOMJAVAHOME);
        String m2home = this.configManager.getProperties().getProperty(TestingProperties.M2HOME);
        if (m2home == null) {
            throw new ConnectorPackagingFailedException("Your M2Home is not set.", null);
        }
        MuleFlowsGenerator.mavenRunnerInvoker(connectorPath, goals, m2home, javaHome, this.configManager);
    }

    private static List<String> getMavenSettingsProperties(@NotNull ConfigurationManager configManager) {
        ArrayList<String> goals = new ArrayList<String>();
        String mavenSettingProperty = null;
        String mavenGlobalSettingProperty = null;
        String injectProperties = null;
        mavenSettingProperty = configManager.getProperties().getProperty(TestingProperties.MAVENSETTINSGFILE);
        if (mavenSettingProperty != null && !mavenSettingProperty.equals("Default Maven Settings File")) {
            goals.add("-s " + mavenSettingProperty);
        }
        if ((mavenGlobalSettingProperty = configManager.getProperties().getProperty(TestingProperties.MAVENGLOBALSETTINSGFILE)) != null && !mavenGlobalSettingProperty.equals("Default Maven Global Settings File")) {
            goals.add("-gs " + mavenGlobalSettingProperty);
        }
        if ((injectProperties = configManager.getProperties().getProperty(TestingProperties.INJECTPROPERTIES)) != null && !injectProperties.equals("No Properties to Inject")) {
            goals.add(" " + injectProperties);
        }
        return goals;
    }

    public static void mavenRunnerInvoker(String connectorPath, List<String> goals, String m2home, String javaHome, ConfigurationManager configManager) {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        if (connectorPath != null) {
            request.setPomFile(new File(connectorPath + "/pom.xml"));
        }
        if (configManager != null) {
            List<String> mavenSettings = MuleFlowsGenerator.getMavenSettingsProperties(configManager);
            mavenSettings.addAll(0, goals);
            request.setGoals(mavenSettings);
        } else {
            request.setGoals(goals);
        }
        String jHome = javaHome == null ? MuleFlowsGenerator.getCurrentJavaHome() : javaHome;
        if (jHome != null) {
            request.setJavaHome(new File(jHome));
        }
        DefaultInvoker invoker = new DefaultInvoker();
        invoker.setMavenHome(new File(m2home));
        InvocationResult result = null;
        logger.debug((Object)("Maven invoker goals: " + request.getGoals() + ". Maven home: " + m2home + ". Connector path: " + connectorPath));
        try {
            result = invoker.execute((InvocationRequest)request);
            if (result.getExitCode() != 0) {
                if (result.getExecutionException() != null) {
                    throw result.getExecutionException();
                }
                throw new MavenInvokerRuntimeException("Failed to run Maven Invoker. ResultException is null. No more information about the exception.", null);
            }
        }
        catch (Exception e) {
            String msg = "";
            if (SystemUtils.IS_OS_WINDOWS) {
                msg = "If mvn.bat was not found within your Maven installation folder, you might rename it from mvn.cmd to mvn.bat";
            }
            throw new MavenInvokerRuntimeException(msg, e);
        }
    }

    private static String getCurrentJavaHome() {
        return System.getProperty("java.home");
    }

    public AnnotationsParser getAnnotationParser() {
        return this.annotationParser;
    }

    public SchemaAnalyser getSchemaAnalyser() {
        return this.schemaAnalyser;
    }

    protected boolean isXSDAvailable(@NotNull String connectorPath) {
        boolean ret = true;
        String generated = connectorPath + "/target/generated-sources/mule/META-INF";
        try {
            CTFFileUtils.getFile(generated, "mule-", "xsd");
        }
        catch (CTFUtilsException e) {
            logger.trace((Object)("XSD file not available at " + generated), (Throwable)e);
            ret = false;
        }
        return ret;
    }

    protected boolean isZIPAvailable(@NotNull String connectorPath) {
        boolean ret = true;
        String zipFilePath = connectorPath + "/target";
        try {
            String artifactID = PackagerUtils.getArtifactID(connectorPath);
            CTFFileUtils.getFile(zipFilePath, artifactID, "zip");
        }
        catch (CTFUtilsException e) {
            logger.trace((Object)("ZIP file not available at " + zipFilePath), (Throwable)e);
            ret = false;
        }
        return ret;
    }

    protected boolean isXMLAvailable(@NotNull String connectorPath) {
        boolean ret = true;
        String annotationsFilePath = connectorPath + "/target/generated-sources/apt";
        try {
            CTFFileUtils.getFile(annotationsFilePath, "testdata-annotations-output", "xml");
        }
        catch (CTFUtilsException e) {
            logger.trace((Object)("Testdata annotation output file not available at " + annotationsFilePath), (Throwable)e);
            ret = false;
        }
        return ret;
    }
}

