/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.flows;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.tools.devkit.ctf.exceptions.AnnotationProcessorException;
import org.mule.tools.devkit.ctf.exceptions.CTFUtilsException;
import org.mule.tools.devkit.ctf.utils.CTFFileUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class AnnotationsParser {
    private Map<String, List<ProcessorsAnnotations>> annotations = new HashMap<String, List<ProcessorsAnnotations>>();
    private String connectorNamespace;
    private String annotationFile;

    public AnnotationsParser(String annotationFile) {
        this.annotationFile = annotationFile;
    }

    public List<ProcessorsAnnotations> getAnnotations(String processorName) {
        return this.annotations.get(processorName);
    }

    public List<String> getProcessors() {
        return new ArrayList<String>(this.annotations.keySet());
    }

    public void init() throws AnnotationProcessorException {
        try {
            Document xmlDoc = CTFFileUtils.openXML(this.annotationFile);
            this.connectorNamespace = this.resolveConnectorNamespace(xmlDoc);
            this.annotations = this.getConnectorAnnotations(xmlDoc);
        }
        catch (CTFUtilsException | DOMException e) {
            throw new AnnotationProcessorException("Can not initialize Annotation Parser", e);
        }
    }

    private Map<String, List<ProcessorsAnnotations>> getConnectorAnnotations(Document xmlDoc) {
        HashMap<String, List<ProcessorsAnnotations>> ret = new HashMap<String, List<ProcessorsAnnotations>>();
        NodeList processors = xmlDoc.getElementsByTagName("processor");
        for (int i = 0; i < processors.getLength(); ++i) {
            Node item = processors.item(i);
            NamedNodeMap map = item.getAttributes();
            String processorName = map.getNamedItem("xmlName").getNodeValue();
            NodeList list = item.getChildNodes();
            ArrayList<ProcessorsAnnotations> currentAnnotations = new ArrayList<ProcessorsAnnotations>();
            for (int j = 0; j < list.getLength(); ++j) {
                Node node = list.item(j);
                if (node.getNodeType() != 1) continue;
                Element elem = (Element)node;
                if (elem.getNodeName().equals("auto-paging") && elem.getTextContent().equals("true")) {
                    currentAnnotations.add(ProcessorsAnnotations.PAGED);
                }
                if (!elem.getNodeName().equals("query-support") || !elem.getTextContent().equals("true")) continue;
                currentAnnotations.add(ProcessorsAnnotations.QUERY);
            }
            ret.put(processorName, currentAnnotations);
        }
        return ret;
    }

    private String resolveConnectorNamespace(Document xmlDoc) throws AnnotationProcessorException {
        Node connector = xmlDoc.getElementsByTagName("connector").item(0);
        String ret = connector.getAttributes().getNamedItem("name").getNodeValue().replace("\"", "");
        if (ret == null || ret.equals("")) {
            throw new AnnotationProcessorException("Connector namespace is null or empty.", null);
        }
        return ret;
    }

    public String getConnectorNamespace() {
        return this.connectorNamespace;
    }

    public static enum ProcessorsAnnotations {
        PAGED,
        QUERY;

    }
}

