/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.deployer;

import org.jetbrains.annotations.NotNull;
import org.mule.tools.devkit.ctf.configuration.ConfigurationManager;
import org.mule.tools.devkit.ctf.configuration.DeploymentProfiles;
import org.mule.tools.devkit.ctf.deployer.CloudMuleManager;
import org.mule.tools.devkit.ctf.deployer.EmbeddedMuleManager;
import org.mule.tools.devkit.ctf.deployer.LocalMuleManager;
import org.mule.tools.devkit.ctf.deployer.MuleManager;
import org.mule.tools.devkit.ctf.deployer.RemoteMuleManager;
import org.mule.tools.devkit.ctf.exceptions.MuleManagerException;

public final class MuleManagerFactory {
    private MuleManagerFactory() {
    }

    public static MuleManager getMuleManager(@NotNull DeploymentProfiles profile, ConfigurationManager configManager) throws MuleManagerException {
        if (profile == null) {
            throw new MuleManagerException("Deployment profile can not be null", null);
        }
        switch (profile) {
            case embedded: {
                return new EmbeddedMuleManager();
            }
            case local: {
                return new LocalMuleManager(configManager);
            }
            case remote: {
                return new RemoteMuleManager();
            }
            case cloudhub: {
                return new CloudMuleManager();
            }
        }
        throw new MuleManagerException("Deployment profile: " + (Object)((Object)profile) + " not implemented. Stand by for updates mate.", null);
    }
}

