/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.deployer;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.mule.tools.devkit.ctf.configuration.ConfigurationManager;
import org.mule.tools.devkit.ctf.configuration.MuleVersions;
import org.mule.tools.devkit.ctf.configuration.TestingProperties;
import org.mule.tools.devkit.ctf.deployer.MuleManager;
import org.mule.tools.devkit.ctf.exceptions.MuleManagerException;
import org.mule.tools.devkit.ctf.exceptions.UnavailableLocalPortRuntimeException;

public final class LocalMuleManager
extends MuleManager {
    private String deployedMule;
    private String folderName;
    private ConfigurationManager configManager;
    private static final Logger logger = Logger.getLogger(ConfigurationManager.class);
    private Map<String, String> assignedPorts;
    private Process process;

    public LocalMuleManager(@NotNull ConfigurationManager configManager) throws MuleManagerException {
        this.configManager = configManager;
        this.assignedPorts = new HashMap<String, String>();
        if (configManager == null) {
            throw new MuleManagerException("Configuration manager can not be null", null);
        }
        logger.setLevel(configManager.getLoggingLevel());
    }

    @Override
    public void startMule(@NotNull String muleVersion) throws MuleManagerException {
        this.deployedMule = this.configManager.getProperties().getProperty(TestingProperties.MULEDIRECTORY);
        if (this.deployedMule == null) {
            throw new MuleManagerException("No Mule version selected.", null);
        }
        logger.debug((Object)("Starting local Mule version: " + muleVersion + " within Mule directory: " + this.deployedMule));
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                this.startMuleOnWindows(muleVersion);
            } else {
                this.startMuleOnUnix();
            }
        }
        catch (IOException e) {
            logger.trace((Object)("Could not start local Mule. Please check Mule installation at " + this.deployedMule), (Throwable)e);
            throw new MuleManagerException("Could not start local Mule. Please check Mule installation at " + this.deployedMule, e);
        }
        logger.debug((Object)("Starting local Mule version: " + muleVersion + " complete"));
    }

    private void startMuleOnUnix() throws IOException {
        String execCommand = "sh " + this.deployedMule + "/bin/mule";
        Runtime.getRuntime().exec(execCommand);
    }

    private void startMuleOnWindows(String muleVersion) throws IOException {
        this.process = new ProcessBuilder(this.deployedMule + "/bin/mule.bat").start();
        if (MuleVersions.mule35.toString().equals(muleVersion) || MuleVersions.mule37.toString().equals(muleVersion)) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(LocalMuleManager.this.process.getInputStream(), Charset.defaultCharset()));
                    try {
                        String line = reader.readLine();
                        while (line != null && !line.trim().equals("--EOF--")) {
                            logger.trace((Object)"Consuming buffer until EOF", null);
                            line = reader.readLine();
                        }
                        reader.close();
                    }
                    catch (IOException e) {
                        logger.trace((Object)"IOException in StartMuleOnWindows while consuming process buffer", (Throwable)e);
                    }
                }
            });
            thread.start();
        }
    }

    @Override
    public void shutdownMule() throws MuleManagerException {
        logger.debug((Object)("Shutting down Mule within Mule directory: " + this.deployedMule));
        if (SystemUtils.IS_OS_WINDOWS) {
            this.shutdownMuleOnWindows();
        } else {
            this.shutdownMuleOnUnix();
        }
        logger.debug((Object)"Shutting down Mule complete");
    }

    private void shutdownMuleOnUnix() throws MuleManagerException {
        try {
            String deleteCommand = "rm " + this.deployedMule + "/apps/" + this.folderName + "-anchor.txt";
            Runtime.getRuntime().exec(deleteCommand);
            String deleteFolder = "rm -r " + this.deployedMule + "/apps/" + this.folderName;
            Runtime.getRuntime().exec(deleteFolder);
            String execCommand = "sh " + this.deployedMule + "/bin/mule stop";
            Runtime.getRuntime().exec(execCommand);
        }
        catch (IOException e) {
            throw new MuleManagerException("Can not shutdown Mule on Unix", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownMuleOnWindows() throws MuleManagerException {
        try {
            FileUtils.deleteQuietly((File)new File(this.deployedMule + "/apps/" + this.folderName + "-anchor.txt"));
            this.waitOnUndeployApp(this.deployedMule + "/apps/" + this.folderName);
        }
        finally {
            try {
                Runtime.getRuntime().exec("cmd /c taskkill /f /t /pid " + this.windowsProcessId(this.process));
            }
            catch (IOException e) {
                logger.trace((Object)"Can not shutdown Mule on Windows", (Throwable)e);
            }
        }
    }

    @Override
    public void deployMuleApp(String generatedApp, String connectorClassName) throws MuleManagerException {
        logger.debug((Object)("Deploying local Mule app at localhost:" + this.getAssignedPort(connectorClassName)));
        this.folderName = "connectorApp";
        String anchorFile = this.copyFolder(generatedApp);
        try {
            this.waitOnApp(anchorFile);
        }
        catch (MuleManagerException e) {
            throw new MuleManagerException("Can not deploy Mule app", e);
        }
        logger.debug((Object)"Deploying local Mule app complete");
    }

    private void waitOnApp(String anchorFile) throws MuleManagerException {
        File file = new File(anchorFile);
        long startTime = System.currentTimeMillis();
        while (!file.exists()) {
            try {
                Thread.sleep(1000L);
                if (System.currentTimeMillis() - startTime <= 60000L) continue;
                throw new MuleManagerException("Could not deploy Mule App. You might manually deploy the Mule Environment to search for errors.", null);
            }
            catch (InterruptedException e) {
                logger.trace((Object)"Interrupt exception", (Throwable)e);
            }
        }
    }

    private void waitOnUndeployApp(String appFolder) throws MuleManagerException {
        File file = new File(appFolder);
        long startTime = System.currentTimeMillis();
        while (file.exists()) {
            try {
                Thread.sleep(1000L);
                if (System.currentTimeMillis() - startTime <= 60000L) continue;
                throw new MuleManagerException("Could not undeploy Mule App.", null);
            }
            catch (InterruptedException e) {
                logger.trace((Object)"Interrupt exception", (Throwable)e);
            }
        }
    }

    private Long windowsProcessId(Process process) throws MuleManagerException {
        if (process.getClass().getName().equals("java.lang.Win32Process") || process.getClass().getName().equals("java.lang.ProcessImpl")) {
            try {
                Field f = process.getClass().getDeclaredField("handle");
                f.setAccessible(true);
                long handl = f.getLong(process);
                Kernel32 kernel = Kernel32.INSTANCE;
                WinNT.HANDLE handle = new WinNT.HANDLE();
                handle.setPointer(Pointer.createConstant((long)handl));
                int ret = kernel.GetProcessId(handle);
                return ret;
            }
            catch (Exception e) {
                throw new MuleManagerException("Can not determine Windows Process ID", e);
            }
        }
        return null;
    }

    private String copyFolder(String generatedApp) throws MuleManagerException {
        String anchor = null;
        try {
            anchor = this.deployedMule + "/apps/" + this.folderName + "-anchor.txt";
            FileUtils.copyDirectory((File)new File(generatedApp), (File)new File(this.deployedMule + "/apps/" + this.folderName + "/"));
        }
        catch (IOException e) {
            throw new MuleManagerException("Can not copy folder", e);
        }
        return anchor;
    }

    @Override
    public String getMuleIPAddrees() {
        return "localhost";
    }

    @Override
    public String getAssignedPort(String connectorClass) {
        String ret = this.assignedPorts.get(connectorClass);
        if (ret == null) {
            ret = this.getLocalFreePort();
            this.assignedPorts.put(connectorClass, ret);
        }
        return ret;
    }

    private String getLocalFreePort() {
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(0);
            int availablePort = ss.getLocalPort();
            ss.setReuseAddress(true);
            ss.close();
            return String.valueOf(availablePort);
        }
        catch (IOException e) {
            throw new UnavailableLocalPortRuntimeException("Could not determine a free local port at localhost", e);
        }
    }
}

