/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.configuration;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.mule.tools.devkit.ConfigElement;
import org.mule.tools.devkit.XsdSampleGenerator;
import org.mule.tools.devkit.ctf.configuration.ConfigurationProperties;
import org.mule.tools.devkit.ctf.configuration.DeploymentProfiles;
import org.mule.tools.devkit.ctf.configuration.MuleVersions;
import org.mule.tools.devkit.ctf.configuration.TestingProperties;
import org.mule.tools.devkit.ctf.exceptions.CTFUtilsException;
import org.mule.tools.devkit.ctf.exceptions.ConfigurationLoadingFailedException;
import org.mule.tools.devkit.ctf.exceptions.ConfigurationPropertyException;
import org.mule.tools.devkit.ctf.exceptions.ConnectorPackagingFailedException;
import org.mule.tools.devkit.ctf.exceptions.MissingRequiredConfigurationAttributesException;
import org.mule.tools.devkit.ctf.flows.MuleFlowsGenerator;
import org.mule.tools.devkit.ctf.utils.CTFFileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ConfigurationManager {
    private static final Logger logger = Logger.getLogger(ConfigurationManager.class);
    private ConfigurationProperties properties;
    private Map<String, String> activeConfigurationProperties;
    private Map<String, String> activeConfigurationListProperties;
    private Map<String, String> requiredLibraries;
    private List<ConfigElement> availableConfigurations;
    private Level loggingLevel;
    private String connectorPath;

    public ConfigurationManager(ConfigurationProperties properties, Map<String, String> activeConfigurationProperties, Map<String, String> activeConfigurationListProperties, Map<String, String> requiredLibraries, Level loggingLevel, List<ConfigElement> availableConfigurations, String connectorPath) {
        this.loggingLevel = loggingLevel;
        this.properties = properties;
        this.activeConfigurationProperties = activeConfigurationProperties;
        this.activeConfigurationListProperties = activeConfigurationListProperties;
        this.requiredLibraries = requiredLibraries;
        this.availableConfigurations = availableConfigurations;
        this.connectorPath = connectorPath;
    }

    public ConfigurationManager(@NotNull String connectorPath) throws ConfigurationLoadingFailedException, ConfigurationPropertyException {
        this.connectorPath = connectorPath;
        this.loadFrameworkProperties();
        this.loadRequiredLibraries();
    }

    public Level getLoggingLevel() {
        return this.loggingLevel;
    }

    private void loadRequiredLibraries() throws ConfigurationLoadingFailedException {
        List<String> requiredJarsList;
        this.requiredLibraries = new HashMap<String, String>();
        String deploymentProfile = this.properties.getProperty(TestingProperties.DEPLOYMENTPROFILE);
        if (deploymentProfile != null && !deploymentProfile.equals(DeploymentProfiles.local.toString())) {
            return;
        }
        if (deploymentProfile == null) {
            return;
        }
        String requiredJarsPath = this.connectorPath + "/src/main/resources/META-INF";
        logger.debug((Object)("Required Jars Path: " + requiredJarsPath));
        try {
            String requiredJarsName = CTFFileUtils.getFileEndingWith(requiredJarsPath, "required-libs", "xml");
            String requiredJarsFile = requiredJarsPath + "/" + requiredJarsName;
            logger.debug((Object)("Required Jars File: " + requiredJarsFile));
            requiredJarsList = this.getNumberRequiredJars(requiredJarsFile);
        }
        catch (CTFUtilsException e) {
            logger.trace((Object)("File required-libraries.properties not found within: " + requiredJarsPath), (Throwable)e);
            logger.debug((Object)"No file was found, i.e. no required external jar");
            return;
        }
        String resourcePath = this.connectorPath + "/src/test/resources";
        String defaultFileName = "required-libraries.properties";
        String existingLibraryFile = resourcePath + "/" + defaultFileName;
        try {
            CTFFileUtils.getFileFullName(resourcePath, defaultFileName);
        }
        catch (CTFUtilsException e) {
            logger.trace((Object)("No required library file found within " + resourcePath), (Throwable)e);
            existingLibraryFile = null;
        }
        if (existingLibraryFile == null) {
            try {
                this.generateRequiredJarsFile(resourcePath, defaultFileName, requiredJarsList);
            }
            catch (ConnectorPackagingFailedException e) {
                throw new ConfigurationLoadingFailedException("", e);
            }
            logger.debug((Object)"Your connector requires external libraries and no proper configuration was set. A file has been created within src/test/resources. Please complete it accordingly.");
            throw new ConfigurationLoadingFailedException("Your connector requires external libraries and no proper configuration was set. A file has been created within src/test/resources. Please complete it accordingly.", null);
        }
        logger.debug((Object)"Loading required Jars.");
        this.loadRequiredJarsFromFile(resourcePath + "/" + defaultFileName);
        logger.debug((Object)"Loading required Jars complete.");
    }

    private void loadRequiredJarsFromFile(String filePath) throws ConfigurationLoadingFailedException {
        File configFile = new File(filePath);
        if (!configFile.exists()) {
            throw new ConfigurationLoadingFailedException(filePath + " file not found. Try running a mvn clean install on the project folder so as to generate test resources/classes.", null);
        }
        try {
            List<String> lines = Files.readAllLines(Paths.get(configFile.toURI()), Charset.defaultCharset());
            String jarName = null;
            for (String line : lines) {
                if (line.trim().equals("") || line.trim().startsWith("#")) continue;
                String currentLine = line.substring(0, line.indexOf("=")).trim();
                if (jarName == null && currentLine.equals("jar.name")) {
                    jarName = line.substring(line.indexOf("=") + 1, line.length()).trim();
                    continue;
                }
                if (jarName == null || !currentLine.equals("jar.location")) continue;
                String value = line.substring(line.indexOf("=") + 1, line.length()).trim();
                this.requiredLibraries.put(jarName, value);
                logger.debug((Object)("Loading require Jar: " + jarName + " with location: " + value));
                jarName = null;
            }
        }
        catch (Exception e) {
            throw new ConfigurationLoadingFailedException("Can not load required JARs", e);
        }
        if (this.requiredLibraries.isEmpty()) {
            throw new ConfigurationLoadingFailedException("It seems that your connector requires external jars, but your required-libraries.properties ( " + filePath + " ) file is not complete. Please complete it accordingly", null);
        }
    }

    private List<String> getNumberRequiredJars(@NotNull String requiredJarsFile) throws ConfigurationLoadingFailedException {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            Document doc = CTFFileUtils.openXML(requiredJarsFile);
            NodeList jars = doc.getElementsByTagName("jar");
            for (int i = 0; i < jars.getLength(); ++i) {
                Element jar = (Element)jars.item(i);
                ret.add(jar.getAttribute("name"));
            }
        }
        catch (CTFUtilsException e) {
            throw new ConfigurationLoadingFailedException("Can not parse required libs XML file", e);
        }
        return ret;
    }

    private void generateRequiredJarsFile(String resourcesPath, String requiredJarsPath, List<String> requiredJarList) throws ConnectorPackagingFailedException {
        try {
            PrintWriter writer = new PrintWriter(resourcesPath + "/" + requiredJarsPath, "UTF-8");
            writer.println("#");
            writer.println("# This is an auto-generated file based on the Connector Testing Framework.");
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss - dd/MM/yyyy");
            writer.println("# " + dateFormat.format(new Date()));
            writer.println("#");
            writer.println();
            writer.println("# You need to define the jar name and the local route of it. Please uncomment the lines and complete it accordingly.");
            writer.println("");
            for (String jar : requiredJarList) {
                writer.println("#Required Jars: " + jar);
                writer.println("#jar.name= (required)");
                writer.println("#jar.location= (required)");
                writer.println("");
            }
            writer.close();
        }
        catch (IOException e) {
            throw new ConnectorPackagingFailedException("Can not generate required properties file", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadFrameworkProperties() throws ConfigurationLoadingFailedException, ConfigurationPropertyException {
        String forceCompiling;
        String newLevel = System.getProperty("loggerlevel");
        if (newLevel != null) {
            this.loggingLevel = Level.toLevel((String)newLevel);
            logger.setLevel(this.loggingLevel);
            logger.debug((Object)("New Logger Level: " + newLevel));
        } else {
            this.loggingLevel = Level.INFO;
        }
        logger.debug((Object)"Loading Connector Testing Framework Properties.");
        this.properties = new ConfigurationProperties(this.loggingLevel);
        String m2Home = System.getProperty("m2home");
        String detectedM2Home = this.autoDetectM2Home();
        if (m2Home != null && m2Home.trim().equals("")) {
            m2Home = null;
        }
        if (m2Home == null && detectedM2Home != null) {
            m2Home = detectedM2Home;
            logger.warn((Object)("Detected M2 home: " + detectedM2Home + ". If this is incorrent, please specify it with -Dm2home=yourM2HOME (VM Arguments, System Properties or Maven Properties)."));
        }
        if (m2Home == null) {
            logger.error((Object)"No M2HOME was set and M2Home autodetection did not detect your M2 home. You can either set the M2HOME/M2_HOME environment variable or specify the System property with -Dm2home=yourM2Home (VM Arguments, System Properties or Maven Properties).");
            throw new ConfigurationLoadingFailedException("No M2HOME was set. You can either set the M2HOME/M2_HOME environment variable or specify it with -Dm2home=yourM2HOME (VM Arguments, System Properties or Maven Properties).", null);
        }
        this.properties.setProperty(TestingProperties.M2HOME, m2Home);
        String mavenLocalRepo = System.getProperty("mavenlocalrepo");
        String detectedMavenLocalRepo = this.autodetectMavenLocalRepo();
        if (mavenLocalRepo == null && detectedMavenLocalRepo != null) {
            mavenLocalRepo = detectedMavenLocalRepo;
        }
        if (mavenLocalRepo == null) {
            logger.error((Object)"No Maven Local Repository was set nor auto-detected was possible. Please specify it with -Dmavenlocalrepo=yourMavenLocalRepository (VM Arguments, System Properties or Maven Properties).");
            throw new ConfigurationLoadingFailedException("No Maven Local Repository was set nor auto-detected was possible. Please specify it with -DyourMavenLocalRepository=yourMavenLocalRepository (VM Arguments, System Properties or Maven Properties).", null);
        }
        this.properties.setProperty(TestingProperties.MAVENLOCALREPO, mavenLocalRepo);
        String mavenCMDLineArgs = System.getenv("MAVEN_CMD_LINE_ARGS");
        if (mavenCMDLineArgs == null) {
            logger.warn((Object)"MAVEN_CMD_LINE_ARGS not detected. No settings file will be injected.");
        } else {
            logger.debug((Object)("Maven Command Line: " + mavenCMDLineArgs));
        }
        String parsedMavenCommandLineGlobalSettingsFile = this.parseMavenLine(mavenCMDLineArgs, "-gs");
        if (parsedMavenCommandLineGlobalSettingsFile != null) {
            this.properties.setProperty(TestingProperties.MAVENGLOBALSETTINSGFILE, parsedMavenCommandLineGlobalSettingsFile);
            logger.debug((Object)("Using custom Maven global settings XML file: " + parsedMavenCommandLineGlobalSettingsFile));
        } else {
            this.properties.setProperty(TestingProperties.MAVENGLOBALSETTINSGFILE, "Default Maven Global Settings File");
        }
        String parsedMavenCommandLineSettingsFile = this.parseMavenLine(mavenCMDLineArgs, "-s");
        if (parsedMavenCommandLineSettingsFile != null) {
            this.properties.setProperty(TestingProperties.MAVENSETTINSGFILE, parsedMavenCommandLineSettingsFile);
            logger.debug((Object)("Using custom Maven settings XML file: " + parsedMavenCommandLineSettingsFile));
        } else {
            this.properties.setProperty(TestingProperties.MAVENSETTINSGFILE, "Default Maven Settings File");
        }
        String injectProperties = System.getProperty("injectproperties");
        if (injectProperties != null) {
            logger.debug((Object)("Injecting Properties to submodules: " + injectProperties));
            this.properties.setProperty(TestingProperties.INJECTPROPERTIES, injectProperties);
        } else {
            this.properties.setProperty(TestingProperties.INJECTPROPERTIES, "No Properties to Inject");
        }
        try {
            this.availableConfigurations = this.getAvailableConfigurations(this.connectorPath);
        }
        catch (ConnectorPackagingFailedException e) {
            throw new ConfigurationLoadingFailedException("Can not get available configurations", e);
        }
        String automationCredentialsProperty = System.getProperty("automation-credentials.properties");
        String resourcesPath = this.connectorPath + "/src/test/resources/";
        if (automationCredentialsProperty == null) {
            String defaultCredentialsFile = "automation-credentials.properties";
            String resourcePath = this.connectorPath + "/src/test/resources";
            String existingAutomationFile = resourcePath + "/" + defaultCredentialsFile;
            try {
                CTFFileUtils.getFileFullName(resourcePath, defaultCredentialsFile);
            }
            catch (CTFUtilsException e) {
                logger.trace((Object)("No automation default file found within " + resourcePath), (Throwable)e);
                existingAutomationFile = null;
            }
            if (existingAutomationFile == null) {
                automationCredentialsProperty = defaultCredentialsFile;
                try {
                    this.generateAutomationCredentialsFile(resourcesPath, automationCredentialsProperty);
                }
                catch (ConnectorPackagingFailedException e) {
                    throw new ConfigurationLoadingFailedException("Can not generate default automation credentials file", e);
                }
                logger.error((Object)"The automation-credentials.properties file is missing at src/test/resources and no System property has been specified for this file. An empty file has been created in src/test/resources. Please complete it with your credentials or use your own credentials file with -Dautomation-credentials.properties=yourCustomCredentialsFile (VM Arguments, System Properties or Maven Properties).");
                throw new ConfigurationLoadingFailedException("The automation-credentials.properties file is missing at src/test/resources and no System property has been specified for this file. An empty file has been created in src/test/resources (refresh your project please). Please complete it with your credentials or use your own credentials file with -Dautomation-credentials.properties=yourCustomCredentialsFile (VM Arguments, System Properties or Maven Properties).", null);
            }
            automationCredentialsProperty = defaultCredentialsFile;
            logger.warn((Object)"No System property has been specified for the automation credentials properties file. Using automation-credentials.properties file found in src/test/resources. You can use as well use a custom credentials file with -Dautomation-credentials.properties=yourCredentialsFile (VM Arguments, System Properties or Maven Properties).");
        }
        if (automationCredentialsProperty.trim().equals("")) {
            throw new ConfigurationLoadingFailedException("CONFIGURATIONFILE can not be empty .", null);
        }
        this.properties.setProperty(TestingProperties.CONFIGURATIONSFILE, automationCredentialsProperty);
        String deploymentProfile = System.getProperty("deploymentprofile");
        if (deploymentProfile == null) {
            logger.warn((Object)"No deployment profile was given. An embedded deployment profile was chosen by default. You can specify it with -Ddeploymentprofile={embedded | local | remote | cloudhub} (VM Arguments, System Properties or Maven Properties).");
            deploymentProfile = "embedded";
        }
        this.properties.setProperty(TestingProperties.DEPLOYMENTPROFILE, deploymentProfile, (Object[])DeploymentProfiles.values());
        String muleDirectory = System.getProperty("muledirectory");
        if (muleDirectory == null && deploymentProfile.equals("local")) {
            logger.error((Object)"A LOCAL deployment profile was selected but no Mule directory was given. Please specify it with -Dmuledirectory=yourMuleDirectory (VM Arguments, System Properties or Maven Properties).");
            throw new ConfigurationLoadingFailedException("A LOCAL deployment profile was selected but no Mule directory was given. Please specify it with -Dmuledirectory=yourMuleDirectory (VM Arguments, System Properties or Maven Properties).", null);
        }
        if (muleDirectory != null) {
            this.properties.setProperty(TestingProperties.MULEDIRECTORY, muleDirectory);
        }
        String muleDetectedVersion = null;
        if (deploymentProfile.equals("local") && (muleDetectedVersion = ConfigurationManager.autoDetectVersion(muleDirectory)) == null) {
            throw new ConfigurationLoadingFailedException("We could not detect a valid Mule version within your Mule directory (" + muleDirectory + "). Please check your Mule directory.", null);
        }
        String muleVersion = System.getProperty("muleversion");
        if (muleVersion != null && !ConfigurationProperties.checkProperty(muleVersion, (Object[])MuleVersions.values())) {
            throw new ConfigurationLoadingFailedException("Invalid Mule version: " + muleVersion + ". Please specify it with -Dmuleversion={mule34 | mule35 | mule36 | mule37}.", null);
        }
        if (muleVersion != null && muleDetectedVersion != null && !muleVersion.equals(muleDetectedVersion)) {
            logger.error((Object)("Different Mule versions detected. Your Mule directory (" + muleDirectory + ") seems to have a Mule runtime " + muleDetectedVersion + ", however you select a Mule version " + muleVersion + " with -Dmuleversion=" + muleVersion));
            throw new ConfigurationLoadingFailedException("Different Mule versions detected. Your Mule directory (" + muleDirectory + ") seems to have a Mule runtime " + muleDetectedVersion + ", but you select a Mule version " + muleVersion + " with -Dmuleversion=", null);
        }
        if (muleVersion == null && muleDetectedVersion != null) {
            muleVersion = muleDetectedVersion;
            logger.debug((Object)("Mule version detected from Mule directory: " + muleDetectedVersion));
        }
        if (muleVersion == null && !deploymentProfile.equals("embedded") && !deploymentProfile.equals("local")) {
            logger.error((Object)("A " + deploymentProfile + " deployment profile was selected but no Mule version was given. Please specify it with -Dmuleversion={mule34 | mule35 | mule36 | mule37} (VM Arguments, System Properties or Maven Properties)."));
            throw new ConfigurationLoadingFailedException("A " + deploymentProfile + " deployment profile was selected but no Mule version was given. Please specify it with -Dmuleversion={mule34 | mule35 | mule36 | mule37} (VM Arguments, System Properties or Maven Properties).", null);
        }
        if (!deploymentProfile.equals("embedded")) {
            this.properties.setProperty(TestingProperties.MULEVERSION, muleVersion, (Object[])MuleVersions.values());
        }
        if ((forceCompiling = System.getProperty("forcecompiling")) == null) {
            logger.debug((Object)"No Force Compiling option was given. Setting it to FALSE by default.");
            forceCompiling = "false";
        }
        this.properties.setProperty(TestingProperties.FORCECOMPILING, forceCompiling, new Object[]{Boolean.TRUE, Boolean.FALSE});
        if (forceCompiling.equals("true")) {
            try {
                this.compileConnector(this.connectorPath);
            }
            catch (ConnectorPackagingFailedException e) {
                throw new ConfigurationLoadingFailedException("Can not compile connector", e);
            }
        }
        String activeConfiguration = System.getProperty("activeconfiguration");
        String names = this.getAvailableConfigurationNames(this.availableConfigurations);
        if (activeConfiguration == null || activeConfiguration.isEmpty()) {
            if (this.availableConfigurations == null) {
                logger.error((Object)"There is no available connector configurations. Please review your connector's code.");
                throw new ConfigurationLoadingFailedException("There is no available connector configurations. Please review your connector's code.", null);
            }
            activeConfiguration = this.availableConfigurations.get(0).getXmlName();
            if (this.availableConfigurations.size() > 1) {
                logger.warn((Object)("Using connector configuration: " + activeConfiguration + ". If you like to use another one, please specify it with -Dactiveconfiguration={ " + names + " } (VM Arguments, System Properties or Maven Properties)."));
            } else {
                logger.warn((Object)("Using the only available connector configuration: " + activeConfiguration));
            }
        } else if (this.getCurrentConfig(activeConfiguration) == null) {
            logger.error((Object)("No configuration named " + activeConfiguration + " defined in the connector. Please use one of these possible configurations = { " + names + " } with -Dactiveconfiguration={ " + names + " } (VM Arguments, System Properties or Maven Properties)."));
            throw new ConfigurationLoadingFailedException("No configuration named " + activeConfiguration + " defined in the connector. Please use one of these possible configurations = { " + names + " } with -Dactiveconfiguration={ " + names + " } (VM Arguments, System Properties or Maven Properties).", null);
        }
        this.properties.setProperty(TestingProperties.ACTIVECONFIGURATION, activeConfiguration);
        try {
            this.loadCredentials(this.connectorPath);
        }
        catch (ConfigurationPropertyException e) {
            throw new ConfigurationLoadingFailedException("Can not load credentials", e);
        }
        catch (MissingRequiredConfigurationAttributesException e) {
            throw new ConfigurationLoadingFailedException("Can not load credentials", e);
        }
        String customjavahome = System.getProperty("customjavahome");
        if (customjavahome != null) {
            logger.debug((Object)("Custom Java Home: " + customjavahome));
            this.properties.setProperty(TestingProperties.CUSTOMJAVAHOME, customjavahome);
        }
        logger.debug((Object)"Loading Connector Testing Framework Properties complete.");
    }

    private String parseMavenLine(String mavenCMDLineArgs, String property) {
        String ret;
        if (mavenCMDLineArgs == null) {
            return null;
        }
        String reducedProperty = property.concat(" ");
        try {
            int spaceIndex;
            int sIndex = mavenCMDLineArgs.indexOf(reducedProperty);
            if (sIndex == -1) {
                return null;
            }
            String substring = mavenCMDLineArgs.substring(sIndex += reducedProperty.length(), mavenCMDLineArgs.length());
            String settings = substring.substring(0, spaceIndex = substring.indexOf(" "));
            ret = settings.trim().equals("") || settings.trim().equals(" ") ? null : settings;
        }
        catch (StringIndexOutOfBoundsException e) {
            logger.trace((Object)("Error parsing Maven command line : " + mavenCMDLineArgs), (Throwable)e);
            ret = null;
        }
        return ret;
    }

    private String autoDetectM2Home() {
        String mavenHomePath = this.getPathIfExists(System.getenv("M2_HOME"), new String[0]);
        if (mavenHomePath != null) {
            return mavenHomePath;
        }
        mavenHomePath = this.getPathIfExists(System.getenv("M2HOME"), new String[0]);
        if (mavenHomePath != null) {
            return mavenHomePath;
        }
        return null;
    }

    private String getPathIfExists(String basePath, String ... more) {
        try {
            Path pathFile = Paths.get(basePath, more);
            if (Files.exists(pathFile, LinkOption.NOFOLLOW_LINKS)) {
                return pathFile.toString();
            }
        }
        catch (Exception e) {
            logger.trace((Object)("Path does not exist " + basePath), (Throwable)e);
        }
        return null;
    }

    private String autodetectMavenLocalRepo() {
        String maveLocalRepoPath = this.getPathIfExists(System.getenv("USERPROFILE"), ".m2");
        if (maveLocalRepoPath != null) {
            return maveLocalRepoPath;
        }
        maveLocalRepoPath = this.getPathIfExists(System.getProperty("user.home"), ".m2");
        if (maveLocalRepoPath != null) {
            return maveLocalRepoPath;
        }
        return null;
    }

    public static String autoDetectVersion(String muleDirectory) {
        String muleVersion;
        if (muleDirectory == null) {
            return null;
        }
        String libMulePath = muleDirectory + "/lib/mule";
        try {
            File[] results = CTFFileUtils.getFilesStartingWith(libMulePath, "mule-core", "jar");
            String firstFile = results[1].getName();
            String version = firstFile.substring(firstFile.indexOf(".") - 1, firstFile.lastIndexOf("."));
            if (firstFile.contains("SNAPSHOT")) {
                version = version.substring(0, version.indexOf("-"));
            }
            muleVersion = version;
        }
        catch (CTFUtilsException e) {
            logger.trace((Object)("Imposible to detect a Mule version within: " + muleDirectory), (Throwable)e);
            logger.warn((Object)("Imposible to detect a Mule version within: " + muleDirectory));
            return null;
        }
        if (muleVersion.startsWith("3.4")) {
            return MuleVersions.mule34.toString();
        }
        if (muleVersion.startsWith("3.5")) {
            return MuleVersions.mule35.toString();
        }
        if (muleVersion.startsWith("3.6")) {
            return MuleVersions.mule36.toString();
        }
        if (muleVersion.startsWith("3.7")) {
            return MuleVersions.mule37.toString();
        }
        return null;
    }

    private String getAvailableConfigurationNames(List<ConfigElement> availableConfigs) {
        StringBuilder sb = new StringBuilder();
        for (ConfigElement ce : this.availableConfigurations) {
            sb.append(ce.getXmlName() + " | ");
        }
        String names = sb.toString();
        if (names.length() > 0) {
            names = names.substring(0, names.length() - 3);
        }
        return names;
    }

    private ConfigElement getCurrentConfig(String proposedConfiguration) {
        ConfigElement ret = null;
        for (ConfigElement ce : this.availableConfigurations) {
            if (!ce.getXmlName().equals(proposedConfiguration)) continue;
            ret = ce;
        }
        return ret;
    }

    private void generateAutomationCredentialsFile(String resourcesPath, String automationCredentialsFile) throws ConnectorPackagingFailedException {
        try {
            PrintWriter writer = new PrintWriter(resourcesPath + automationCredentialsFile, "UTF-8");
            writer.println("#");
            writer.println("# This is an auto-generated file based on the Connector Testing Framework.");
            writer.println("# Please uncomment the lines and complete it accordingly.");
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss - dd/MM/yyyy");
            writer.println("# " + dateFormat.format(new Date()));
            writer.println("#");
            for (ConfigElement ce : this.availableConfigurations) {
                for (String attr : ce.getAttributes().keySet()) {
                    writer.println("#" + ce.getXmlName() + "." + attr + "= (" + ce.getAttributes().get(attr) + ")");
                }
                if (!ce.getListAttributes().isEmpty()) {
                    writer.println();
                    writer.println("# This are list configurable parameters. Use a comma to separate values");
                }
                for (String attr : ce.getListAttributes().keySet()) {
                    writer.println("#" + ce.getXmlName() + "." + attr + "= (" + ce.getListAttributes().get(attr) + ")");
                }
                writer.println();
            }
            writer.close();
        }
        catch (IOException e) {
            throw new ConnectorPackagingFailedException("Can not generate automation credentials file", e);
        }
    }

    private List<ConfigElement> getAvailableConfigurations(String connectorPath) throws ConnectorPackagingFailedException {
        List ret;
        String xsdPath = connectorPath + "/target/generated-sources/mule/META-INF";
        String generatedXSD = null;
        try {
            generatedXSD = CTFFileUtils.getFile(xsdPath, "mule-", "xsd");
        }
        catch (CTFUtilsException e) {
            logger.trace((Object)("No XSD file found at " + xsdPath + ". Compiling connector"), (Throwable)e);
            this.compileConnector(connectorPath);
        }
        try {
            generatedXSD = CTFFileUtils.getFile(xsdPath, "mule-", "xsd");
        }
        catch (CTFUtilsException e) {
            throw new ConnectorPackagingFailedException("Can not determine XSD file", e);
        }
        XsdSampleGenerator flowGenerator = new XsdSampleGenerator();
        String temporalXML = connectorPath + "/target/temporalXMLConfiguration.xml";
        try {
            flowGenerator.generateFlows(xsdPath + "/" + generatedXSD, temporalXML);
            Files.deleteIfExists(new File(temporalXML).toPath());
        }
        catch (IOException | URISyntaxException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new ConnectorPackagingFailedException("Can not generate flows ", e);
        }
        try {
            ret = flowGenerator.getconfigElementsWithSequences();
        }
        catch (XPathExpressionException e) {
            throw new ConnectorPackagingFailedException("", e);
        }
        for (ConfigElement ce : ret) {
            ce.getAttributes().remove("name");
        }
        return ret;
    }

    private void compileConnector(String connectorPath) throws ConnectorPackagingFailedException {
        String m2home = this.getProperties().getProperty(TestingProperties.M2HOME);
        if (m2home == null) {
            throw new ConnectorPackagingFailedException("Can not compile connector - M2HOME is not set", null);
        }
        List<String> goals = Arrays.asList("compile", "-DskipTests");
        String javaHome = null;
        javaHome = this.getProperties().getProperty(TestingProperties.CUSTOMJAVAHOME);
        MuleFlowsGenerator.mavenRunnerInvoker(connectorPath, goals, m2home, javaHome, this);
    }

    private void loadCredentials(@NotNull String connectorPath) throws ConfigurationLoadingFailedException, ConfigurationPropertyException, MissingRequiredConfigurationAttributesException {
        String configFileName = this.properties.getProperty(TestingProperties.CONFIGURATIONSFILE);
        String fullPathToResource = connectorPath + "/src/test/resources/" + configFileName;
        File configFile = new File(fullPathToResource);
        if (!configFile.exists()) {
            throw new ConfigurationLoadingFailedException(configFileName + " file not found. Try running a mvn clean install on the project folder so as to generate test resources/classes.", null);
        }
        this.activeConfigurationProperties = new HashMap<String, String>();
        this.activeConfigurationListProperties = new HashMap<String, String>();
        ConfigElement ce = this.getCurrentConfig(this.properties.getProperty(TestingProperties.ACTIVECONFIGURATION));
        Set activeConfigurationAttributes = ce.getAttributes().keySet();
        Set activeConfigurationListAttributes = ce.getListAttributes().keySet();
        try {
            List<String> lines = Files.readAllLines(Paths.get(configFile.toURI()), Charset.defaultCharset());
            for (String line : lines) {
                String configAndPlaceholder;
                String configName;
                if (line.trim().equals("") || line.trim().startsWith("#") || !(configName = (configAndPlaceholder = line.substring(0, line.indexOf("="))).substring(0, configAndPlaceholder.indexOf("."))).equals(this.properties.getProperty(TestingProperties.ACTIVECONFIGURATION))) continue;
                String placeholder = configAndPlaceholder.substring(configAndPlaceholder.indexOf(".") + 1, configAndPlaceholder.length());
                String value = line.substring(line.indexOf("=") + 1, line.length());
                if (activeConfigurationAttributes.contains(placeholder)) {
                    this.activeConfigurationProperties.put(placeholder, value);
                    continue;
                }
                if (activeConfigurationListAttributes.contains(placeholder)) {
                    this.activeConfigurationListProperties.put(placeholder, value);
                    continue;
                }
                logger.debug((Object)("Ignoring property. Property: " + placeholder + " is not defined within configuration " + this.properties.getProperty(TestingProperties.ACTIVECONFIGURATION)));
            }
            if (this.activeConfigurationProperties.isEmpty() && !this.containsRequiredAttributes(ce)) {
                logger.debug((Object)("No properties found for configuration: " + this.properties.getProperty(TestingProperties.ACTIVECONFIGURATION) + " within " + this.properties.getProperty(TestingProperties.CONFIGURATIONSFILE) + ". Please make sure you have all required @Configurable not listed as optionals or have a default value associated."));
            } else {
                HashMap<String, String> confProperties = new HashMap<String, String>();
                confProperties.putAll(this.activeConfigurationProperties);
                confProperties.putAll(this.activeConfigurationListProperties);
                this.checkRequiredAttributes(confProperties);
            }
        }
        catch (IOException e) {
            throw new ConfigurationLoadingFailedException("File " + configFileName + " is incorrect defined. Please define it as <config-name>.<property> = <value> per line.", e);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ConfigurationLoadingFailedException("File " + configFileName + " is incorrect defined. Please define it as <config-name>.<property> = <value> per line.", e);
        }
    }

    private boolean containsRequiredAttributes(ConfigElement ce) {
        Map attrs = ce.getAttributes();
        for (String attr : attrs.keySet()) {
            if (!attrs.get(attr).equals("required")) continue;
            return true;
        }
        return false;
    }

    private void checkRequiredAttributes(Map<String, String> confProperties) throws ConfigurationPropertyException, MissingRequiredConfigurationAttributesException {
        String activeConfiguration = this.properties.getProperty(TestingProperties.ACTIVECONFIGURATION);
        ConfigElement ce = this.getCurrentConfig(activeConfiguration);
        Map configDefinedAtributes = ce.getAttributes();
        configDefinedAtributes.putAll(ce.getListAttributes());
        for (String attr : configDefinedAtributes.keySet()) {
            if (attr.equals("name") || !configDefinedAtributes.get(attr).equals("required") || confProperties.containsKey(attr)) continue;
            throw new MissingRequiredConfigurationAttributesException("Missing required attribute in current credentials file. " + attr + " is not present in " + this.properties.getProperty(TestingProperties.ACTIVECONFIGURATION) + " within " + this.properties.getProperty(TestingProperties.CONFIGURATIONSFILE) + ". If you have modify the @Configurable within the connector, try running mvn clean compile -DskipTests.", null);
        }
    }

    public ConfigurationProperties getProperties() {
        return this.properties;
    }

    public Map<String, String> getConnectionConfigurationListProperties() {
        return this.activeConfigurationListProperties;
    }

    public Map<String, String> getConnectionConfigurationPlaceholders() {
        return this.activeConfigurationProperties;
    }

    public Map<String, String> getRequiredLibraries() {
        if (this.requiredLibraries == null) {
            this.requiredLibraries = new HashMap<String, String>();
        }
        return this.requiredLibraries;
    }
}

