/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.shade147.mapper;

import com.thoughtworks.xstream.shade147.mapper.Mapper;
import com.thoughtworks.xstream.shade147.mapper.MapperWrapper;
import com.thoughtworks.xstream.shade147.security.AnyTypePermission;
import com.thoughtworks.xstream.shade147.security.ForbiddenClassException;
import com.thoughtworks.xstream.shade147.security.NoTypePermission;
import com.thoughtworks.xstream.shade147.security.TypePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SecurityMapper
extends MapperWrapper {
    private final List permissions;

    public SecurityMapper(Mapper wrapped) {
        this(wrapped, null);
    }

    public SecurityMapper(Mapper wrapped, TypePermission[] permissions) {
        super(wrapped);
        this.permissions = permissions == null ? new ArrayList() : new ArrayList<TypePermission>(Arrays.asList(permissions));
    }

    public void addPermission(TypePermission permission) {
        if (permission.equals(NoTypePermission.NONE) || permission.equals(AnyTypePermission.ANY)) {
            this.permissions.clear();
        }
        this.permissions.add(0, permission);
    }

    public Class realClass(String elementName) {
        Class type = super.realClass(elementName);
        for (int i = 0; i < this.permissions.size(); ++i) {
            TypePermission permission = (TypePermission)this.permissions.get(i);
            if (!permission.allows(type)) continue;
            return type;
        }
        throw new ForbiddenClassException(type);
    }
}

