/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.shade147.converters.extended;

import com.thoughtworks.xstream.shade147.converters.Converter;
import com.thoughtworks.xstream.shade147.converters.MarshallingContext;
import com.thoughtworks.xstream.shade147.converters.UnmarshallingContext;
import com.thoughtworks.xstream.shade147.core.util.HierarchicalStreams;
import com.thoughtworks.xstream.shade147.core.util.Primitives;
import com.thoughtworks.xstream.shade147.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.shade147.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.shade147.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.shade147.mapper.Mapper;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class NamedArrayConverter
implements Converter {
    private final Class arrayType;
    private final String itemName;
    private final Mapper mapper;

    public NamedArrayConverter(Class arrayType, Mapper mapper, String itemName) {
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException(arrayType.getName() + " is not an array");
        }
        this.arrayType = arrayType;
        this.mapper = mapper;
        this.itemName = itemName;
    }

    public boolean canConvert(Class type) {
        return type == this.arrayType;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        int length = Array.getLength(source);
        for (int i = 0; i < length; ++i) {
            String attributeName;
            Object item = Array.get(source, i);
            Class<Mapper.Null> itemType = item == null ? Mapper.Null.class : (this.arrayType.getComponentType().isPrimitive() ? Primitives.unbox(item.getClass()) : item.getClass());
            ExtendedHierarchicalStreamWriterHelper.startNode(writer, this.itemName, itemType);
            if (!itemType.equals(this.arrayType.getComponentType()) && (attributeName = this.mapper.aliasForSystemAttribute("class")) != null) {
                writer.addAttribute(attributeName, this.mapper.serializedClass(itemType));
            }
            if (item != null) {
                context.convertAnother(item);
            }
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<Object> list = new ArrayList<Object>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String className = HierarchicalStreams.readClassAttribute(reader, this.mapper);
            Class itemType = className == null ? this.arrayType.getComponentType() : this.mapper.realClass(className);
            Object item = Mapper.Null.class.equals((Object)itemType) ? null : context.convertAnother(null, itemType);
            list.add(item);
            reader.moveUp();
        }
        Object array = Array.newInstance(this.arrayType.getComponentType(), list.size());
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return array;
    }
}

