/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.shade147.converters.enums;

import com.thoughtworks.xstream.shade147.converters.ConversionException;
import com.thoughtworks.xstream.shade147.converters.MarshallingContext;
import com.thoughtworks.xstream.shade147.converters.UnmarshallingContext;
import com.thoughtworks.xstream.shade147.converters.collections.MapConverter;
import com.thoughtworks.xstream.shade147.core.util.Fields;
import com.thoughtworks.xstream.shade147.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.shade147.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.shade147.mapper.Mapper;
import java.lang.reflect.Field;
import java.util.EnumMap;

public class EnumMapConverter
extends MapConverter {
    private static final Field typeField = Fields.locate(EnumMap.class, Class.class, false);

    public EnumMapConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class type) {
        return typeField != null && type == EnumMap.class;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Class type = (Class)Fields.read(typeField, source);
        String attributeName = this.mapper().aliasForSystemAttribute("enum-type");
        if (attributeName != null) {
            writer.addAttribute(attributeName, this.mapper().serializedClass(type));
        }
        super.marshal(source, writer, context);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String attributeName = this.mapper().aliasForSystemAttribute("enum-type");
        if (attributeName == null) {
            throw new ConversionException("No EnumType specified for EnumMap");
        }
        Class type = this.mapper().realClass(reader.getAttribute(attributeName));
        EnumMap map = new EnumMap(type);
        this.populateMap(reader, context, map);
        return map;
    }
}

