/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import org.mule.tools.devkit.ctf.exceptions.XMLUtilsException;

public final class XMLUtils {
    private static final String TRANSFORMER_FACTORY_JDK5 = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";

    private XMLUtils() {
    }

    public static XMLStreamReader loadFile(String pathToFile) throws XMLUtilsException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader ret = null;
        try {
            InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(pathToFile), Charset.defaultCharset());
            ret = factory.createXMLStreamReader(is);
        }
        catch (XMLStreamException e) {
            throw new XMLUtilsException(e);
        }
        catch (FileNotFoundException e) {
            throw new XMLUtilsException(e);
        }
        return ret;
    }

    public static XMLStreamReader loadResource(String resourceName) throws XMLUtilsException {
        URL file = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader ret = null;
        try {
            InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(file.getPath()), Charset.defaultCharset());
            ret = factory.createXMLStreamReader(is);
        }
        catch (XMLStreamException e) {
            throw new XMLUtilsException(e);
        }
        catch (FileNotFoundException e) {
            throw new XMLUtilsException(e);
        }
        return ret;
    }

    public static XMLStreamReader getFromString(String source) throws XMLUtilsException {
        StringReader reader = new StringReader(source);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader ret = null;
        try {
            ret = factory.createXMLStreamReader(reader);
        }
        catch (XMLStreamException e) {
            throw new XMLUtilsException(e);
        }
        return ret;
    }

    public static String getFromXMLStreamReader(XMLStreamReader source) throws XMLUtilsException {
        String ret = null;
        System.setProperty("javax.xml.transform.TransformerFactory", TRANSFORMER_FACTORY_JDK5);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new StAXSource(source), new StreamResult(stringWriter));
            ret = stringWriter.toString();
        }
        catch (TransformerConfigurationException e) {
            throw new XMLUtilsException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new XMLUtilsException(e);
        }
        catch (TransformerException e) {
            throw new XMLUtilsException(e);
        }
        return ret;
    }
}

