/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.serialization;

import com.thoughtworks.xstream.shade147.XStream;
import org.mule.tools.devkit.ctf.exceptions.SerializationFailedException;
import org.mule.tools.devkit.ctf.serialization.ObjectSerializerMethods;
import org.mule.tools.devkit.ctf.serialization.ObjectsSerializer;

public final class XStreamObjectSerializer
extends ObjectsSerializer {
    private XStream xstream = new XStream();

    @Override
    protected Object serializeObject(Object obj) {
        return this.xstream.toXML(obj);
    }

    @Override
    protected Object deserializeObject(Object serializedObject) throws SerializationFailedException {
        try {
            this.xstream.ignoreUnknownElements();
            return this.xstream.fromXML((String)serializedObject);
        }
        catch (Exception e) {
            String msg = "An error ocurred when deserializing an object. It might indicates that the object serialized is different from the object being deserialized, which is probably due to different classes being loaded. You can decide to run this test in particular Mule environments annotating your test with @MinMuleRuntime (minversion={mule35 | mule 36 | mule37 }). This will execute your test only when running in Mule runtimes equals or higher than the defined one";
            throw new SerializationFailedException(msg, e);
        }
    }

    @Override
    public ObjectSerializerMethods getSerializationMethod() {
        return ObjectSerializerMethods.XSTREAM;
    }
}

