/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.serialization;

import java.beans.Introspector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import javax.xml.stream.XMLStreamReader;

public final class RPCSerializationUtils {
    private RPCSerializationUtils() {
    }

    public static boolean isJavaSerializable(Object obj) {
        try {
            ObjectOutputStream test = new ObjectOutputStream(new ByteArrayOutputStream());
            test.writeObject(obj);
        }
        catch (NotSerializableException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean isInputStreamLike(Object obj) {
        try {
            InputStream ret = (InputStream)obj;
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public static String getUnCamel(String camelCaseName) {
        String[] parts = camelCaseName.split("(?<!^)(?=[A-Z])");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            sb.append(parts[i].toLowerCase() + (i < parts.length - 1 ? "-" : ""));
        }
        return sb.toString();
    }

    public static String getFlowLikeCamel(String text) {
        String[] parts = text.split("-");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            sb.append(RPCSerializationUtils.capitalize(parts[i]));
        }
        return sb.toString();
    }

    private static String capitalize(String word) {
        String firstLetter = String.valueOf(word.charAt(0)).toUpperCase();
        return firstLetter.concat(word.substring(1));
    }

    public static String getCamel(String text) {
        return Introspector.decapitalize(RPCSerializationUtils.getFlowLikeCamel(text));
    }

    public static boolean isXMLStreamReaderLike(Object obj) {
        try {
            XMLStreamReader ret = (XMLStreamReader)obj;
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

