/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.ctf.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.mule.tools.devkit.ctf.exceptions.SerializationFailedException;
import org.mule.tools.devkit.ctf.exceptions.XMLUtilsException;
import org.mule.tools.devkit.ctf.serialization.ObjectSerializerMethods;
import org.mule.tools.devkit.ctf.serialization.RPCSerializationUtils;
import org.mule.tools.devkit.ctf.utils.XMLUtils;

public abstract class ObjectsSerializer {
    public abstract ObjectSerializerMethods getSerializationMethod();

    protected abstract Object serializeObject(Object var1) throws SerializationFailedException;

    protected abstract Object deserializeObject(Object var1) throws SerializationFailedException;

    public byte[] getSerializedArguments(List<String> methodSignature, Object[] args) throws SerializationFailedException {
        byte[] toAttach;
        if (methodSignature == null) {
            throw new SerializationFailedException("Method Descriptor is Null. Can not serialize arguments.");
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        HashMap<String, ObjectSerializerMethods> metadata = new HashMap<String, ObjectSerializerMethods>();
        int paramCounter = 0;
        for (Object obj : args) {
            if (obj == null) {
                ++paramCounter;
                continue;
            }
            String paramName = methodSignature.get(paramCounter++);
            if (RPCSerializationUtils.isInputStreamLike(obj)) {
                byte[] bytes;
                InputStream is = (InputStream)obj;
                try {
                    bytes = IOUtils.toByteArray((InputStream)is);
                }
                catch (IOException e) {
                    throw new SerializationFailedException(e);
                }
                ret.put(paramName, bytes);
                metadata.put(paramName, ObjectSerializerMethods.BYTEARRAY);
                continue;
            }
            if (RPCSerializationUtils.isXMLStreamReaderLike(obj)) {
                String stringXML;
                try {
                    stringXML = XMLUtils.getFromXMLStreamReader((XMLStreamReader)obj);
                }
                catch (XMLUtilsException e) {
                    throw new SerializationFailedException(e);
                }
                ret.put(paramName, stringXML);
                metadata.put(paramName, ObjectSerializerMethods.XMLSTREAMREADER);
                continue;
            }
            if (RPCSerializationUtils.isJavaSerializable(obj)) {
                ret.put(paramName, obj);
                metadata.put(paramName, ObjectSerializerMethods.JAVAIO);
                continue;
            }
            ret.put(paramName, this.serializeObject(obj));
            metadata.put(paramName, this.getSerializationMethod());
        }
        ret.put("metadata", metadata);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(ret);
            toAttach = bos.toByteArray();
            out.close();
        }
        catch (IOException e) {
            throw new SerializationFailedException(e);
        }
        return toAttach;
    }

    public Map<String, Object> getDeserializedArguments(byte[] payload) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(payload);
        ObjectInputStream response = new ObjectInputStream(in);
        HashMap map = (HashMap)response.readObject();
        Map metadata = (Map)map.get("metadata");
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String key : metadata.keySet()) {
            ObjectSerializerMethods entry = (ObjectSerializerMethods)((Object)metadata.get(key));
            if (entry.equals((Object)ObjectSerializerMethods.JAVAIO)) {
                ret.put(key, map.get(key));
                continue;
            }
            if (entry.equals((Object)ObjectSerializerMethods.XMLSTREAMREADER)) {
                String xmlString = (String)map.get(key);
                XMLStreamReader xmlStreamReader = XMLUtils.getFromString(xmlString);
                ret.put(key, xmlStreamReader);
                continue;
            }
            if (entry.equals((Object)ObjectSerializerMethods.BYTEARRAY)) {
                ByteArrayInputStream is = new ByteArrayInputStream((byte[])map.get(key));
                ret.put(key, is);
                continue;
            }
            if (entry.equals((Object)this.getSerializationMethod())) {
                ret.put(key, this.deserializeObject(map.get(key)));
                continue;
            }
            throw new SerializationFailedException("Something went wrong while deserializing your data. You are doomed mate.");
        }
        return ret;
    }

    public Object getSerializedResult(Object result) throws Exception {
        try {
            InputStream ret = (InputStream)result;
            return result;
        }
        catch (Exception e) {
            Object[] objects = new Object[]{result};
            ArrayList<String> signature = new ArrayList<String>();
            signature.add("result");
            return this.getSerializedArguments(signature, objects);
        }
    }

    public Object getDeserializedResult(Object response) throws Exception {
        try {
            Map<String, Object> ret = this.getDeserializedArguments((byte[])response);
            Object obj = ret.get("result");
            if (obj instanceof Exception) {
                throw (Exception)obj;
            }
            return ret.get("result");
        }
        catch (ClassCastException e) {
            ByteArrayInputStream ret = new ByteArrayInputStream((byte[])response);
            return ret;
        }
        catch (StreamCorruptedException e) {
            ByteArrayInputStream ret = new ByteArrayInputStream((byte[])response);
            return ret;
        }
    }
}

